/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.util;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import ghidra.async.AsyncLock;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.loop.AsyncLoopHandlerForFirst;
import ghidra.async.seq.AsyncSequenceHandlerForRunner;
import ghidra.util.ByteBufferUtils;
import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncProtobufMessageChannel<S extends GeneratedMessageV3, R extends GeneratedMessageV3> {
    public static final boolean LOG_READ = false;
    public static final boolean LOG_WRITE = false;
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private final AsynchronousByteChannel channel;
    protected final AsyncLock rLock = new AsyncLock();
    protected final AsyncLock wLock = new AsyncLock();
    protected ByteBuffer rBuf;
    protected ByteBuffer wBuf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void marshall(Message msg, ByteBuffer wBuf) throws IOException {
        int savedPosition = wBuf.position();
        try {
            wBuf.putInt(0);
            CodedOutputStream out = CodedOutputStream.newInstance((ByteBuffer)wBuf);
            msg.writeTo(out);
            out.flush();
            wBuf.putInt(savedPosition, out.getTotalBytesWritten());
            savedPosition = wBuf.position();
        }
        finally {
            wBuf.position(savedPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Message> R unmarshall(IOFunction<R> receiver, ByteBuffer rBuf) throws IOException {
        rBuf.flip();
        int savedPosition = rBuf.position();
        int savedLimit = rBuf.limit();
        try {
            int len = rBuf.getInt();
            if (rBuf.remaining() < len) {
                throw new BufferUnderflowException();
            }
            rBuf.limit(rBuf.position() + len);
            CodedInputStream in = CodedInputStream.newInstance((ByteBuffer)rBuf);
            R res = receiver.read(in);
            savedPosition = rBuf.position() + in.getTotalBytesRead();
            R r = res;
            return r;
        }
        finally {
            rBuf.position(savedPosition);
            rBuf.limit(savedLimit);
            rBuf.compact();
        }
    }

    public AsyncProtobufMessageChannel(AsynchronousByteChannel channel) {
        this(channel, 4096);
    }

    public AsyncProtobufMessageChannel(AsynchronousByteChannel channel, int initialBufferSize) {
        this.rBuf = ByteBuffer.allocate(initialBufferSize);
        this.wBuf = ByteBuffer.allocate(initialBufferSize);
        this.channel = channel;
    }

    public CompletableFuture<Integer> write(S msg) {
        AtomicInteger len = new AtomicInteger();
        return this.wLock.with(TypeSpec.INT, null).then((own, seq) -> {
            while (true) {
                try {
                    this.wBuf.clear();
                    AsyncProtobufMessageChannel.marshall((Message)msg, this.wBuf);
                }
                catch (CodedOutputStream.OutOfSpaceException | BufferOverflowException e) {
                    this.wBuf.clear();
                    this.wBuf = ByteBufferUtils.upsize((ByteBuffer)this.wBuf);
                    continue;
                }
                catch (IOException e) {
                    seq.exit((Throwable)e);
                    return;
                }
                break;
            }
            this.wBuf.flip();
            len.set(this.wBuf.remaining());
            AsyncUtils.loop((TypeSpec)TypeSpec.VOID, loop -> AsyncUtils.completable((TypeSpec)TypeSpec.INT, this.channel::write, (Object)this.wBuf).handle((arg_0, arg_1) -> ((AsyncLoopHandlerForFirst)loop).consume(arg_0, arg_1)), (TypeSpec)TypeSpec.INT, (l, loop) -> loop.repeatWhile(this.wBuf.hasRemaining())).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).next(arg_0, arg_1));
        }).then(seq -> seq.exit((Object)len.get())).finish();
    }

    public <R2 extends R> CompletableFuture<R2> read(IOFunction<R2> receiver) {
        return this.rLock.with(TypeSpec.obj((Object)null), null).then((own, seq) -> AsyncUtils.loop((TypeSpec)TypeSpec.obj((Object)null), loop -> {
            try {
                GeneratedMessageV3 msg = (GeneratedMessageV3)AsyncProtobufMessageChannel.unmarshall(receiver, this.rBuf);
                loop.exit((Object)msg);
            }
            catch (ArrayIndexOutOfBoundsException | BufferUnderflowException e) {
                AsyncUtils.completable((TypeSpec)TypeSpec.INT, this.channel::read, (Object)this.rBuf).handle((arg_0, arg_1) -> ((AsyncLoopHandlerForFirst)loop).consume(arg_0, arg_1));
            }
            catch (Exception e) {
                loop.exit((Throwable)e);
            }
        }, (TypeSpec)TypeSpec.INT, (lenread, loop) -> {
            if (lenread == -1) {
                loop.exit((Throwable)new EOFException("Channel is closed"));
                return;
            }
            if (lenread == 0) {
                this.rBuf = ByteBufferUtils.upsize((ByteBuffer)this.rBuf);
            }
            loop.repeat();
        }).handle((arg_0, arg_1) -> ((AsyncSequenceHandlerForRunner)seq).exit(arg_0, arg_1))).finish();
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public static interface IOFunction<R extends Message> {
        public R read(CodedInputStream var1) throws IOException;
    }
}

