/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.table.threaded.GThreadedTablePanel;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.bitpatterns.gui.ClosedPatternRowObject;
import ghidra.bitpatterns.gui.ClosedPatternTableModel;
import ghidra.bitpatterns.gui.FunctionBitPatternsExplorerPlugin;
import ghidra.bitpatterns.gui.PatternInfoRowObject;
import ghidra.bitpatterns.info.ContextRegisterFilter;
import ghidra.bitpatterns.info.PatternType;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.HelpLocation;
import ghidra.util.bytesearch.DittedBitSequence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import resources.ResourceManager;

public class ClosedPatternTableDialog
extends DialogComponentProvider {
    private DockingAction sendToClipboardAction;
    private static final String TITLE = "Closed Patterns";
    private ClosedPatternTableModel closedPatternTableModel;
    private GThreadedTablePanel<ClosedPatternRowObject> tablePanel;
    private JPanel mainPanel;
    private FunctionBitPatternsExplorerPlugin plugin;
    private PatternType type;
    private ContextRegisterFilter cRegFilter;

    public ClosedPatternTableDialog(FunctionBitPatternsExplorerPlugin plugin, List<ClosedPatternRowObject> rowObjects, Component parent, PatternType type, ContextRegisterFilter cRegFilter) {
        super(TITLE, false, true, true, false);
        this.plugin = plugin;
        this.closedPatternTableModel = this.createClosedPatternTable(rowObjects);
        this.type = type;
        this.cRegFilter = cRegFilter;
        this.mainPanel = this.createMainPanel();
        this.addWorkPanel(this.mainPanel);
        this.addCancelButton();
        this.cancelButton.setText("Dismiss");
        this.addClipboardAction();
        this.setDefaultSize(1200, 800);
        HelpLocation helpLocation = new HelpLocation("FunctionBitPatternsExplorerPlugin", "Mining_Closed_Sequential_Patterns");
        this.setHelpLocation(helpLocation);
        DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)this);
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.tablePanel = new GThreadedTablePanel((ThreadedTableModel)this.closedPatternTableModel);
        panel.add((Component)this.tablePanel, "Center");
        return panel;
    }

    private ClosedPatternTableModel createClosedPatternTable(List<ClosedPatternRowObject> rowObjects) {
        return new ClosedPatternTableModel(rowObjects, (ServiceProvider)this.plugin.getTool());
    }

    private void addClipboardAction() {
        this.sendToClipboardAction = new DockingAction("Send Selected Sequences to Clipboard", TITLE){

            public void actionPerformed(ActionContext context) {
                List rows = ClosedPatternTableDialog.this.closedPatternTableModel.getLastSelectedObjects();
                for (ClosedPatternRowObject row : rows) {
                    DittedBitSequence seq = new DittedBitSequence(row.getDittedString(), true);
                    PatternInfoRowObject pattern = new PatternInfoRowObject(ClosedPatternTableDialog.this.type, seq, ClosedPatternTableDialog.this.cRegFilter);
                    ClosedPatternTableDialog.this.plugin.addPattern(pattern);
                }
                ClosedPatternTableDialog.this.plugin.updateClipboard();
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }

            public boolean isEnabledForContext(ActionContext context) {
                return !ClosedPatternTableDialog.this.closedPatternTableModel.getLastSelectedObjects().isEmpty();
            }
        };
        ImageIcon icon = ResourceManager.loadImage((String)"images/2rightarrow.png");
        this.sendToClipboardAction.setPopupMenuData(new MenuData(new String[]{"Send Selected Sequences to Clipboard"}, (Icon)icon));
        this.sendToClipboardAction.setDescription("Sends the currently selected sequences to the clipboard");
        this.addAction((DockingActionIf)this.sendToClipboardAction);
    }

    public void close() {
        super.close();
        this.tablePanel.dispose();
    }
}

