/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.plugin;

import docking.ActionContext;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.feature.vt.api.db.VTAssociationDB;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.duallisting.VTListingContext;
import ghidra.feature.vt.gui.plugin.AddressCorrelatorManager;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTControllerListener;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.plugin.VTTaskMonitor;
import ghidra.feature.vt.gui.provider.markuptable.VTMarkupItemContext;
import ghidra.feature.vt.gui.task.SaveTask;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.feature.vt.gui.util.MatchInfoFactory;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.main.SaveDataDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainFolderListenerAdapter;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.Transaction;
import ghidra.framework.model.TransactionListener;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.AddressCorrelation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakValueHashMap;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class VTControllerImpl
implements DomainObjectListener,
OptionsChangeListener,
TransactionListener,
VTController {
    private VTSession session = null;
    private VTPlugin plugin;
    private List<VTControllerListener> listeners = new ArrayList<VTControllerListener>();
    private AddressCorrelatorManager addressCorrelatorManager;
    private MatchInfoFactory matchInfoFactory;
    private Map<Address, Symbol> destinationSymbolCache = new WeakValueHashMap();
    private Map<Address, Symbol> sourceSymbolCache = new WeakValueHashMap();
    private ToolOptions vtOptions;
    private MatchInfo currentMatchInfo;
    private MyFolderListener folderListener;

    public VTControllerImpl(VTPlugin plugin) {
        this.plugin = plugin;
        this.addressCorrelatorManager = new AddressCorrelatorManager(this);
        this.matchInfoFactory = new MatchInfoFactory();
        this.vtOptions = plugin.getTool().getOptions("Version Tracking");
        this.vtOptions.addOptionsChangeListener((OptionsChangeListener)this);
        this.folderListener = new MyFolderListener();
        plugin.getTool().getProject().getProjectData().addDomainFolderChangeListener((DomainFolderChangeListener)this.folderListener);
    }

    @Override
    public void addListener(VTControllerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(VTControllerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public VTSession getSession() {
        return this.session;
    }

    @Override
    public void openVersionTrackingSession(DomainFile domainFile) {
        if (!this.checkForUnSavedChanges()) {
            return;
        }
        try {
            VTSessionDB newSession = (VTSessionDB)domainFile.getDomainObject((Object)this, true, true, TaskMonitor.DUMMY);
            this.doOpenSession(newSession);
        }
        catch (VersionException e) {
            Msg.showError((Object)this, null, (String)("Can't open domainFile " + domainFile.getName()), (Object)e.getMessage());
        }
        catch (CancelledException e) {
            Msg.error((Object)this, (Object)"Got unexexped cancelled exception", (Throwable)e);
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)("Can't open " + domainFile.getName()), (Object)e.getMessage());
        }
    }

    @Override
    public void openVersionTrackingSession(VTSession newSession) {
        if (!this.checkForUnSavedChanges()) {
            return;
        }
        if (newSession instanceof VTSessionDB) {
            ((VTSessionDB)newSession).addConsumer(this);
        }
        this.doOpenSession(newSession);
    }

    private void doOpenSession(VTSession newSession) {
        new TaskLauncher((Task)new OpenSessionTask(newSession), this.getParentComponent(), 0);
    }

    @Override
    public boolean closeVersionTrackingSession() {
        if (this.checkForUnSavedChanges()) {
            this.closeCurrentSessionIgnoringChanges();
            return true;
        }
        return false;
    }

    @Override
    public void closeCurrentSessionIgnoringChanges() {
        if (this.session == null) {
            return;
        }
        Program sourceProgram = this.getSourceProgram();
        sourceProgram.removeListener((DomainObjectListener)this);
        Program destinationProgram = this.getDestinationProgram();
        destinationProgram.removeListener((DomainObjectListener)this);
        this.session.removeListener(this);
        if (this.session instanceof VTSessionDB) {
            ((VTSessionDB)this.session).removeTransactionListener(this);
        }
        this.plugin.getTool().setSubTitle("");
        this.disposeSession();
    }

    @Override
    public void dispose() {
        this.disposeSession();
        this.fireDisposed();
    }

    @Override
    public void readConfigState(SaveState saveState) {
        this.addressCorrelatorManager.readConfigState(saveState);
    }

    @Override
    public void writeConfigState(SaveState saveState) {
        this.addressCorrelatorManager.writeConfigState(saveState);
    }

    @Override
    public Program getSourceProgram() {
        if (this.session == null) {
            return null;
        }
        return this.session.getSourceProgram();
    }

    @Override
    public Program getDestinationProgram() {
        if (this.session == null) {
            return null;
        }
        return this.session.getDestinationProgram();
    }

    @Override
    public boolean checkForUnSavedChanges() {
        VTSessionDB sessionDB;
        if (this.session == null) {
            return true;
        }
        ArrayList<DomainFile> domainFiles = new ArrayList<DomainFile>();
        domainFiles.addAll(this.plugin.getChangedProgramsInSourceTool());
        domainFiles.addAll(this.plugin.getChangedProgramsInDestinationTool());
        if (this.session instanceof VTSessionDB && (sessionDB = (VTSessionDB)this.session).isChanged()) {
            domainFiles.add(sessionDB.getDomainFile());
        }
        if (domainFiles.isEmpty()) {
            return true;
        }
        SaveDataDialog saveDataDialog = new SaveDataDialog(this.getTool());
        return saveDataDialog.showDialog(domainFiles);
    }

    private void disposeSession() {
        if (this.session == null) {
            return;
        }
        VTSession oldSession = this.session;
        this.session = null;
        this.currentMatchInfo = null;
        this.matchInfoFactory.clearCache();
        this.sourceSymbolCache.clear();
        this.destinationSymbolCache.clear();
        this.fireSessionChanged();
        ((VTSessionDB)oldSession).release(this);
    }

    @Override
    public AddressCorrelation getCorrelator(Function source, Function destination) {
        return this.addressCorrelatorManager.getCorrelator(source, destination);
    }

    @Override
    public AddressCorrelation getCorrelator(Data source, Data destination) {
        return this.addressCorrelatorManager.getCorrelator(source, destination);
    }

    @Override
    public VTMarkupItem getCurrentMarkupForLocation(ProgramLocation location, Program program) {
        MatchInfo matchInfo = this.getMatchInfo();
        if (matchInfo == null) {
            return null;
        }
        return matchInfo.getCurrentMarkupForLocation(location, program);
    }

    @Override
    public List<VTMarkupItem> getMarkupItems(ActionContext context) {
        VTMarkupItem markupItem;
        ProgramLocation location;
        Program program;
        VTListingContext listingContext;
        ArrayList<VTMarkupItem> markupItems = new ArrayList();
        if (context instanceof VTMarkupItemContext) {
            VTMarkupItemContext itemContext = (VTMarkupItemContext)context;
            markupItems = itemContext.getSelectedMarkupItems();
        }
        if (context instanceof VTListingContext) {
            listingContext = (VTListingContext)context;
            program = listingContext.getProgram();
            location = listingContext.getLocation();
            if (location != null && (markupItem = this.getCurrentMarkupForLocation(location, program)) != null) {
                markupItems.add(markupItem);
            }
        }
        if (context instanceof CodeViewerActionContext) {
            listingContext = (CodeViewerActionContext)context;
            program = listingContext.getProgram();
            location = listingContext.getLocation();
            if (location != null && (markupItem = this.getCurrentMarkupForLocation(location, program)) != null) {
                markupItems.add(markupItem);
            }
        }
        return markupItems;
    }

    @Override
    public ToolOptions getOptions() {
        return this.vtOptions;
    }

    @Override
    public Component getParentComponent() {
        return this.plugin.getTool().getToolFrame();
    }

    @Override
    public ServiceProvider getServiceProvider() {
        return this.plugin.getTool();
    }

    @Override
    public String getVersionTrackingSessionName() {
        if (this.session != null) {
            return this.session.getName();
        }
        return "";
    }

    @Override
    public void refresh() {
        this.plugin.getTool().contextChanged(null);
    }

    @Override
    public MatchInfo getMatchInfo() {
        return this.currentMatchInfo;
    }

    @Override
    public PluginTool getTool() {
        return this.plugin.getTool();
    }

    @Override
    public void setSelectedMatch(VTMatch match) {
        VTMatch currentMatch;
        if (this.session == null) {
            return;
        }
        VTMatch vTMatch = currentMatch = this.currentMatchInfo == null ? null : this.currentMatchInfo.getMatch();
        if (match == currentMatch) {
            return;
        }
        this.currentMatchInfo = match == null ? null : this.matchInfoFactory.getMatchInfo(this, match, this.addressCorrelatorManager);
        this.fireMatchChanged(this.currentMatchInfo);
    }

    @Override
    public MatchInfo getMatchInfo(VTMatch match) {
        return match == null ? null : this.matchInfoFactory.getMatchInfo(this, match, this.addressCorrelatorManager);
    }

    private void fireSessionChanged() {
        ArrayList<VTControllerListener> copyOfListeners = new ArrayList<VTControllerListener>(this.listeners);
        for (VTControllerListener listener : copyOfListeners) {
            listener.sessionChanged(this.session);
        }
        this.plugin.getTool().contextChanged(null);
    }

    private void fireSessionUpdated(DomainObjectChangedEvent ev) {
        for (VTControllerListener listener : this.listeners) {
            listener.sessionUpdated(ev);
        }
    }

    private void fireMatchChanged(MatchInfo matchInfo) {
        for (VTControllerListener listener : this.listeners) {
            listener.matchSelected(matchInfo);
        }
    }

    private void fireDisposed() {
        for (VTControllerListener listener : this.listeners) {
            listener.disposed();
        }
    }

    @Override
    public void setSelectedMarkupItem(VTMarkupItem markupItem) {
        if (this.session == null) {
            return;
        }
        this.fireMarkupItemSelected(markupItem);
    }

    @Override
    public void markupItemStatusChanged(VTMarkupItem item) {
        VTAssociation association = item.getAssociation();
        if (association instanceof VTAssociationDB) {
            VTAssociationDB associationDB = (VTAssociationDB)association;
            associationDB.setInvalid();
        }
        this.matchInfoFactory.clearCacheForAssociation(association);
    }

    private void fireMarkupItemSelected(VTMarkupItem markupItem) {
        for (VTControllerListener listener : this.listeners) {
            listener.markupItemSelected(markupItem);
        }
    }

    @Override
    public AddressCorrelatorManager getCorrelator() {
        return this.addressCorrelatorManager;
    }

    @Override
    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        Object source = ev.getSource();
        if (source == this.session) {
            if (ev.containsEvent(4)) {
                this.matchInfoFactory.clearMatchInfoInternalCache();
            }
        } else if (source == this.getDestinationProgram()) {
            this.destinationSymbolCache.clear();
            this.checkForSave(ev);
        } else {
            this.matchInfoFactory.clearMatchInfoInternalCache();
            this.sourceSymbolCache.clear();
        }
        this.fireSessionUpdated(ev);
        this.refresh();
    }

    private void checkForSave(DomainObjectChangedEvent ev) {
        if (!ev.containsEvent(1)) {
            return;
        }
        if (this.session instanceof VTSessionDB) {
            VTSessionDB sessionDB = (VTSessionDB)this.session;
            DomainFile vtDomainFile = sessionDB.getDomainFile();
            SaveTask saveVersionTrackingTask = new SaveTask(vtDomainFile);
            TaskLauncher.launch((Task)saveVersionTrackingTask);
        }
    }

    @Override
    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        for (VTControllerListener listener : this.listeners) {
            listener.optionsChanged((Options)options);
        }
    }

    @Override
    public void gotoSourceLocation(ProgramLocation location) {
        this.plugin.gotoSourceLocation(location);
    }

    @Override
    public void gotoDestinationLocation(ProgramLocation location) {
        this.plugin.gotoDestinationLocation(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runVTTask(VtTask task) {
        Program destinationProgram = this.getDestinationProgram();
        SystemUtilities.assertTrue((destinationProgram != null ? 1 : 0) != 0, (String)"How did we run a task with no destination program?");
        if (this.hasTransactionsOpen(destinationProgram, task)) {
            return;
        }
        WrapperTask wrappedTask = new WrapperTask(task);
        int matchSetTransactionID = this.session.startTransaction(task.getTaskTitle());
        try {
            new TaskLauncher((Task)wrappedTask, this.getParentComponent());
        }
        finally {
            this.session.endTransaction(matchSetTransactionID, task.wasSuccessfull());
        }
        if (task.hasErrors()) {
            task.showErrors();
        }
    }

    private boolean hasTransactionsOpen(Program program, VtTask task) {
        Transaction transaction = program.getCurrentTransaction();
        if (transaction != null) {
            Msg.showWarn((Object)this, null, (String)("Unable to " + task.getTaskTitle()), (Object)("The program \"" + program.getName() + "\"already has a transaction open: " + transaction.getDescription()));
            return true;
        }
        Transaction matchSetTransaction = this.session.getCurrentTransaction();
        if (matchSetTransaction != null) {
            Msg.showWarn((Object)this, null, (String)("Unable to " + task.getTaskTitle()), (Object)"Transaction already open for the Match Set Manager ");
            return true;
        }
        return false;
    }

    @Override
    public AddressSetView getSelectionInSourceTool() {
        return this.plugin.getSelectionInSourceTool();
    }

    @Override
    public AddressSetView getSelectionInDestinationTool() {
        return this.plugin.getSelectionInDestinationTool();
    }

    @Override
    public void setSelectionInSourceTool(AddressSetView sourceSet) {
        this.plugin.setSelectionInSourceTool(sourceSet);
    }

    @Override
    public void setSelectionInDestinationTool(AddressSetView destinationSet) {
        this.plugin.setSelectionInDestinationTool(destinationSet);
    }

    @Override
    public Symbol getDestinationSymbol(VTAssociation association) {
        if (this.session == null) {
            return null;
        }
        Address address = association.getDestinationAddress();
        Symbol symbol = this.destinationSymbolCache.get(address);
        if (symbol == null) {
            Program program = this.session.getDestinationProgram();
            symbol = program.getSymbolTable().getPrimarySymbol(address);
            this.destinationSymbolCache.put(address, symbol);
        }
        return symbol;
    }

    @Override
    public Symbol getSourceSymbol(VTAssociation association) {
        if (this.session == null) {
            return null;
        }
        Address address = association.getSourceAddress();
        Symbol symbol = this.sourceSymbolCache.get(address);
        if (symbol == null) {
            Program program = this.session.getSourceProgram();
            symbol = program.getSymbolTable().getPrimarySymbol(address);
            this.sourceSymbolCache.put(address, symbol);
        }
        return symbol;
    }

    @Override
    public ColorizingService getSourceColorizingService() {
        return this.plugin.getSourceColorizingService();
    }

    @Override
    public ColorizingService getDestinationColorizingService() {
        return this.plugin.getDestinationColorizingService();
    }

    public void transactionEnded(DomainObjectAdapterDB domainObj) {
    }

    public void transactionStarted(DomainObjectAdapterDB domainObj, Transaction tx) {
    }

    public void undoStackChanged(DomainObjectAdapterDB domainObj) {
        this.plugin.updateUndoActions();
    }

    public void undoRedoOccurred(DomainObjectAdapterDB domainObj) {
    }

    private class WrapperTask
    extends Task {
        private final Task delegate;

        WrapperTask(Task t) {
            super(t.getTaskTitle(), t.canCancel(), t.hasProgress(), t.isModal(), t.getWaitForTaskCompleted());
            this.delegate = t;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            VTTaskMonitor.setTaskMonitor(monitor);
            try {
                this.delegate.run(monitor);
            }
            finally {
                VTTaskMonitor.setTaskMonitor(null);
            }
        }
    }

    private class OpenSessionTask
    extends Task {
        private final VTSession newSession;

        public OpenSessionTask(VTSession newSession) {
            super("Opening VT Session: " + newSession.getName(), false, false, true, true);
            this.newSession = newSession;
        }

        public void run(TaskMonitor monitor) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    VTControllerImpl.this.closeCurrentSessionIgnoringChanges();
                    VTControllerImpl.this.session = this.newSession;
                    VTControllerImpl.this.fireSessionChanged();
                    Program sourceProgram = VTControllerImpl.this.getSourceProgram();
                    sourceProgram.addListener((DomainObjectListener)VTControllerImpl.this);
                    Program destinationProgram = VTControllerImpl.this.getDestinationProgram();
                    destinationProgram.addListener((DomainObjectListener)VTControllerImpl.this);
                    this.newSession.addListener(VTControllerImpl.this);
                    if (this.newSession instanceof VTSessionDB) {
                        ((VTSessionDB)this.newSession).addTransactionListener(VTControllerImpl.this);
                    }
                    VTControllerImpl.this.plugin.getTool().setSubTitle(this.newSession.getName());
                });
            }
            catch (Exception e) {
                Msg.showError((Object)((Object)this), (Component)VTControllerImpl.this.getParentComponent(), (String)"Unexpected Exception", (Object)"Unexpected exception opening Version Tracking Session", (Throwable)e);
            }
        }
    }

    private class MyFolderListener
    extends DomainFolderListenerAdapter {
        private MyFolderListener() {
        }

        public void domainFileObjectReplaced(DomainFile file, DomainObject oldObject) {
            Program newProgram;
            if (VTControllerImpl.this.session == null) {
                return;
            }
            if (VTControllerImpl.this.session.getSourceProgram() != oldObject && VTControllerImpl.this.session.getDestinationProgram() != oldObject) {
                return;
            }
            try {
                newProgram = (Program)file.getDomainObject((Object)this, false, false, TaskMonitor.DUMMY);
            }
            catch (Exception e) {
                Msg.showError((Object)((Object)this), (Component)VTControllerImpl.this.getParentComponent(), (String)("Error opening program " + file), (Object)e);
                return;
            }
            if (oldObject == VTControllerImpl.this.session.getSourceProgram()) {
                VTControllerImpl.this.session.updateSourceProgram(newProgram);
            } else if (oldObject == VTControllerImpl.this.session.getDestinationProgram()) {
                VTControllerImpl.this.session.updateDestinationProgram(newProgram);
            }
            VTControllerImpl.this.matchInfoFactory.clearCache();
            VTControllerImpl.this.fireSessionChanged();
        }
    }
}

