/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import ghidra.util.Msg;

public enum ValueUtils {

    public static final boolean INCLUDE_STACK = false;

    public static void reportErr(Object val, Class<?> cls, Object logObj, String attributeName) {
        String message = "expected " + cls.getSimpleName() + " for " + attributeName + ", but got " + val;
        Msg.error((Object)logObj, (Object)message);
    }

    public static <T> T expectType(Object val, Class<T> cls, Object logObj, String attributeName, T fallback, boolean required) {
        if (val == null || !cls.isAssignableFrom(val.getClass())) {
            if (val != null || required) {
                ValueUtils.reportErr(val, cls, logObj, attributeName);
            }
            return fallback;
        }
        return cls.cast(val);
    }
}

