/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.bootimg.VendorBootImageHeaderV3;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class VendorBootImageHeaderV4
extends VendorBootImageHeaderV3 {
    private int vendor_ramdisk_table_size;
    private int vendor_ramdisk_table_entry_num;
    private int vendor_ramdisk_table_entry_size;
    private int bootconfig_size;

    public VendorBootImageHeaderV4(BinaryReader reader) throws IOException {
        super(reader);
        this.vendor_ramdisk_table_size = reader.readNextInt();
        this.vendor_ramdisk_table_entry_num = reader.readNextInt();
        this.vendor_ramdisk_table_entry_size = reader.readNextInt();
        this.bootconfig_size = reader.readNextInt();
    }

    public int getVendorRamdiskTableSize() {
        return this.vendor_ramdisk_table_size;
    }

    public int getVendorRamdiskTableEntryNum() {
        return this.vendor_ramdisk_table_entry_num;
    }

    public int getVendorRamdiskTableEntrySize() {
        return this.vendor_ramdisk_table_entry_size;
    }

    public int getBootConfigSize() {
        return this.bootconfig_size;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        Structure structure = (Structure)super.toDataType();
        try {
            structure.setName("vendor_boot_img_hdr_v4");
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        structure.add(DWORD, "vendor_ramdisk_table_size", null);
        structure.add(DWORD, "vendor_ramdisk_table_entry_num", null);
        structure.add(DWORD, "vendor_ramdisk_table_entry_size", null);
        structure.add(DWORD, "bootconfig_size", null);
        return structure;
    }
}

