/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import java.io.IOException;

class DebugInfoStateMachineReader {
    private static final int MAX_SIZE = 65536;

    DebugInfoStateMachineReader() {
    }

    static int computeLength(BinaryReader reader) throws IOException {
        long start = reader.getPointerIndex();
        while (reader.getPointerIndex() - start < 65536L) {
            byte opcode = reader.readNextByte();
            switch (opcode) {
                case 0: {
                    return (int)(reader.getPointerIndex() - start);
                }
                case 1: {
                    LEB128.readAsUInt32((BinaryReader)reader);
                    break;
                }
                case 2: {
                    LEB128.readAsUInt32((BinaryReader)reader);
                    break;
                }
                case 3: {
                    int register = LEB128.readAsUInt32((BinaryReader)reader);
                    int name = LEB128.readAsUInt32((BinaryReader)reader);
                    int type = LEB128.readAsUInt32((BinaryReader)reader);
                    break;
                }
                case 4: {
                    int register = LEB128.readAsUInt32((BinaryReader)reader);
                    int name = LEB128.readAsUInt32((BinaryReader)reader);
                    int type = LEB128.readAsUInt32((BinaryReader)reader);
                    int signature = LEB128.readAsUInt32((BinaryReader)reader);
                    break;
                }
                case 5: {
                    int register = LEB128.readAsUInt32((BinaryReader)reader);
                    break;
                }
                case 6: {
                    int register = LEB128.readAsUInt32((BinaryReader)reader);
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    int name = LEB128.readAsUInt32((BinaryReader)reader);
                    break;
                }
            }
        }
        return 0;
    }
}

