/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.ClassDefItem;
import ghidra.file.formats.android.dex.format.FieldIDItem;
import ghidra.file.formats.android.dex.format.MapList;
import ghidra.file.formats.android.dex.format.MethodIDItem;
import ghidra.file.formats.android.dex.format.PrototypesIDItem;
import ghidra.file.formats.android.dex.format.StringIDItem;
import ghidra.file.formats.android.dex.format.TypeIDItem;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.NumericUtilities;
import ghidra.util.datastruct.FixedSizeHashMap;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DexHeader
implements StructConverter {
    private byte[] magic;
    private byte[] version;
    private int checksum;
    private byte[] signature;
    private int fileSize;
    private int headerSize;
    private int endianTag;
    private int linkSize;
    private int linkOffset;
    private int mapOffset;
    private int stringIdsSize;
    private int stringIdsOffset;
    private int typeIdsSize;
    private int typeIdsOffset;
    private int protoIdsSize;
    private int protoIdsOffset;
    private int fieldIdsSize;
    private int fieldIdsOffset;
    private int methodIdsSize;
    private int methodIdsOffset;
    private int classDefsIdsSize;
    private int classDefsIdsOffset;
    private int dataSize;
    private int dataOffset;
    private MapList mapList;
    private List<StringIDItem> strings = new ArrayList<StringIDItem>();
    private List<TypeIDItem> types = new ArrayList<TypeIDItem>();
    private List<PrototypesIDItem> prototypes = new ArrayList<PrototypesIDItem>();
    private List<FieldIDItem> fields = new ArrayList<FieldIDItem>();
    private List<MethodIDItem> methods = new ArrayList<MethodIDItem>();
    private List<ClassDefItem> classDefs = new ArrayList<ClassDefItem>();
    private AddressCache methodXref = new AddressCache();
    private DataTypeCache typeXref = new DataTypeCache();
    private boolean parsed = false;

    public DexHeader(BinaryReader reader) throws IOException {
        this.magic = reader.readNextByteArray("dex\n".length());
        this.version = reader.readNextByteArray(4);
        this.checkMagic();
        this.checksum = reader.readNextInt();
        this.signature = reader.readNextByteArray(20);
        this.fileSize = reader.readNextInt();
        this.headerSize = reader.readNextInt();
        this.endianTag = reader.readNextInt();
        this.linkSize = reader.readNextInt();
        this.linkOffset = reader.readNextInt();
        this.mapOffset = reader.readNextInt();
        this.stringIdsSize = reader.readNextInt();
        this.stringIdsOffset = reader.readNextInt();
        this.typeIdsSize = reader.readNextInt();
        this.typeIdsOffset = reader.readNextInt();
        this.protoIdsSize = reader.readNextInt();
        this.protoIdsOffset = reader.readNextInt();
        this.fieldIdsSize = reader.readNextInt();
        this.fieldIdsOffset = reader.readNextInt();
        this.methodIdsSize = reader.readNextInt();
        this.methodIdsOffset = reader.readNextInt();
        this.classDefsIdsSize = reader.readNextInt();
        this.classDefsIdsOffset = reader.readNextInt();
        this.dataSize = reader.readNextInt();
        this.dataOffset = reader.readNextInt();
    }

    public void parse(BinaryReader reader) throws IOException {
        int i;
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        reader.setPointerIndex(DexUtil.adjustOffset(this.mapOffset, this));
        if (this.mapOffset > 0) {
            this.mapList = new MapList(reader);
        }
        reader.setPointerIndex(this.stringIdsOffset);
        for (i = 0; i < this.stringIdsSize; ++i) {
            this.strings.add(new StringIDItem(reader, this));
        }
        reader.setPointerIndex(this.typeIdsOffset);
        for (i = 0; i < this.typeIdsSize; ++i) {
            this.types.add(new TypeIDItem(reader));
        }
        reader.setPointerIndex(this.protoIdsOffset);
        for (i = 0; i < this.protoIdsSize; ++i) {
            this.prototypes.add(new PrototypesIDItem(reader, this));
        }
        reader.setPointerIndex(this.fieldIdsOffset);
        for (i = 0; i < this.fieldIdsSize; ++i) {
            this.fields.add(new FieldIDItem(reader));
        }
        reader.setPointerIndex(this.methodIdsOffset);
        for (i = 0; i < this.methodIdsSize; ++i) {
            this.methods.add(new MethodIDItem(reader));
        }
        reader.setPointerIndex(this.classDefsIdsOffset);
        for (i = 0; i < this.classDefsIdsSize; ++i) {
            this.classDefs.add(new ClassDefItem(reader, this));
        }
    }

    protected void checkMagic() throws IOException {
        if (!"dex\n".equals(new String(this.getMagic()))) {
            throw new IOException("not a dex file.");
        }
    }

    public boolean isDataOffsetRelative() {
        return false;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("header_item", 0);
        structure.add(UTF8, 8, "magic", null);
        structure.add(DWORD, "checksum", "adler-32");
        String comment = "SHA1:" + NumericUtilities.convertBytesToString((byte[])this.signature);
        structure.add((DataType)new ArrayDataType(BYTE, 20, BYTE.getLength()), "signature", comment);
        structure.add(DWORD, "fileSize", null);
        structure.add(DWORD, "headerSize", null);
        structure.add(DWORD, "endianTag", null);
        structure.add(DWORD, "linkSize", null);
        structure.add(DWORD, "linkOffset", null);
        structure.add(DWORD, "mapOffset", null);
        structure.add(DWORD, "stringIdsSize", null);
        structure.add(DWORD, "stringIdsOffset", null);
        structure.add(DWORD, "typeIdsSize", null);
        structure.add(DWORD, "typeIdsOffset", null);
        structure.add(DWORD, "protoIdsSize", null);
        structure.add(DWORD, "protoIdsOffset", null);
        structure.add(DWORD, "fieldIdsSize", null);
        structure.add(DWORD, "fieldIdsOffset", null);
        structure.add(DWORD, "methodIdsSize", null);
        structure.add(DWORD, "methodIdsOffset", null);
        structure.add(DWORD, "classDefsIdsSize", null);
        structure.add(DWORD, "classDefsIdsOffset", null);
        structure.add(DWORD, "dataSize", null);
        structure.add(DWORD, "dataOffset", null);
        structure.setCategoryPath(new CategoryPath("/dex"));
        return structure;
    }

    public byte[] getMagic() {
        return this.magic;
    }

    public byte[] getVersion() {
        return this.version;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public int getEndianTag() {
        return this.endianTag;
    }

    public int getStringIdsOffset() {
        return this.stringIdsOffset;
    }

    public int getStringIdsSize() {
        return this.stringIdsSize;
    }

    public List<StringIDItem> getStrings() {
        return Collections.unmodifiableList(this.strings);
    }

    public int getClassDefsIdsOffset() {
        return this.classDefsIdsOffset;
    }

    public int getClassDefsIdsSize() {
        return this.classDefsIdsSize;
    }

    public List<ClassDefItem> getClassDefs() {
        return Collections.unmodifiableList(this.classDefs);
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getFieldIdsOffset() {
        return this.fieldIdsOffset;
    }

    public int getFieldIdsSize() {
        return this.fieldIdsSize;
    }

    public List<FieldIDItem> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public int getMethodIdsOffset() {
        return this.methodIdsOffset;
    }

    public int getMethodIdsSize() {
        return this.methodIdsSize;
    }

    public List<MethodIDItem> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    public int getTypeIdsOffset() {
        return this.typeIdsOffset;
    }

    public int getTypeIdsSize() {
        return this.typeIdsSize;
    }

    public List<TypeIDItem> getTypes() {
        return Collections.unmodifiableList(this.types);
    }

    public int getProtoIdsOffset() {
        return this.protoIdsOffset;
    }

    public int getProtoIdsSize() {
        return this.protoIdsSize;
    }

    public List<PrototypesIDItem> getPrototypes() {
        return Collections.unmodifiableList(this.prototypes);
    }

    public int getLinkOffset() {
        return this.linkOffset;
    }

    public int getLinkSize() {
        return this.linkSize;
    }

    public int getMapOffset() {
        return this.mapOffset;
    }

    public MapList getMapList() {
        return this.mapList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address getMethodAddress(Program program, int methodId) {
        Address addr;
        if (methodId < 0 || methodId >= this.methodIdsSize) {
            return Address.NO_ADDRESS;
        }
        AddressCache addressCache = this.methodXref;
        synchronized (addressCache) {
            addr = (Address)this.methodXref.get(methodId);
            if (addr == null) {
                addr = DexUtil.toLookupAddress(program, methodId);
                try {
                    int val = program.getMemory().getInt(addr);
                    if (val != -1) {
                        addr = program.getAddressFactory().getDefaultAddressSpace().getAddress(Integer.toUnsignedLong(val));
                    }
                }
                catch (MemoryAccessException e) {
                    addr = Address.NO_ADDRESS;
                }
                this.methodXref.put(methodId, addr);
            }
        }
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataType getDataType(Program program, short typeShort) {
        DataType res;
        int typeId = typeShort & 0xFFFF;
        if (typeId < 0 || typeId >= this.typeIdsSize) {
            return null;
        }
        DataTypeCache dataTypeCache = this.typeXref;
        synchronized (dataTypeCache) {
            res = (DataType)this.typeXref.get(typeId);
            if (res == null) {
                TypeIDItem typeIDItem = this.types.get(typeId);
                String typeString = DexUtil.convertToString(this, typeIDItem.getDescriptorIndex());
                if (typeString.length() != 0 && typeString.charAt(0) == 'L') {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("/handles/");
                    buffer.append("group").append(typeId / 100);
                    buffer.append('/');
                    buffer.append("type").append(typeId);
                    DataType handleType = program.getDataTypeManager().getDataType(buffer.toString());
                    if (handleType instanceof TypeDef) {
                        res = new PointerDataType(((TypeDef)handleType).getDataType(), (DataTypeManager)program.getDataTypeManager());
                    }
                }
                if (res == null) {
                    res = DexUtil.toDataType((DataTypeManager)program.getDataTypeManager(), typeString);
                }
                if (res != null) {
                    this.typeXref.put(typeId, res);
                }
            }
        }
        return res;
    }

    public static class DataTypeCache
    extends FixedSizeHashMap<Integer, DataType> {
        private static final int MAX_ENTRIES = 100;

        public DataTypeCache() {
            super(150, 100);
        }
    }

    public static class AddressCache
    extends FixedSizeHashMap<Integer, Address> {
        private static final int MAX_ENTRIES = 500;

        public AddressCache() {
            super(700, 500);
        }
    }
}

