/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import ghidra.file.formats.android.cdex.CDexCodeItem;
import ghidra.file.formats.android.cdex.CDexHeader;
import ghidra.file.formats.android.dex.format.CodeItem;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class EncodedMethod
implements StructConverter {
    private long _fileOffset;
    private int _methodIndex;
    private int methodIndexDifference;
    private int accessFlags;
    private int codeOffset;
    private int methodIndexDifferenceLength;
    private int accessFlagsLength;
    private int codeOffsetLength;
    private CodeItem codeItem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncodedMethod(BinaryReader reader, DexHeader dexHeader) throws IOException {
        LEB128 leb128 = LEB128.readUnsignedValue((BinaryReader)reader);
        this._fileOffset = leb128.getOffset();
        this.methodIndexDifference = leb128.asUInt32();
        this.methodIndexDifferenceLength = leb128.getLength();
        leb128 = LEB128.readUnsignedValue((BinaryReader)reader);
        this.accessFlags = leb128.asUInt32();
        this.accessFlagsLength = leb128.getLength();
        leb128 = LEB128.readUnsignedValue((BinaryReader)reader);
        this.codeOffset = leb128.asUInt32();
        this.codeOffsetLength = leb128.getLength();
        if (this.codeOffset > 0) {
            long oldIndex = reader.getPointerIndex();
            try {
                reader.setPointerIndex(DexUtil.adjustOffset(this.codeOffset, dexHeader));
                this.codeItem = dexHeader instanceof CDexHeader ? new CDexCodeItem(reader) : new CodeItem(reader);
            }
            finally {
                reader.setPointerIndex(oldIndex);
            }
        }
    }

    public long getFileOffset() {
        return this._fileOffset;
    }

    void setMethodIndex(int methodIndex) {
        this._methodIndex = methodIndex;
    }

    public int getMethodIndex() {
        return this._methodIndex;
    }

    public int getMethodIndexDifference() {
        return this.methodIndexDifference;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public int getCodeOffset() {
        return this.codeOffset;
    }

    public CodeItem getCodeItem() {
        return this.codeItem;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "encoded_method_" + this.methodIndexDifferenceLength + "_" + this.accessFlagsLength + "_" + this.codeOffsetLength;
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.methodIndexDifferenceLength, BYTE.getLength()), "method_idx_diff", null);
        structure.add((DataType)new ArrayDataType(BYTE, this.accessFlagsLength, BYTE.getLength()), "access_flags", null);
        structure.add((DataType)new ArrayDataType(BYTE, this.codeOffsetLength, BYTE.getLength()), "code_off", null);
        structure.setCategoryPath(new CategoryPath("/dex/encoded_method"));
        return structure;
    }
}

