/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.vdex;

import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import java.io.IOException;

public final class VdexConstants {
    public static final String MAGIC = "vdex";
    public static final String version_o_preview = "003";
    public static final String VERSION_OREO_RELEASE = "006";
    public static final String VERSION_OREO_M2_RELEASE = "010";
    public static final String version_o_iot_preview_5 = "010";
    public static final String version_o_mr1_iot_preview_6 = "011";
    public static final String VERSION_PIE_RELEASE = "019";
    public static final String VERSION_10_RELEASE = "021";
    public static final String VERSION_11_RELEASE = "021";
    public static final String VERSION_12_RELEASE = "027";
    public static final String kDexSectionVersion = "002";
    public static final String kDexSectionVersionEmpty = "000";
    public static final String kVdexNameInDmFile = "primary.vdex";
    public static final String[] SUPPORTED_VERSIONS = new String[]{"006", "010", "019", "021", "021", "027"};

    public static final boolean isSupportedVersion(String version) {
        for (String supportedVersion : SUPPORTED_VERSIONS) {
            if (!supportedVersion.equals(version)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean isVDEX(Program program) {
        if (program == null) return false;
        MemoryBlock[] memoryBlockArray = program.getMemory().getBlocks();
        int n = memoryBlockArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryBlock block = memoryBlockArray[n2];
            try (MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), block.getStart());){
                String magic = new String(provider.readBytes(0L, (long)MAGIC.length()));
                if (MAGIC.equals(magic)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Address findVDEX(Program program) {
        try {
            if (program == null) return null;
            MemoryBlock[] memoryBlockArray = program.getMemory().getBlocks();
            int n = memoryBlockArray.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryBlock block = memoryBlockArray[n2];
                try (MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), block.getStart());){
                    String magic = new String(provider.readBytes(0L, (long)MAGIC.length()));
                    if (MAGIC.equals(magic)) {
                        Address address = block.getStart();
                        return address;
                    }
                }
                ++n2;
            }
            return null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

