/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.ext4.Ext4DirEntry;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;

public class Ext4DirEntry2
extends Ext4DirEntry
implements StructConverter {
    protected byte file_type;

    public static Ext4DirEntry2 read(BinaryReader reader) throws IOException {
        if (reader.getPointerIndex() + 8L >= reader.length()) {
            return null;
        }
        Ext4DirEntry2 result = new Ext4DirEntry2();
        result.inode = reader.readNextInt();
        result.rec_len = reader.readNextShort();
        int uNameLen = reader.readNextUnsignedByte();
        result.name_len = (short)uNameLen;
        result.file_type = reader.readNextByte();
        result.name = new String(reader.readNextByteArray(uNameLen), StandardCharsets.UTF_8);
        int extraSize = Short.toUnsignedInt(result.rec_len) - (8 + uNameLen);
        if (extraSize > 0) {
            result.extra = reader.readNextByteArray(extraSize);
        }
        return result;
    }

    private Ext4DirEntry2() {
    }

    public byte getFile_type() {
        return this.file_type;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String nameEnd = this.rec_len + "_" + (Serializable)(this.extra == null ? "0" : Integer.valueOf(this.extra.length));
        StructureDataType structure = new StructureDataType("ext4_dir_entry2_" + nameEnd, 0);
        structure.add(DWORD, "inode", null);
        structure.add(WORD, "rec_len", null);
        structure.add(BYTE, "name_len", null);
        structure.add(BYTE, "file_type", null);
        if ((this.name_len & 0xFF) > 0) {
            structure.add(STRING, this.name_len & 0xFF, "name", null);
        }
        if (this.extra != null) {
            structure.add((DataType)new ArrayDataType(BYTE, this.extra.length, BYTE.getLength()), "extra", null);
        }
        return structure;
    }
}

