/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.apple8900;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.ios.apple8900.Apple8900Header;
import ghidra.file.formats.ios.apple8900.Apple8900Util;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class Apple8900Analyzer
extends FileFormatAnalyzer {
    public boolean canAnalyze(Program program) {
        return Apple8900Util.is8900(program);
    }

    public boolean getDefaultEnablement(Program program) {
        return Apple8900Util.is8900(program);
    }

    public String getDescription() {
        return "Annotates an Apple 8900 file.";
    }

    public String getName() {
        return "Apple 8900 Annotation";
    }

    public boolean isPrototype() {
        return true;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        monitor.setMessage("Processing Apple 8900 header...");
        MemoryByteProvider provider = new MemoryByteProvider(program.getMemory(), program.getAddressFactory().getDefaultAddressSpace());
        BinaryReader reader = new BinaryReader((ByteProvider)provider, true);
        Apple8900Header header = new Apple8900Header(reader);
        if (!header.getMagic().equals("8900")) {
            log.appendMsg("Invalid 8900 file!");
            return false;
        }
        DataType headerDataType = header.toDataType();
        Data headerData = this.createData(program, this.toAddr(program, 0L), headerDataType);
        this.createFragment(program, headerDataType.getName(), headerData.getMinAddress(), headerData.getMaxAddress().add(1L));
        Address dataStart = this.toAddr(program, 2048L);
        Address dataEnd = this.toAddr(program, 2048 + header.getSizeOfData());
        this.createFragment(program, "Data", dataStart, dataEnd);
        Address footerSigStart = this.toAddr(program, 2048 + header.getFooterSignatureOffset());
        Address footerSigEnd = this.toAddr(program, 2048 + header.getFooterCertificateOffset());
        this.createFragment(program, "FooterSig", footerSigStart, footerSigEnd);
        Address footerCertStart = this.toAddr(program, 2048 + header.getFooterCertificateOffset());
        Address footerCertEnd = this.toAddr(program, 2048 + header.getFooterCertificateOffset() + header.getFooterCertificateLength());
        this.createFragment(program, "FooterCert", footerCertStart, footerCertEnd);
        this.removeEmptyFragments(program);
        return true;
    }
}

