/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dyldcache;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImage;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.file.formats.ios.dyldcache.DyldCacheDylibExtractor;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FileSystemInfo(type="dyldcachev1", description="iOS DYLD Cache Version 1", factory=GFileSystemBaseFactory.class)
public class DyldCacheFileSystem
extends GFileSystemBase {
    private DyldCacheUtils.SplitDyldCache splitDyldCache;
    private Map<GFile, Long> addrMap = new HashMap<GFile, Long>();
    private Map<GFile, Integer> indexMap = new HashMap<GFile, Integer>();

    public DyldCacheFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public void close() throws IOException {
        this.addrMap.clear();
        this.indexMap.clear();
        this.splitDyldCache.close();
        super.close();
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException {
        Long addr = this.addrMap.get(file);
        if (addr == null) {
            return null;
        }
        int index = this.indexMap.get(file);
        long machHeaderStartIndexInProvider = addr - this.splitDyldCache.getDyldCacheHeader(index).getBaseAddress();
        try {
            return DyldCacheDylibExtractor.extractDylib(machHeaderStartIndexInProvider, this.splitDyldCache, index, file.getFSRL(), monitor);
        }
        catch (MachException e) {
            throw new IOException("Invalid Mach-O header detected at 0x" + Long.toHexString(machHeaderStartIndexInProvider));
        }
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null || directory.equals(this.root)) {
            ArrayList<GFile> roots = new ArrayList<GFile>();
            for (GFile file : this.addrMap.keySet()) {
                if (file.getParentFile() != this.root && !file.getParentFile().equals(this.root)) continue;
                roots.add(file);
            }
            return roots;
        }
        ArrayList<GFile> tmp = new ArrayList<GFile>();
        for (GFile file : this.addrMap.keySet()) {
            if (file.getParentFile() == null || !file.getParentFile().equals(directory)) continue;
            tmp.add(file);
        }
        return tmp;
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        return DyldCacheUtils.isDyldCache((ByteProvider)this.provider);
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        MessageLog log = new MessageLog();
        monitor.setMessage("Opening DYLD cache...");
        this.splitDyldCache = new DyldCacheUtils.SplitDyldCache(this.provider, false, true, log, monitor);
        for (int i = 0; i < this.splitDyldCache.size(); ++i) {
            DyldCacheHeader header = this.splitDyldCache.getDyldCacheHeader(i);
            monitor.setMessage("Find files...");
            List mappedImages = header.getMappedImages();
            monitor.initialize((long)mappedImages.size());
            for (DyldCacheImage mappedImage : mappedImages) {
                GFileImpl file = GFileImpl.fromPathString((GFileSystem)this, (GFile)this.root, (String)mappedImage.getPath(), null, (boolean)false, (long)-1L);
                this.storeFile((GFile)file, mappedImage.getAddress(), i);
                monitor.checkCanceled();
                monitor.incrementProgress(1L);
            }
        }
    }

    private void storeFile(GFile file, Long addr, Integer index) {
        if (file == null) {
            return;
        }
        if (file.equals(this.root)) {
            return;
        }
        if (!this.addrMap.containsKey(file) || this.addrMap.get(file) == null) {
            this.addrMap.put(file, addr);
            this.indexMap.put(file, index);
        }
        GFile parentFile = file.getParentFile();
        this.storeFile(parentFile, null, null);
    }
}

