/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.iso9660;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.StructConverter;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDateTime;

public class ISO9660Directory
implements StructConverter {
    private int directoryRecordLength;
    private byte extendedAttributeRecordLen;
    private int locationOfExtentLE;
    private int locationOfExtentBE;
    private int dataLengthLE;
    private int dataLengthBE;
    private byte[] recordingDateTime;
    private byte fileFlag;
    private byte fileUnitSize;
    private byte interleaveGapSize;
    private short volumeSequenceNumberLE;
    private short volumeSequenceNumberBE;
    private byte fileIdentLength;
    private byte[] fileIdentifier;
    private byte paddingField;
    private boolean paddingFieldPresent;
    private long volumeIndex;
    private String name;
    private ISO9660Directory parentDir;

    public ISO9660Directory(BinaryReader reader) throws IOException {
        this(reader, null);
    }

    public ISO9660Directory(BinaryReader reader, ISO9660Directory parentDir) throws IOException {
        this.parentDir = parentDir;
        this.volumeIndex = reader.getPointerIndex();
        this.directoryRecordLength = reader.readNextByte() & 0xFF;
        this.extendedAttributeRecordLen = reader.readNextByte();
        this.locationOfExtentLE = reader.readNextInt();
        this.locationOfExtentBE = this.readIntBigEndian(reader);
        this.dataLengthLE = reader.readNextInt();
        this.dataLengthBE = this.readIntBigEndian(reader);
        this.recordingDateTime = reader.readNextByteArray(7);
        this.fileFlag = reader.readNextByte();
        this.fileUnitSize = reader.readNextByte();
        this.interleaveGapSize = reader.readNextByte();
        this.volumeSequenceNumberLE = reader.readNextShort();
        this.volumeSequenceNumberBE = this.readShortBigEndian(reader);
        this.fileIdentLength = reader.readNextByte();
        this.fileIdentifier = reader.readNextByteArray((int)this.fileIdentLength);
        this.name = this.analyzeName(this.fileIdentifier);
        if (this.fileIdentLength % 2 == 0) {
            this.paddingField = reader.readNextByte();
            this.paddingFieldPresent = true;
        } else {
            this.paddingFieldPresent = false;
        }
    }

    private int readIntBigEndian(BinaryReader reader) throws IOException {
        this.setReaderToBigEndian(reader);
        int tmp = reader.readNextInt();
        this.setReaderToLittleEndian(reader);
        return tmp;
    }

    private short readShortBigEndian(BinaryReader reader) throws IOException {
        this.setReaderToBigEndian(reader);
        short tmp = reader.readNextShort();
        this.setReaderToLittleEndian(reader);
        return tmp;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struc = new StructureDataType("ISO9600Directory", 0);
        struc.add(BYTE, "Directory Record Length", "Length of the Directory Record");
        struc.add(BYTE, "Extended Attribute Record Length", "Length of the Extended Attribute Record");
        struc.add(QWORD, "Location of Extent", "LBA in (Little/Big)Endian (4 bytes each)");
        struc.add(QWORD, "Data Length", "Size of extent. (Little/Big)Endian (4 bytes each");
        struc.add((DataType)new ArrayDataType(BYTE, this.recordingDateTime.length, 1), "Recording date/time", "Recording date and time");
        struc.add(BYTE, "File flags", "File flags");
        struc.add(BYTE, "File Unit Size", "File unit size for files recoraded in interleaved mode");
        struc.add(BYTE, "Interleave gap size", "Interleave gap size for files recorded in interleaved mode");
        struc.add(DWORD, "Volume Sequence Number", "The clume that this extent is recorded in");
        struc.add(BYTE, "File Identifier Length", "Length of the file identifier");
        struc.add((DataType)new ArrayDataType(BYTE, this.fileIdentifier.length, 1), "File Identifier", "File Identifier");
        if (this.paddingFieldPresent) {
            struc.add(BYTE, "Padding Field", "Padding Field");
        }
        return struc;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("Directory Record Length: 0x" + Integer.toHexString(this.directoryRecordLength) + "\n");
        buff.append("Extended Attribute Record Length: 0x" + Integer.toHexString(this.extendedAttributeRecordLen) + "\n");
        buff.append("Extent Location: 0x" + Integer.toHexString(this.getLocationOfExtentLE()) + "\n");
        buff.append("Data Length: 0x" + Integer.toHexString(this.getDataLengthLE()) + "\n");
        buff.append("Recording Date/Time: " + this.createDateTimeString(this.recordingDateTime) + "\n");
        buff.append(this.getFileFlagString() + "\n");
        buff.append("File Unit Size Interleaved Mode: 0x" + Integer.toHexString(this.fileUnitSize) + "\n");
        buff.append("Interleave Gap Size: 0x" + Integer.toHexString(this.interleaveGapSize) + "\n");
        buff.append("Volume Sequence Number: 0x" + Integer.toHexString(this.getVolumeSequenceNumberLE()) + "\n");
        buff.append("Length of File Identifier: 0x" + Integer.toHexString(this.fileIdentLength) + "\n");
        buff.append("File Identifier: " + new String(this.fileIdentifier).trim() + "\n");
        if (this.paddingFieldPresent) {
            buff.append("Padding Field: 0x" + Integer.toHexString(this.paddingField) + "\n");
        }
        return buff.toString();
    }

    private String analyzeName(byte[] bArr) {
        for (int i = 0; i < bArr.length; ++i) {
            if (bArr[i] >= 32) continue;
            return null;
        }
        String tmp = new String(bArr);
        return tmp;
    }

    public boolean isDirectoryFlagSet() {
        return this.getFlagBit(this.fileFlag, 1) == 1;
    }

    ByteProvider getByteProvider(ByteProvider provider, long logicalBlockSize, FSRL fsrl) {
        if (!this.isDirectoryFlagSet()) {
            long index = (long)this.locationOfExtentLE * logicalBlockSize;
            return new ByteProviderWrapper(provider, index, (long)this.dataLengthLE, fsrl);
        }
        return null;
    }

    private String getFileFlagString() {
        Object flagString = "";
        flagString = (String)flagString + "File Flags:\n";
        if (this.getFlagBit(this.fileFlag, 0) == 1) {
            flagString = (String)flagString + "\tHidden File Flag Set";
        }
        if (this.getFlagBit(this.fileFlag, 1) == 1) {
            flagString = (String)flagString + "\tDirectory Flag Set";
        }
        if (this.getFlagBit(this.fileFlag, 2) == 1) {
            flagString = (String)flagString + "\tAssociated File Flag Set";
        }
        if (this.getFlagBit(this.fileFlag, 3) == 1) {
            flagString = (String)flagString + "\tExtended Attribute Record Info Flag Set";
        }
        if (this.getFlagBit(this.fileFlag, 5) == 1) {
            flagString = (String)flagString + "\tNot Final Directory Record Flag";
        }
        return flagString;
    }

    private byte getFlagBit(byte flagByte, int flagIndex) {
        return (byte)(flagByte >>> flagIndex & 1);
    }

    private String createDateTimeString(byte[] byteArray) {
        if (byteArray == null || byteArray.length < 7) {
            return "INVALID (truncated or missing)";
        }
        byte timeOffset = byteArray[byteArray.length - 1];
        int i1 = 1900 + byteArray[0];
        byte i2 = byteArray[1];
        byte i3 = byteArray[2];
        byte i4 = byteArray[3];
        byte i5 = byteArray[4];
        byte i6 = byteArray[5];
        boolean validBuffer = true;
        if (timeOffset < -48 || timeOffset > 52) {
            validBuffer = false;
        }
        try {
            LocalDateTime.of(i1, i2, (int)i3, (int)i4, (int)i5, (int)i6);
        }
        catch (DateTimeException exception) {
            validBuffer = false;
        }
        StringBuilder builder = new StringBuilder();
        if (!validBuffer) {
            builder.append("INVALID (");
        }
        int timezoneIntegral = timeOffset / 4;
        int timezoneFractional = Math.abs(timeOffset) % 4 * 15;
        builder.append(String.format("%04d-%02d-%02d %02d:%02d:%02d GMT%c%02d%02d", i1, (int)i2, (int)i3, (int)i4, (int)i5, (int)i6, Character.valueOf(timezoneIntegral < 0 ? (char)'-' : '+'), timezoneIntegral, timezoneFractional));
        if (!validBuffer) {
            builder.append(")");
        }
        return builder.toString();
    }

    private void setReaderToBigEndian(BinaryReader reader) {
        reader.setLittleEndian(false);
    }

    private void setReaderToLittleEndian(BinaryReader reader) {
        reader.setLittleEndian(true);
    }

    public long getVolumeIndex() {
        return this.volumeIndex;
    }

    public int getDirectoryRecordLength() {
        return this.directoryRecordLength;
    }

    public byte getExtendedAttributeRecordLen() {
        return this.extendedAttributeRecordLen;
    }

    public byte[] getRecordingDateTime() {
        return this.recordingDateTime;
    }

    public byte getFileFlag() {
        return this.fileFlag;
    }

    public byte getFileUnitSize() {
        return this.fileUnitSize;
    }

    public byte getInterleaveGapSize() {
        return this.interleaveGapSize;
    }

    public int getLocationOfExtentLE() {
        return this.locationOfExtentLE;
    }

    public int getLocationOfExtentBE() {
        return this.locationOfExtentBE;
    }

    public int getDataLengthLE() {
        return this.dataLengthLE;
    }

    public int getDataLengthBE() {
        return this.dataLengthBE;
    }

    public short getVolumeSequenceNumberLE() {
        return this.volumeSequenceNumberLE;
    }

    public short getVolumeSequenceNumberBE() {
        return this.volumeSequenceNumberBE;
    }

    public byte getFileIdentLength() {
        return this.fileIdentLength;
    }

    public byte[] getFileIdentifier() {
        return this.fileIdentifier;
    }

    public byte getPaddingField() {
        return this.paddingField;
    }

    public boolean isPaddingFieldPresent() {
        return this.paddingFieldPresent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ISO9660Directory getParentDirectory() {
        return this.parentDir;
    }

    public void setParentDirectory(ISO9660Directory parentDir) {
        this.parentDir = parentDir;
    }
}

