/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.zip;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.zip.ZipFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class ZipFileSystemFactory
implements GFileSystemFactoryByteProvider<ZipFileSystem>,
GFileSystemProbeBytesOnly {
    private static final int START_BYTES_REQUIRED = 2;

    public int getBytesRequired() {
        return 2;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return startBytes[0] == 80 && startBytes[1] == 75;
    }

    public ZipFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        ZipFileSystem fs = new ZipFileSystem(targetFSRL, fsService);
        try {
            fs.mount(byteProvider, monitor);
            return fs;
        }
        catch (IOException ioe) {
            fs.close();
            throw ioe;
        }
    }
}

