/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class AddStackVarCmd
implements Command {
    private Program program;
    private Address addr;
    private int stackOffset;
    private String name;
    private DataType dataType;
    private SourceType source;
    private String errMsg = "";

    public AddStackVarCmd(Address addr, int stackOffset, String name, DataType dataType, SourceType source) {
        this.addr = addr;
        this.stackOffset = stackOffset;
        this.name = name;
        this.dataType = dataType;
        this.source = source;
    }

    public boolean applyTo(DomainObject obj) {
        Function f;
        this.program = (Program)obj;
        if (this.dataType != null) {
            this.dataType = this.dataType.clone((DataTypeManager)this.program.getDataTypeManager());
        }
        if ((f = this.program.getListing().getFunctionContaining(this.addr)) == null) {
            this.errMsg = "Address not contained within function: " + this.addr;
            return false;
        }
        StackFrame sf = f.getStackFrame();
        try {
            if (sf.createVariable(this.name, this.stackOffset, this.dataType, this.source) == null) {
                this.errMsg = "Create stack variable failed";
                return false;
            }
        }
        catch (DuplicateNameException e) {
            this.errMsg = "Variable named " + this.name + " already exists";
            return false;
        }
        catch (InvalidInputException e) {
            this.errMsg = e.getMessage();
            return false;
        }
        return true;
    }

    public String getName() {
        return "Create Stack Variable";
    }

    public String getStatusMsg() {
        return this.errMsg;
    }
}

