/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.label;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class SetLabelPrimaryCmd
implements Command {
    private SymbolTable st;
    private Address addr;
    private String name;
    private Namespace namespace;
    private String errorMsg;
    private Symbol symbol;

    public SetLabelPrimaryCmd(Address addr, String name, Namespace namespace) {
        this.addr = addr;
        this.name = name;
        this.namespace = namespace;
    }

    public boolean applyTo(DomainObject obj) {
        Program program = (Program)obj;
        this.st = program.getSymbolTable();
        Symbol oldSymbol = this.st.getPrimarySymbol(this.addr);
        if (oldSymbol == null) {
            this.errorMsg = "No Symbols at address: " + this.addr;
            return false;
        }
        if (this.namespace == null) {
            this.namespace = program.getGlobalNamespace();
        }
        this.symbol = this.st.getSymbol(this.name, this.addr, this.namespace);
        if (this.symbol == null) {
            if (!oldSymbol.isDynamic()) {
                this.errorMsg = "Symbol " + this.name + " does not exist in namespace " + this.namespace + " at address " + this.addr;
                return false;
            }
            return true;
        }
        if (oldSymbol.getSymbolType() == SymbolType.FUNCTION) {
            if (oldSymbol == this.symbol) {
                return true;
            }
            String oldName = oldSymbol.getName();
            SourceType oldSource = oldSymbol.getSource();
            Namespace oldParent = oldSymbol.getParentNamespace();
            if (this.namespace == oldSymbol.getObject()) {
                oldParent = this.namespace;
                this.namespace = oldSymbol.getParentNamespace();
            }
            SourceType symbolSource = this.symbol.getSource();
            this.symbol.delete();
            try {
                oldSymbol.setNameAndNamespace(this.name, this.namespace, symbolSource);
                this.symbol = oldSymbol;
                if (oldSource != SourceType.DEFAULT && oldSymbol.getSource() != SourceType.DEFAULT) {
                    this.st.createLabel(this.addr, oldName, oldParent, oldSource);
                }
                return true;
            }
            catch (DuplicateNameException e) {
                this.errorMsg = "Duplicate name should not have happened for " + this.name;
            }
            catch (InvalidInputException e) {
                this.errorMsg = "InvalidInputException: " + e.getMessage();
            }
            catch (CircularDependencyException e) {
                this.errorMsg = "CircularDependencyException: " + e.getMessage();
            }
            return false;
        }
        if (!this.symbol.setPrimary()) {
            this.errorMsg = "Set primary not permitted for " + this.symbol.getName(true);
            return false;
        }
        return true;
    }

    public String getStatusMsg() {
        return this.errorMsg;
    }

    public String getName() {
        return "Set Primary Label";
    }

    public Symbol getSymbol() {
        return this.symbol;
    }
}

