/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;

public class AddMemRefCmd
implements Command {
    private Address fromAddr;
    private Address toAddr;
    private RefType refType;
    private SourceType source;
    private int opIndex;
    private boolean setPrimary;

    public AddMemRefCmd(Address fromAddr, Address toAddr, SourceType source, int opIndex, boolean setPrimary) {
        this(fromAddr, toAddr, null, source, opIndex, setPrimary);
    }

    public AddMemRefCmd(Address fromAddr, Address toAddr, RefType refType, SourceType source, int opIndex) {
        this(fromAddr, toAddr, refType, source, opIndex, false);
    }

    public AddMemRefCmd(Address fromAddr, Address toAddr, RefType refType, SourceType source, int opIndex, boolean setPrimary) {
        this.fromAddr = fromAddr;
        this.toAddr = toAddr;
        this.refType = refType;
        this.source = source;
        this.opIndex = opIndex;
        this.setPrimary = setPrimary;
    }

    public boolean applyTo(DomainObject obj) {
        CodeUnit cu;
        Program p = (Program)obj;
        if (this.refType == null && (cu = p.getListing().getCodeUnitAt(this.fromAddr)) != null) {
            this.refType = RefTypeFactory.getDefaultMemoryRefType((CodeUnit)cu, (int)this.opIndex, (Address)this.toAddr, (boolean)false);
        }
        ReferenceManager refMgr = p.getReferenceManager();
        Reference ref = refMgr.addMemoryReference(this.fromAddr, this.toAddr, this.refType, this.source, this.opIndex);
        if (this.setPrimary) {
            refMgr.setPrimary(ref, this.setPrimary);
        }
        return true;
    }

    public String getStatusMsg() {
        return "";
    }

    public String getName() {
        return "Add Memory Reference";
    }
}

