/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.options.editor.ButtonPanelFactory;
import docking.util.image.ToolIconURL;
import docking.widgets.OptionDialog;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GIconLabel;
import docking.widgets.label.GLabel;
import ghidra.app.context.ListingActionContext;
import ghidra.app.merge.MergeManager;
import ghidra.app.merge.MergeManagerPlugin;
import ghidra.app.merge.MergeNavigatable;
import ghidra.app.merge.MergeProgressPanel;
import ghidra.app.merge.PhaseProgressPanel;
import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.util.viewer.format.FieldHeaderComp;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import resources.ResourceManager;

class MergeManagerProvider
extends ComponentProviderAdapter {
    static final String DEFAULT_ID = "Default Panel";
    private static final String DEFAULT_INFO = "Merge programs in progress...";
    private MergeManagerPlugin plugin;
    private JComponent currentComponent;
    private JLabel nameLabel;
    private CardLayout cardLayout;
    private JPanel defaultPanel;
    private JPanel conflictPanel;
    private PhaseProgressPanel phasePanel;
    private JButton applyButton;
    private JButton cancelButton;
    private boolean wasCanceled;
    private ImageIcon MERGE_ICON = ResourceManager.loadImage((String)"images/Merge.png");
    private JPanel mainPanel;

    public MergeManagerProvider(MergeManagerPlugin plugin, String title) {
        super(plugin.getTool(), "Merge Manager", plugin.getName());
        this.plugin = plugin;
        this.setTitle(title);
        this.setDefaultWindowPosition(WindowPosition.TOP);
        this.setIcon(this.MERGE_ICON);
        this.tool.setIconURL(new ToolIconURL("Merge.png"));
        this.setHelpLocation(new HelpLocation("Repository", "Merge_Manager"));
        this.create();
        this.tool.addComponentProvider((ComponentProvider)this, true);
        this.tool.showComponentHeader((ComponentProvider)this, false);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public ActionContext getActionContext(MouseEvent event) {
        MergeManager mergeManager = this.plugin.getMergeManager();
        if (event != null && event.getSource() instanceof FieldHeaderComp) {
            FieldHeaderComp comp = (FieldHeaderComp)event.getSource();
            FieldHeaderLocation fieldHeaderLocation = comp.getFieldHeaderLocation(event.getPoint());
            return this.createContext(fieldHeaderLocation);
        }
        if (mergeManager instanceof ProgramMultiUserMergeManager) {
            ListingMergePanel listingMergePanel;
            Object actionContext;
            ProgramMultiUserMergeManager programMergeManager = (ProgramMultiUserMergeManager)mergeManager;
            MergeNavigatable navigatable = programMergeManager.navigatable;
            if (this.currentComponent instanceof ListingMergePanel && (actionContext = (listingMergePanel = (ListingMergePanel)this.currentComponent).getActionContext(event)) instanceof ProgramLocation) {
                ListingActionContext listingActionContext = new ListingActionContext((ComponentProvider)this, navigatable, (ProgramLocation)actionContext);
                return listingActionContext;
            }
            ProgramLocation programLocation = navigatable.getLocation();
            ListingActionContext listingActionContext = new ListingActionContext((ComponentProvider)this, navigatable, programLocation);
            return listingActionContext;
        }
        return null;
    }

    void setApplyEnabled(boolean state) {
        this.applyButton.setEnabled(state);
        if (state) {
            this.applyButton.requestFocus();
        }
    }

    void setMergeComponent(JComponent component, String componentID) {
        if (this.currentComponent != null) {
            this.cardLayout.removeLayoutComponent(this.currentComponent);
        }
        this.currentComponent = component;
        this.conflictPanel.add((Component)component, componentID);
        this.cardLayout.show(this.conflictPanel, componentID);
    }

    void removeMergeComponent(JComponent component) {
        this.cardLayout.removeLayoutComponent(component);
        this.conflictPanel.remove(component);
    }

    void updateMergeDescription(String description) {
        this.nameLabel.setText(description);
    }

    void showDefaultComponent() {
        this.cardLayout.show(this.conflictPanel, DEFAULT_ID);
    }

    void dispose() {
        this.tool.showComponentProvider((ComponentProvider)this, false);
        this.tool.removeComponentProvider((ComponentProvider)this);
    }

    boolean mergeWasCanceled() {
        return this.wasCanceled;
    }

    private void applyCallback() {
        this.plugin.getMergeManager().apply();
        this.setApplyEnabled(false);
    }

    void cancelCallback(boolean force) {
        boolean cancel = force;
        if (!force) {
            int choice = OptionDialog.showYesNoDialogWithNoAsDefaultButton(null, (String)"Confirm Cancel Merge", (String)"Warning!  Cancel causes the entire merge process to be canceled.\nDo you want to cancel the Merge Process?");
            boolean bl = cancel = choice == 1;
        }
        if (cancel) {
            this.wasCanceled = true;
            MergeManager mergeManager = this.plugin.getMergeManager();
            if (mergeManager != null) {
                mergeManager.cancel();
            }
        }
    }

    private void create() {
        this.mainPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.conflictPanel = new JPanel(this.cardLayout);
        this.mainPanel.setLayout(new BorderLayout(0, 10));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.nameLabel = new GDLabel("Merge Programs", 2);
        JPanel iconPanel = new JPanel();
        new BoxLayout(iconPanel, 0);
        iconPanel.add(Box.createHorizontalStrut(5));
        iconPanel.add((Component)new GIconLabel((Icon)this.MERGE_ICON));
        iconPanel.add(Box.createHorizontalStrut(5));
        iconPanel.add(this.nameLabel);
        JPanel imagePanel = new JPanel(new BorderLayout());
        imagePanel.add((Component)iconPanel, "West");
        this.mainPanel.add((Component)imagePanel, "North");
        this.mainPanel.add((Component)this.conflictPanel, "Center");
        this.mainPanel.add((Component)this.createButtonPanel(), "South");
        this.createDefaultPanel();
        this.cardLayout.show(this.conflictPanel, DEFAULT_ID);
        Dimension d = this.conflictPanel.getPreferredSize();
        this.mainPanel.setPreferredSize(new Dimension(d.width, d.height + 20));
    }

    private JPanel createButtonPanel() {
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(e -> this.applyCallback());
        this.applyButton.setEnabled(false);
        this.applyButton.setToolTipText("Apply conflict resolution");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(e -> this.cancelCallback(false));
        JPanel panel = ButtonPanelFactory.createButtonPanel((JButton[])new JButton[]{this.applyButton, this.cancelButton}, (char)'0');
        return panel;
    }

    private void createDefaultPanel() {
        this.defaultPanel = new JPanel((LayoutManager)new VerticalLayout(5));
        this.defaultPanel.setName(DEFAULT_ID);
        MergeProgressPanel progressPanel = this.plugin.getMergeManager().getMergeProgressPanel();
        this.phasePanel = new PhaseProgressPanel("Progress In Current Phase");
        this.defaultPanel.add(progressPanel);
        this.defaultPanel.add((Component)new GLabel(" "));
        this.defaultPanel.add(this.phasePanel);
        this.conflictPanel.add((Component)this.defaultPanel, DEFAULT_ID);
        this.conflictPanel.setPreferredSize(new Dimension(610, 500));
        this.cardLayout.show(this.conflictPanel, DEFAULT_ID);
    }

    public void setCurrentProgress(int currentPercentProgress) {
        this.phasePanel.setProgress(currentPercentProgress);
    }

    public void updateProgressTitle(String newTitle) {
        this.phasePanel.setTitle(newTitle);
    }

    public void updateProgressDetails(String message) {
        if (message == null) {
            message = DEFAULT_INFO;
        }
        this.phasePanel.setMessage(message);
    }
}

