/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import generic.concurrent.ConcurrentQ;
import generic.concurrent.ConcurrentQBuilder;
import generic.concurrent.GThreadPool;
import generic.concurrent.QCallback;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.MutabilitySettingsDefinition;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ConstantPropagationAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = " Constant Reference Analyzer";
    private static final String DESCRIPTION = " Constant Propagation Analyzer for constant references computed with multiple instructions.";
    protected static final String OPTION_NAME = "Function parameter/return Pointer analysis";
    protected static final String OPTION_DESCRIPTION = "Turn on to check if values passed as parameters or returned could be pointer references";
    protected static final boolean OPTION_DEFAULT_VALUE = true;
    protected static final String STORED_OPTION_NAME = "Stored Value Pointer analysis";
    protected static final String STORED_OPTION_DESCRIPTION = "Turn on to check if values stored into memory or the stack could be pointer references";
    protected static final boolean STORED_OPTION_DEFAULT_VALUE = true;
    protected static final String TRUSTWRITEMEM_OPTION_NAME = "Trust values read from writable memory";
    protected static final String TRUSTWRITEMEM_OPTION_DESCRIPTION = "Turn on to trust values read from writable memory";
    protected static final boolean TRUSTWRITEMEM_OPTION_DEFAULT_VALUE = true;
    protected static final String MAXTHREADCOUNT_OPTION_NAME = "Max Threads";
    protected static final String MAXTHREADCOUNT_OPTION_DESCRIPTION = "Maximum threads for constant propagation.  Too many threads causes thrashing in DB.";
    protected static final int MAXTHREADCOUNT_OPTION_DEFAULT_VALUE = 2;
    protected static final String MINKNOWNREFADDRESS_OPTION_NAME = "Min absolute reference";
    protected static final String MINKNOWNREFADDRESS_OPTION_DESCRIPTION = "Minimum address for calcuated constant store/load references";
    protected static final int MINKNOWNREFADDRESS_OPTION_DEFAULT_VALUE = 4;
    protected static final String MINSPECULATIVEREFADDRESS_OPTION_NAME = "Speculative reference min";
    protected static final String MINSPECULATIVEREFADDRESS_OPTION_DESCRIPTION = "Minimum speculative reference address for offsets and parameters";
    protected static final int MINSPECULATIVEREFADDRESS_OPTION_DEFAULT_VALUE = 1024;
    protected static final String MAXSPECULATIVEREFADDRESS_OPTION_NAME = "Speculative reference max";
    protected static final String MAXSPECULATIVEREFADDRESS_OPTION_DESCRIPTION = "Maxmimum speculative reference address offset from the end of memory for offsets and parameters";
    protected static final int MAXSPECULATIVEREFADDRESS_OPTION_DEFAULT_VALUE = 256;
    protected static final int NOTIFICATION_INTERVAL = 100;
    protected boolean checkParamRefsOption = true;
    protected boolean checkStoredRefsOption = true;
    protected boolean trustWriteMemOption = true;
    protected int maxThreadCount = 2;
    protected long minStoreLoadRefAddress = 4L;
    protected long minSpeculativeRefAddress = 1024L;
    protected long maxSpeculativeRefAddress = 256L;
    protected boolean followConditional = false;
    static final HashSet<String> handledProcessors = new HashSet();
    protected String processorName = "Basic";
    protected AddressSetView EMPTY_ADDRESS_SET = new AddressSet();

    public ConstantPropagationAnalyzer() {
        this("Basic");
    }

    public ConstantPropagationAnalyzer(String processorName) {
        super(processorName + NAME, processorName + DESCRIPTION, AnalyzerType.INSTRUCTION_ANALYZER);
        ConstantPropagationAnalyzer.claimProcessor(processorName);
        this.processorName = processorName;
        this.setPriority(AnalysisPriority.REFERENCE_ANALYSIS.before().before().before().before());
    }

    public static void claimProcessor(String processorName) {
        handledProcessors.add(processorName);
    }

    @Override
    public boolean canAnalyze(Program program) {
        this.checkParamRefsOption = program.getDefaultPointerSize() > 2;
        this.checkParamRefsOption &= !(program.getAddressFactory().getDefaultAddressSpace() instanceof SegmentedAddressSpace);
        if (this.processorName.equals("Basic")) {
            return !handledProcessors.contains(program.getLanguage().getProcessor().toString());
        }
        return program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)this.processorName));
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        set = this.removeUninitializedBlock(program, set);
        try {
            HashSet<Address> locations = new HashSet<Address>();
            AddressSetView unanalyzedSet = this.findLocations(program, set, locations, monitor);
            int locationCount = locations.size();
            monitor.initialize((long)locationCount);
            if (locationCount != 0) {
                AddressSetView resultSet = this.runAddressAnalysis(program, locations, monitor);
                unanalyzedSet = unanalyzedSet.subtract(resultSet);
            }
            if (!unanalyzedSet.isEmpty()) {
                this.analyzeSet(program, unanalyzedSet, monitor);
            }
        }
        catch (CancelledException ce) {
            throw ce;
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"caught exception", (Throwable)e);
            e.printStackTrace();
        }
        return true;
    }

    protected AddressSetView removeUninitializedBlock(Program program, AddressSetView set) {
        MemoryBlock[] blocks;
        for (MemoryBlock block : blocks = program.getMemory().getBlocks()) {
            if (block.isInitialized()) continue;
            AddressSet blocksSet = new AddressSet();
            blocksSet.addRange(block.getStart(), block.getEnd());
            set = set.subtract((AddressSetView)blocksSet);
        }
        return set;
    }

    protected AddressSetView findLocations(Program program, AddressSetView set, Set<Address> locations, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Finding function locations...");
        long total = set.getNumAddresses();
        monitor.initialize(total);
        AddressSet inBodySet = new AddressSet();
        Iterator fiter = program.getFunctionManager().getFunctionsOverlapping(set);
        while (fiter.hasNext()) {
            monitor.checkCanceled();
            Function function = (Function)fiter.next();
            locations.add(function.getEntryPoint());
            inBodySet.add(function.getBody());
        }
        monitor.setProgress(total - inBodySet.getNumAddresses());
        set = set.subtract((AddressSetView)inBodySet);
        ReferenceManager referenceManager = program.getReferenceManager();
        AddressIterator referenceDestinationIterator = referenceManager.getReferenceDestinationIterator(set, true);
        AddressSet outOfBodySet = new AddressSet();
        block1: while (referenceDestinationIterator.hasNext()) {
            monitor.checkCanceled();
            Address address = referenceDestinationIterator.next();
            ReferenceIterator referencesTo = referenceManager.getReferencesTo(address);
            while (referencesTo.hasNext()) {
                Reference reference = referencesTo.next();
                if (!reference.getReferenceType().isCall()) continue;
                locations.add(address);
                outOfBodySet.add(address);
                continue block1;
            }
        }
        monitor.incrementProgress(outOfBodySet.getNumAddresses());
        set = set.subtract((AddressSetView)outOfBodySet);
        outOfBodySet = new AddressSet();
        AddressRangeIterator addressRanges = set.getAddressRanges();
        while (addressRanges.hasNext()) {
            monitor.checkCanceled();
            AddressRange addressRange = (AddressRange)addressRanges.next();
            locations.add(addressRange.getMinAddress());
            outOfBodySet.add(addressRange.getMinAddress());
        }
        monitor.incrementProgress(outOfBodySet.getNumAddresses());
        set = set.subtract((AddressSetView)outOfBodySet);
        return set;
    }

    protected AddressSetView runAddressAnalysis(final Program program, Set<Address> locations, TaskMonitor monitor) throws CancelledException, InterruptedException, Exception {
        monitor.checkCanceled();
        final AddressSet analyzedSet = new AddressSet();
        if (locations.isEmpty()) {
            return analyzedSet;
        }
        GThreadPool pool = AutoAnalysisManager.getSharedAnalsysThreadPool();
        monitor.setMessage("Analyzing functions...");
        monitor.setMaximum((long)locations.size());
        QCallback<Address, AddressSetView> callback = new QCallback<Address, AddressSetView>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public AddressSetView process(Address loc, TaskMonitor taskMonitor) {
                AddressSet addressSet = analyzedSet;
                synchronized (addressSet) {
                    if (analyzedSet.contains(loc)) {
                        taskMonitor.incrementProgress(1L);
                        return ConstantPropagationAnalyzer.this.EMPTY_ADDRESS_SET;
                    }
                }
                try {
                    AddressSetView result = ConstantPropagationAnalyzer.this.analyzeLocation(program, loc, null, taskMonitor);
                    AddressSet addressSet2 = analyzedSet;
                    synchronized (addressSet2) {
                        analyzedSet.add(result);
                    }
                    taskMonitor.incrementProgress(1L);
                    return result;
                }
                catch (CancelledException e) {
                    return null;
                }
            }
        };
        if (this.maxThreadCount > pool.getMaxThreadCount() || this.maxThreadCount < 1) {
            this.maxThreadCount = 1;
        }
        ConcurrentQ queue = new ConcurrentQBuilder().setThreadPool(pool).setMaxInProgress(this.maxThreadCount).setMonitor(monitor).build((QCallback)callback);
        queue.add(locations);
        queue.waitUntilDone();
        return analyzedSet;
    }

    public void analyzeSet(Program program, AddressSetView setToAnalyze, TaskMonitor monitor) throws CancelledException {
        long totalNumAddresses = setToAnalyze.getNumAddresses();
        monitor.initialize(totalNumAddresses);
        Listing listing = program.getListing();
        int count = 0;
        AddressSet todoSet = new AddressSet(setToAnalyze);
        while (!todoSet.isEmpty()) {
            Address start;
            AddressSetView resultSet;
            Address nextAddr;
            Instruction instr;
            monitor.checkCanceled();
            if (count++ % 100 == 0) {
                monitor.setProgress(totalNumAddresses - todoSet.getNumAddresses());
            }
            if ((instr = listing.getInstructionAt(nextAddr = todoSet.getMinAddress())) == null) {
                instr = listing.getInstructionAfter(nextAddr);
                if (instr == null) break;
                nextAddr = instr.getMinAddress();
                if (!todoSet.contains(nextAddr)) {
                    todoSet.deleteFromMin(nextAddr);
                    continue;
                }
            }
            if ((resultSet = this.analyzeLocation(program, start = instr.getMinAddress(), (AddressSetView)todoSet, monitor)) == null) continue;
            if (!start.equals((Object)todoSet.getMinAddress())) {
                todoSet.deleteFromMin(start);
            }
            todoSet.delete(resultSet);
        }
    }

    public AddressSetView analyzeLocation(Program program, Address start, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        monitor.checkCanceled();
        if (program.getListing().getInstructionAt(start) == null) {
            return new AddressSet();
        }
        Address flowStart = start;
        AddressSetView flowSet = set;
        Function func = program.getFunctionManager().getFunctionContaining(start);
        if (func != null) {
            AddressSetView body = func.getBody();
            if (set != null && body.getNumAddresses() > set.getNumAddresses()) {
                flowSet = body;
            }
            flowStart = func.getEntryPoint();
        }
        SymbolicPropogator symEval = new SymbolicPropogator(program);
        symEval.setParamRefCheck(this.checkParamRefsOption);
        symEval.setReturnRefCheck(this.checkParamRefsOption);
        symEval.setStoredRefCheck(this.checkStoredRefsOption);
        return this.flowConstants(program, flowStart, flowSet, symEval, monitor);
    }

    public AddressSetView flowConstants(Program program, Address flowStart, AddressSetView flowSet, SymbolicPropogator symEval, TaskMonitor monitor) throws CancelledException {
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(this.trustWriteMemOption, this.minStoreLoadRefAddress, this.minSpeculativeRefAddress, this.maxSpeculativeRefAddress);
        return symEval.flowConstants(flowStart, flowSet, (ContextEvaluator)eval, true, monitor);
    }

    public final void markDataAsConstant(Data data) {
        SettingsDefinition[] settings;
        for (SettingsDefinition setting : settings = data.getDataType().getSettingsDefinitions()) {
            if (!(setting instanceof MutabilitySettingsDefinition)) continue;
            MutabilitySettingsDefinition mutabilitySetting = (MutabilitySettingsDefinition)setting;
            mutabilitySetting.setChoice((Settings)data, 2);
        }
    }

    public final void createData(Program program, Address address, int size) {
        if (size < 1 || size > 8) {
            return;
        }
        if (!program.getListing().isUndefined(address, address)) {
            Data data = program.getListing().getDataAt(address);
            if (data == null) {
                return;
            }
            if (data.getDataType() instanceof Undefined) {
                if (data.getLength() >= size) {
                    return;
                }
                program.getListing().clearCodeUnits(address, address, false);
            } else {
                return;
            }
        }
        DataType dt = Undefined.getUndefinedDataType((int)size);
        try {
            program.getListing().createData(address, dt);
        }
        catch (CodeUnitInsertionException codeUnitInsertionException) {
        }
        catch (DataTypeConflictException dataTypeConflictException) {
            // empty catch block
        }
    }

    @Override
    public boolean getDefaultEnablement(Program p) {
        return true;
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME, (Object)this.checkParamRefsOption, null, OPTION_DESCRIPTION);
        options.registerOption(STORED_OPTION_NAME, (Object)this.checkStoredRefsOption, null, STORED_OPTION_DESCRIPTION);
        options.registerOption(TRUSTWRITEMEM_OPTION_NAME, (Object)this.trustWriteMemOption, null, TRUSTWRITEMEM_OPTION_DESCRIPTION);
        options.registerOption(MAXTHREADCOUNT_OPTION_NAME, (Object)this.maxThreadCount, null, MAXTHREADCOUNT_OPTION_DESCRIPTION);
        options.registerOption(MINKNOWNREFADDRESS_OPTION_NAME, (Object)this.minStoreLoadRefAddress, null, MINKNOWNREFADDRESS_OPTION_DESCRIPTION);
        long size = program.getAddressFactory().getDefaultAddressSpace().getSize();
        this.minSpeculativeRefAddress = size * 16L;
        options.registerOption(MINSPECULATIVEREFADDRESS_OPTION_NAME, (Object)this.minSpeculativeRefAddress, null, MINSPECULATIVEREFADDRESS_OPTION_DESCRIPTION);
        this.maxSpeculativeRefAddress = size * 8L;
        options.registerOption(MAXSPECULATIVEREFADDRESS_OPTION_NAME, (Object)this.maxSpeculativeRefAddress, null, MAXSPECULATIVEREFADDRESS_OPTION_DESCRIPTION);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.checkParamRefsOption = options.getBoolean(OPTION_NAME, this.checkParamRefsOption);
        this.checkStoredRefsOption = options.getBoolean(STORED_OPTION_NAME, this.checkStoredRefsOption);
        this.trustWriteMemOption = options.getBoolean(TRUSTWRITEMEM_OPTION_NAME, this.trustWriteMemOption);
        this.maxThreadCount = options.getInt(MAXTHREADCOUNT_OPTION_NAME, this.maxThreadCount);
        this.minStoreLoadRefAddress = options.getLong(MINKNOWNREFADDRESS_OPTION_NAME, this.minStoreLoadRefAddress);
        this.minSpeculativeRefAddress = options.getLong(MINSPECULATIVEREFADDRESS_OPTION_NAME, this.minSpeculativeRefAddress);
        this.maxSpeculativeRefAddress = options.getLong(MAXSPECULATIVEREFADDRESS_OPTION_NAME, this.maxSpeculativeRefAddress);
    }
}

