/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.hover;

import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.codebrowser.hover.TruncatedTextListingHover;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Shows full text over truncated fields", description="This plugin extends the functionality of the code browser by adding a \tooltip\" over fields in the browser that don't have the space to display all relevant information associated with that field.  For example, if a comment is too long to display, it will end with \"...\" This plugin will then provide a popup displaying the full text when the mouse is moved over that field.", servicesProvided={ListingHoverService.class})
public class TruncatedTextListingHoverPlugin
extends Plugin {
    private TruncatedTextListingHover truncatedTextHoverService;

    public TruncatedTextListingHoverPlugin(PluginTool tool) {
        super(tool);
        this.truncatedTextHoverService = new TruncatedTextListingHover(tool);
        this.registerServiceProvided(ListingHoverService.class, this.truncatedTextHoverService);
    }

    public void dispose() {
        this.truncatedTextHoverService.dispose();
    }
}

