/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.util.exception.UsrException;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class ArrayAction
extends CompositeEditorTableAction {
    private static final ImageIcon ICON = ResourceManager.loadImage((String)"images/Array.png");
    public static final String ACTION_NAME = "Create Array";
    private static final String GROUP_NAME = "3_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Create an array";
    private static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(91, 0);
    private static String[] POPUP_PATH = new String[]{"Create Array"};

    public ArrayAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Create Array", GROUP_NAME, POPUP_PATH, null, ICON);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(KEY_STROKE));
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        try {
            this.model.createArray();
        }
        catch (UsrException e1) {
            this.model.setStatus(e1.getMessage());
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.model.isArrayAllowed());
    }
}

