/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeViewerModelListener;
import ghidra.app.plugin.core.compositeeditor.DataTypeHelper;
import ghidra.app.plugin.core.compositeeditor.OriginalCompositeListener;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.table.AbstractTableModel;
import utility.function.Callback;

class CompositeViewerModel
extends AbstractTableModel
implements DataTypeManagerChangeListener {
    protected boolean updatingSelection = false;
    protected Composite originalComposite;
    protected DataTypePath originalDataTypePath;
    protected long compositeID;
    protected Composite viewComposite;
    protected DataTypeManager viewDTM;
    private List<CompositeViewerModelListener> modelListeners = new ArrayList<CompositeViewerModelListener>();
    private List<OriginalCompositeListener> originalListeners = new ArrayList<OriginalCompositeListener>();
    private String status = "";
    protected FieldSelection selection;
    protected String[] headers = new String[]{"Offset", "Length", "Mnemonic", "DataType", "FieldName", "Comment"};
    private static final int OFFSET = 0;
    private static final int LENGTH = 1;
    private static final int MNEMONIC = 2;
    private static final int DATATYPE = 3;
    private static final int NAME = 4;
    private static final int COMMENT = 5;
    protected int[] columnOffsets = new int[this.headers.length];
    protected int[] columnWidths = new int[]{75, 75, 100, 100, 100, 150};
    protected int width = 0;
    protected int leftMargin = 10;
    protected int row = -1;
    protected int column = -1;
    protected CompositeEditorProvider provider;
    protected boolean showHexNumbers = false;

    CompositeViewerModel(CompositeEditorProvider provider) {
        this.provider = provider;
        this.selection = new FieldSelection();
        this.adjustWidth();
        this.adjustOffsets();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == this.getDataTypeColumn()) {
            return DataTypeInstance.class;
        }
        return String.class;
    }

    public int getOffsetColumn() {
        return 0;
    }

    public int getLengthColumn() {
        return 1;
    }

    public int getMnemonicColumn() {
        return 2;
    }

    public int getDataTypeColumn() {
        return 3;
    }

    public int getNameColumn() {
        return 4;
    }

    public int getCommentColumn() {
        return 5;
    }

    void dispose() {
        this.unload();
    }

    public boolean isLoaded() {
        return this.viewComposite != null;
    }

    void load(Composite dataType) {
        DataTypeManager originalDTM;
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        if (dataTypeManager == null) {
            throw new IllegalArgumentException("Datatype " + dataType.getName() + " doesn't have a data type manager specified.");
        }
        CategoryPath categoryPath = dataType.getCategoryPath();
        if (categoryPath == null) {
            throw new IllegalArgumentException("Datatype " + dataType.getName() + " doesn't have a category path specified.");
        }
        Category category = dataTypeManager.getCategory(categoryPath);
        if (category == null) {
            throw new IllegalArgumentException("Datatype " + dataType.getName() + " doesn't have a category specified.");
        }
        if (this.isLoaded()) {
            this.unload();
        }
        DataTypeManager dataTypeManager2 = originalDTM = this.originalComposite != null ? this.originalComposite.getDataTypeManager() : null;
        if (originalDTM != null) {
            originalDTM.removeDataTypeManagerListener((DataTypeManagerChangeListener)this);
        }
        this.originalComposite = dataType;
        this.originalDataTypePath = dataType.getDataTypePath();
        this.viewComposite = this.originalComposite;
        if (originalDTM != null) {
            if (originalDTM.contains((DataType)dataType)) {
                this.compositeID = originalDTM.getID((DataType)dataType);
            }
            originalDTM.addDataTypeManagerListener((DataTypeManagerChangeListener)this);
        }
        this.setSelection(new FieldSelection());
        this.clearStatus();
        this.originalNameChanged();
        this.originalCategoryChanged();
        this.compositeInfoChanged();
        this.fireTableDataChanged();
        this.componentDataChanged();
    }

    void unload() {
        DataTypeManager originalDTM;
        DataTypeManager dataTypeManager = originalDTM = this.originalComposite != null ? this.originalComposite.getDataTypeManager() : null;
        if (originalDTM != null) {
            originalDTM.removeDataTypeManagerListener((DataTypeManagerChangeListener)this);
            originalDTM = null;
        }
        if (this.originalComposite != null) {
            this.originalComposite = null;
        }
        if (this.viewComposite != null) {
            this.viewComposite = null;
        }
        this.originalDataTypePath = null;
        if (this.viewDTM != null) {
            this.viewDTM.close();
            this.viewDTM = null;
        }
    }

    DataType resolve(DataType dataType) {
        if (this.viewDTM == null) {
            return DataType.DEFAULT;
        }
        return this.viewDTM.resolve(dataType, null);
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        if (this.updatingSelection) {
            return;
        }
        this.column = column;
    }

    protected void setLocation(int row, int column) {
        this.row = row;
        this.column = column;
    }

    protected Composite getOriginalComposite() {
        DataType dt;
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (originalDTM != null && (dt = originalDTM.getDataType(this.originalDataTypePath)) instanceof Composite) {
            return (Composite)dt;
        }
        return this.originalComposite;
    }

    public final String getOriginalDataTypeName() {
        return this.originalDataTypePath.getDataTypeName();
    }

    protected DataTypeManager getOriginalDataTypeManager() {
        return this.originalComposite != null ? this.originalComposite.getDataTypeManager() : null;
    }

    public final Category getOriginalCategory() {
        CategoryPath originalCategoryPath;
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (this.originalDataTypePath != null && originalDTM != null && originalDTM.containsCategory(originalCategoryPath = this.originalDataTypePath.getCategoryPath())) {
            return originalDTM.getCategory(originalCategoryPath);
        }
        return null;
    }

    public final CategoryPath getOriginalCategoryPath() {
        if (this.originalDataTypePath != null) {
            return this.originalDataTypePath.getCategoryPath();
        }
        return null;
    }

    public String getDescription() {
        String desc = null;
        if (this.viewComposite != null) {
            desc = this.viewComposite.getDescription();
        }
        return desc != null ? desc : "";
    }

    public int getLength() {
        if (this.viewComposite != null && !this.viewComposite.isZeroLength()) {
            return this.viewComposite.getLength();
        }
        return 0;
    }

    public String getLengthAsString() {
        int length = this.getLength();
        return this.showHexNumbers ? CompositeViewerModel.getHexString(length, true) : Integer.toString(length);
    }

    public String getCompositeName() {
        return this.viewComposite != null ? this.viewComposite.getDisplayName() : "";
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getFieldName(columnIndex);
    }

    public String getFieldName(int columnIndex) {
        if (columnIndex < 0 || columnIndex > this.getColumnCount()) {
            return "UNKNOWN";
        }
        return this.headers[columnIndex];
    }

    boolean isEditTypeOfCell(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    int getFieldOffset(int columnIndex) {
        return columnIndex < 0 || columnIndex >= this.getColumnCount() ? 0 : this.columnOffsets[columnIndex];
    }

    int[] getFieldOffsets() {
        return this.columnOffsets;
    }

    protected void adjustOffsets() {
        int offset = this.leftMargin;
        int numCols = this.getColumnCount();
        for (int i = 0; i < numCols; ++i) {
            this.columnOffsets[i] = offset;
            offset += this.columnWidths[i];
        }
        this.width = offset;
    }

    private void adjustWidth() {
        int newWidth = this.leftMargin;
        int numCols = this.getColumnCount();
        for (int i = 0; i < numCols; ++i) {
            newWidth += this.columnWidths[i];
        }
        this.width = newWidth;
    }

    public int getWidth() {
        return this.width;
    }

    public int getFieldWidth(int columnIndex) {
        return columnIndex < 0 || columnIndex >= this.getColumnCount() ? 0 : this.columnWidths[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.viewComposite != null ? this.viewComposite.getNumComponents() : 0;
    }

    public int getNumComponents() {
        return this.viewComposite != null ? this.viewComposite.getNumComponents() : 0;
    }

    public DataTypeComponent getComponent(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.getNumComponents()) {
            return this.viewComposite.getComponent(rowIndex);
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    public int getNumFields() {
        return this.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value;
        if (this.viewComposite == null || rowIndex >= this.viewComposite.getNumComponents() || rowIndex < 0 || columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            if (columnIndex == this.getDataTypeColumn()) {
                return null;
            }
            return "";
        }
        DataTypeComponent dtc = this.viewComposite.getComponent(rowIndex);
        if (columnIndex == this.getOffsetColumn()) {
            int offset = dtc.getOffset();
            value = this.showHexNumbers ? CompositeViewerModel.getHexString(offset, true) : Integer.toString(offset);
        } else if (columnIndex == this.getLengthColumn()) {
            int compLen = dtc.getLength();
            value = this.showHexNumbers ? CompositeViewerModel.getHexString(compLen, true) : Integer.toString(compLen);
        } else if (columnIndex == this.getMnemonicColumn()) {
            int dtLen;
            DataType dt = dtc.getDataType();
            value = dt.getMnemonic((Settings)new SettingsImpl());
            int compLen = dtc.getLength();
            int n = dtLen = dt.isZeroLength() ? 0 : dt.getLength();
            if (dtLen > compLen) {
                value = "TooBig: " + (String)value + " needs " + dtLen + " has " + compLen;
            }
        } else {
            if (columnIndex == this.getDataTypeColumn()) {
                DataType dt;
                int dtLen = (dt = dtc.getDataType()).getLength();
                return DataTypeInstance.getDataTypeInstance((DataType)dt, (int)(dtLen > 0 ? dtLen : dtc.getLength()));
            }
            value = columnIndex == this.getNameColumn() ? dtc.getFieldName() : (columnIndex == this.getCommentColumn() ? dtc.getComment() : "UNKNOWN");
        }
        return value == null ? "" : value;
    }

    protected String getTypeName() {
        return "Composite Data Type";
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.setStatus(status, false);
    }

    public void setStatus(String status, boolean beep) {
        if (status == null) {
            status = "";
        }
        this.status = status;
        this.notify(this.modelListeners, listener -> listener.statusChanged(this.status, beep));
    }

    public void clearStatus() {
        if (this.status.length() == 0) {
            return;
        }
        this.status = "";
        this.setStatus(this.status, false);
    }

    protected void fixupOriginalPath(Composite composite) {
        String newName = composite.getName();
        CategoryPath newCatPath = composite.getCategoryPath();
        CategoryPath oldCatPath = this.viewComposite.getCategoryPath();
        DataTypePath newDtPath = new DataTypePath(newCatPath, composite.getName());
        DataTypePath oldDtPath = new DataTypePath(oldCatPath, this.viewComposite.getName());
        if (!oldCatPath.equals((Object)newCatPath)) {
            this.dataTypeMoved(this.viewDTM, oldDtPath, newDtPath);
        }
        if (!this.originalDataTypePath.getDataTypeName().equals(newName)) {
            this.dataTypeRenamed(this.viewDTM, oldDtPath, newDtPath);
        }
    }

    public void addCompositeViewerModelListener(CompositeViewerModelListener listener) {
        this.modelListeners.add(listener);
    }

    public void removeCompositeViewerModelListener(CompositeViewerModelListener listener) {
        this.modelListeners.remove(listener);
    }

    public void addOriginalCompositeListener(OriginalCompositeListener listener) {
        this.originalListeners.add(listener);
    }

    public void removeOriginalCompositeListener(OriginalCompositeListener listener) {
        this.originalListeners.remove(listener);
    }

    protected void compositeInfoChanged() {
        this.notify(this.modelListeners, CompositeViewerModelListener::compositeInfoChanged);
    }

    protected void componentDataChanged() {
        this.notify(this.modelListeners, CompositeViewerModelListener::componentDataChanged);
    }

    public void originalNameChanged() {
        this.notify(this.originalListeners, listener -> {
            String originalDtName = this.getOriginalDataTypeName();
            listener.originalNameChanged(originalDtName);
            this.provider.updateTitle();
        });
    }

    public void originalCategoryChanged() {
        this.notify(this.originalListeners, listener -> {
            CategoryPath originalCatPath = this.getOriginalCategoryPath();
            listener.originalCategoryChanged(originalCatPath);
        });
    }

    public void originalComponentsChanged() {
        this.notify(this.originalListeners, OriginalCompositeListener::originalComponentsChanged);
    }

    public final DataTypePath getOriginalDataTypePath() {
        return this.originalDataTypePath;
    }

    public void categoryAdded(DataTypeManager dtm, CategoryPath path) {
    }

    public void categoryRemoved(DataTypeManager dtm, CategoryPath path) {
        if (this.originalDataTypePath.isAncestor(path)) {
            String msg = "\"" + this.originalDataTypePath.getDataTypeName() + "\" had its category \"" + path.getPath() + "\" removed.";
            this.setStatus(msg, true);
        } else if (this.hasSubDtInCategory(this.viewComposite, path.getPath())) {
            String msg = "The category \"" + path.getPath() + "\" was removed, which contained a sub-component of \"" + this.originalDataTypePath.getDataTypeName() + "\".";
            this.setStatus(msg, true);
        }
    }

    private void changeOriginalDataTypeCategory(CategoryPath oldPath, CategoryPath newPath) {
        String originalCategory = this.originalDataTypePath.getCategoryPath().getPath();
        String suffix = originalCategory.substring(oldPath.getPath().length());
        this.originalDataTypePath = new DataTypePath(newPath + suffix, this.originalDataTypePath.getDataTypeName());
        this.originalCategoryChanged();
    }

    public void categoryRenamed(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
        if (!this.viewDTM.containsCategory(oldPath)) {
            return;
        }
        Category oldCat = this.viewDTM.getCategory(oldPath);
        try {
            oldCat.setName(newPath.getName());
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        catch (InvalidNameException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        if (this.originalDataTypePath.isAncestor(oldPath)) {
            this.changeOriginalDataTypeCategory(oldPath, newPath);
        }
        this.compositeInfoChanged();
    }

    public void categoryMoved(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
        if (!this.viewDTM.containsCategory(oldPath)) {
            return;
        }
        Category oldCat = this.viewDTM.getCategory(oldPath);
        if (oldCat == null) {
            return;
        }
        CategoryPath parent = newPath.getParent();
        this.viewDTM.createCategory(parent);
        Category newCat = this.viewDTM.getCategory(parent);
        try {
            newCat.moveCategory(oldCat, TaskMonitor.DUMMY);
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        if (this.originalDataTypePath.isAncestor(oldPath)) {
            this.changeOriginalDataTypeCategory(oldPath, newPath);
        }
        this.compositeInfoChanged();
    }

    public void dataTypeAdded(DataTypeManager dtm, DataTypePath path) {
    }

    public void dataTypeRemoved(DataTypeManager dtm, DataTypePath path) {
        DataType dataType = this.viewDTM.getDataType(path.getCategoryPath(), path.getDataTypeName());
        if (dataType == null) {
            return;
        }
        DataType baseDt = DataTypeHelper.getBaseType(dataType);
        DataTypePath dtPath = new DataTypePath(path.getCategoryPath(), baseDt.getName());
        if (!dtPath.equals((Object)this.originalDataTypePath)) {
            DataType dt = this.viewDTM.getDataType(dtPath);
            if (dt != null) {
                if (this.hasSubDt(this.viewComposite, dtPath)) {
                    String msg = "Removed data type \"" + dtPath + "\", which is a sub-component of \"" + this.originalDataTypePath.getDataTypeName() + "\".";
                    this.setStatus(msg, true);
                }
                this.viewDTM.remove(dt, TaskMonitor.DUMMY);
                this.fireTableDataChanged();
                this.componentDataChanged();
            }
        } else {
            if (!dataType.equals(baseDt)) {
                return;
            }
            String msg = "\"" + dtPath + "\" was removed from the data type manager.";
            this.setStatus(msg, true);
        }
    }

    public void dataTypeRenamed(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
        String newName;
        String oldName = oldPath.getDataTypeName();
        if (oldName.equals(newName = newPath.getDataTypeName())) {
            return;
        }
        if (this.originalDataTypePath.equals((Object)oldPath)) {
            this.originalDataTypePath = newPath;
            if (!newName.equals(this.originalComposite.getName())) {
                try {
                    this.originalComposite.setName(newName);
                }
                catch (DuplicateNameException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
                catch (InvalidNameException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
            }
            try {
                if (this.viewComposite.getName().equals(oldName)) {
                    this.viewComposite.setName(newName);
                    this.compositeInfoChanged();
                }
            }
            catch (DuplicateNameException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
            catch (InvalidNameException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
            this.originalNameChanged();
        } else {
            DataType dt = this.viewDTM.getDataType(oldPath);
            if (dt != null) {
                try {
                    dt.setName(newName);
                    this.fireTableDataChanged();
                    this.componentDataChanged();
                }
                catch (InvalidNameException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
                catch (DuplicateNameException e) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public void dataTypeMoved(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
        DataType dt = this.viewDTM.getDataType(oldPath);
        if (dt == null) {
            return;
        }
        Category newDtCat = this.viewDTM.createCategory(newPath.getCategoryPath());
        try {
            newDtCat.moveDataType(dt, null);
        }
        catch (DataTypeDependencyException e) {
            throw new AssertException((Throwable)e);
        }
        if (this.originalDataTypePath.getDataTypeName().equals(newPath.getDataTypeName()) && this.originalDataTypePath.getCategoryPath().equals((Object)oldPath.getCategoryPath())) {
            this.originalDataTypePath = newPath;
            this.originalCategoryChanged();
            this.compositeInfoChanged();
        } else {
            this.fireTableDataChanged();
            this.componentDataChanged();
        }
    }

    public void dataTypeChanged(DataTypeManager dtm, DataTypePath path) {
        if (this.isLoaded()) {
            if (this.originalDataTypePath.equals((Object)path)) {
                this.originalComponentsChanged();
                this.compositeInfoChanged();
            } else {
                CategoryPath cat = path.getCategoryPath();
                this.viewDTM.createCategory(cat);
                DataType dt = this.viewDTM.getDataType(path);
                if (dt == null) {
                    return;
                }
                DataTypeManager originalDTM = this.getOriginalDataTypeManager();
                if (originalDTM != this.viewDTM) {
                    DataType dataType = dtm.getDataType(path);
                    this.viewDTM.resolve(dataType, DataTypeConflictHandler.REPLACE_HANDLER);
                }
                this.fireTableDataChanged();
                this.componentDataChanged();
            }
        }
    }

    public void dataTypeReplaced(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath, DataType newDataType) {
        if (newDataType.getDataTypeManager() == null) {
            throw new IllegalArgumentException("Datatype " + newDataType.getName() + " doesn't have a data type manager specified.");
        }
        DataTypeManager originalDTM = this.getOriginalDataTypeManager();
        if (dtm != originalDTM) {
            return;
        }
        if (this.isLoaded()) {
            if (!oldPath.equals((Object)this.originalDataTypePath)) {
                DataType dt = this.viewDTM.getDataType(oldPath);
                if (dt != null) {
                    if (this.hasSubDt(this.viewComposite, oldPath)) {
                        String msg = "Replaced data type \"" + oldPath.getPath() + "\", which is a sub-component of \"" + this.originalDataTypePath.getDataTypeName() + "\".";
                        this.setStatus(msg, true);
                    }
                    try {
                        this.viewDTM.replaceDataType(dt, newDataType, true);
                    }
                    catch (DataTypeDependencyException e) {
                        throw new AssertException((Throwable)e);
                    }
                    this.fireTableDataChanged();
                    this.componentDataChanged();
                }
            } else {
                this.load((Composite)newDataType);
            }
        }
    }

    public void favoritesChanged(DataTypeManager dtm, DataTypePath path, boolean isFavorite) {
    }

    boolean hasSubDtInCategory(Composite parentDt, String catPath) {
        DataTypeComponent[] components;
        for (DataTypeComponent component : components = parentDt.getDefinedComponents()) {
            DataType subDt = component.getDataType();
            String subCatPath = subDt.getCategoryPath().getPath();
            if (subCatPath.startsWith(catPath)) {
                return true;
            }
            if (!(subDt instanceof Composite) || !this.hasSubDtInCategory((Composite)subDt, catPath)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSubDt(Composite parentDt, DataTypePath dtPath) {
        DataTypeComponent[] components;
        for (DataTypeComponent component : components = parentDt.getDefinedComponents()) {
            DataType subDt = component.getDataType();
            String subDtPath = subDt.getPathName();
            if (subDtPath.equals(dtPath.getPath())) {
                return true;
            }
            if (!(subDt instanceof Composite) || !this.hasSubDt((Composite)subDt, dtPath)) continue;
            return true;
        }
        return false;
    }

    public FieldSelection getSelection() {
        return new FieldSelection(this.selection);
    }

    public boolean hasSelection() {
        return this.selection.getNumRanges() > 0;
    }

    public boolean hasComponentSelection() {
        return this.selection.getNumRanges() > 0 && this.selection.getFieldRange(0).getStart().getIndex().intValue() < this.getNumComponents();
    }

    public int getNumSelectedRows() {
        int numRanges = this.selection.getNumRanges();
        int numSelected = 0;
        for (int i = 0; i < numRanges; ++i) {
            FieldRange range = this.selection.getFieldRange(i);
            numSelected += range.getEnd().getIndex().intValue() - range.getStart().getIndex().intValue();
        }
        return numSelected;
    }

    public int getNumSelectedComponentRows() {
        FieldSelection tmpSelection = new FieldSelection();
        tmpSelection.addRange(0, this.getNumComponents());
        tmpSelection.intersect(this.selection);
        int numRanges = tmpSelection.getNumRanges();
        int numSelected = 0;
        for (int i = 0; i < numRanges; ++i) {
            FieldRange range = tmpSelection.getFieldRange(i);
            numSelected += range.getEnd().getIndex().intValue() - range.getStart().getIndex().intValue();
        }
        return numSelected;
    }

    public boolean isContiguousSelection() {
        return this.selection.getNumRanges() == 1;
    }

    public boolean isSingleComponentRowSelection() {
        if (!this.isSingleRowSelection()) {
            return false;
        }
        FieldRange range = this.selection.getFieldRange(0);
        int rowIndex = range.getStart().getIndex().intValue();
        return this.getComponent(rowIndex) != null;
    }

    public boolean isSingleRowSelection() {
        if (this.selection.getNumRanges() != 1) {
            return false;
        }
        FieldRange range = this.selection.getFieldRange(0);
        return range.getStart().getIndex().intValue() == range.getEnd().getIndex().intValue() - 1;
    }

    public boolean isContiguousComponentSelection() {
        return this.selection.getNumRanges() == 1 && this.selection.getFieldRange(0).getStart().getIndex().intValue() < this.getNumComponents();
    }

    public int[] getSelectedRows() {
        int[] selectedRows = new int[this.getNumSelectedRows()];
        int newIndex = 0;
        int numRanges = this.selection.getNumRanges();
        for (int i = 0; i < numRanges; ++i) {
            FieldRange range = this.selection.getFieldRange(i);
            int tempRow = range.getStart().getIndex().intValue();
            while (tempRow < range.getEnd().getIndex().intValue()) {
                selectedRows[newIndex++] = tempRow++;
            }
        }
        return selectedRows;
    }

    public int[] getSelectedComponentRows() {
        int[] selectedRows = new int[this.getNumSelectedComponentRows()];
        int newIndex = 0;
        int numComponents = this.getNumComponents();
        int numRanges = this.selection.getNumRanges();
        for (int i = 0; i < numRanges; ++i) {
            FieldRange range = this.selection.getFieldRange(i);
            int tempRow = range.getStart().getIndex().intValue();
            while (tempRow < range.getEnd().getIndex().intValue() && tempRow < numComponents) {
                selectedRows[newIndex++] = tempRow++;
            }
        }
        return selectedRows;
    }

    public FieldRange getSelectedRangeContaining(int rowIndex) {
        FieldRange fieldRange = null;
        if (this.selection.containsEntirely(BigInteger.valueOf(rowIndex))) {
            int numRanges = this.selection.getNumRanges();
            for (int i = 0; i < numRanges; ++i) {
                FieldRange range = this.selection.getFieldRange(i);
                if (range.getStart().getIndex().intValue() > rowIndex || rowIndex >= range.getEnd().getIndex().intValue()) continue;
                fieldRange = range;
                break;
            }
        }
        return fieldRange;
    }

    public int getMinIndexSelected() {
        if (!this.selection.isEmpty()) {
            FieldRange fieldRange = this.selection.getFieldRange(0);
            return fieldRange.getStart().getIndex().intValue();
        }
        return -1;
    }

    public void setSelection(int[] rows) {
        if (this.updatingSelection) {
            return;
        }
        FieldSelection tmpSelection = new FieldSelection();
        int numComponents = this.viewComposite.getNumComponents();
        for (int row2 : rows) {
            if (row2 >= numComponents) continue;
            tmpSelection.addRange(row2, row2 + 1);
        }
        if (this.selection.equals((Object)tmpSelection)) {
            return;
        }
        this.selection = tmpSelection;
        this.adjustCurrentRow();
        this.selectionChanged();
    }

    public void setSelection(FieldSelection selection) {
        if (this.updatingSelection) {
            return;
        }
        if (this.selection.equals((Object)selection)) {
            return;
        }
        this.selection.clear();
        int numRanges = selection.getNumRanges();
        for (int i = 0; i < numRanges; ++i) {
            FieldRange range = selection.getFieldRange(i);
            this.selection.addRange(range.getStart().getIndex(), range.getEnd().getIndex());
        }
        this.adjustCurrentRow();
        this.selectionChanged();
    }

    protected void adjustSelection(int rowIndex, int adjustment) {
        FieldSelection newSelection = new FieldSelection();
        int num = this.selection.getNumRanges();
        for (int i = 0; i < num; ++i) {
            FieldRange range = this.selection.getFieldRange(i);
            int last = range.getEnd().getIndex().intValue() - 1;
            if (last < rowIndex) {
                newSelection.addRange(range.getStart().getIndex(), range.getEnd().getIndex());
                continue;
            }
            if (range.getStart().getIndex().intValue() >= rowIndex) {
                newSelection.addRange(range.getStart().getIndex().intValue() + adjustment, range.getEnd().getIndex().intValue() + adjustment);
                continue;
            }
            newSelection.addRange(range.getStart().getIndex().intValue(), rowIndex);
            newSelection.addRange(rowIndex + adjustment, range.getEnd().getIndex().intValue() + adjustment);
        }
        this.selection = newSelection;
    }

    protected void updatingSelection(Callback c) {
        this.swing(() -> {
            boolean tmpUpdatingSelection = this.updatingSelection;
            try {
                this.updatingSelection = true;
                c.call();
            }
            finally {
                this.updatingSelection = tmpUpdatingSelection;
            }
        });
    }

    protected void selectionChanged() {
        this.updatingSelection(() -> {
            for (CompositeViewerModelListener listener : this.modelListeners) {
                listener.selectionChanged();
            }
        });
    }

    protected void swing(Runnable r) {
        Swing.runIfSwingOrRunLater((Runnable)r);
    }

    protected <T> void notify(List<T> listeners, Consumer<T> method) {
        this.swing(() -> {
            for (Object listener : listeners) {
                method.accept(listener);
            }
        });
    }

    public void displayNumbersInHex(boolean showHex) {
        if (this.showHexNumbers != showHex) {
            this.showHexNumbers = showHex;
            this.fireTableDataChanged();
            this.compositeInfoChanged();
        }
    }

    public boolean isShowingNumbersInHex() {
        return this.showHexNumbers;
    }

    public static String getHexString(int offset, boolean showPrefix) {
        String prefix = showPrefix ? "0x" : "";
        return offset >= 0 ? prefix + Integer.toHexString(offset) : "-" + prefix + Integer.toHexString(-offset);
    }

    protected void adjustCurrentRow() {
        int currentRow = -1;
        if (this.selection.getNumRanges() > 0) {
            currentRow = this.selection.getFieldRange(0).getStart().getIndex().intValue();
        }
        this.setRow(currentRow);
    }

    protected long getCompositeID() {
        return this.compositeID;
    }

    public void sourceArchiveAdded(DataTypeManager dataTypeManager, SourceArchive dataTypeSource) {
    }

    public void sourceArchiveChanged(DataTypeManager dataTypeManager, SourceArchive dataTypeSource) {
    }
}

