/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.marker;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.widgets.PopupWindow;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.marker.AreaMarkerSet;
import ghidra.app.plugin.core.marker.MarkerPanel;
import ghidra.app.plugin.core.marker.MarkerSetImpl;
import ghidra.app.plugin.core.marker.NavigationPanel;
import ghidra.app.plugin.core.marker.PointMarkerSet;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.util.viewer.listingpanel.MarginProvider;
import ghidra.app.util.viewer.listingpanel.MarkerClickedListener;
import ghidra.app.util.viewer.listingpanel.OverviewProvider;
import ghidra.app.util.viewer.listingpanel.VerticalPixelAddressMap;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.FixedSizeHashMap;
import ghidra.util.exception.AssertException;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections4.map.LazyMap;

public class MarkerManager
implements MarkerService {
    private static final String POPUP_WINDOW_NAME = "Bookmark ToolTip Window";
    private static final int MAX_TOOLTIP_LINES = 10;
    private MarkerPanel markerPanel;
    private NavigationPanel navigationPanel;
    private MarkerActionList actionList;
    private VerticalPixelAddressMap pixmap;
    private AddressIndexMap addrMap;
    private Map<String, Map<Program, MarkerSetImpl>> programMarkersByGroup = LazyMap.lazyMap(new HashMap(), () -> new HashMap());
    private List<MarkerSetImpl> currentMarkerSets = Collections.emptyList();
    private Map<Program, List<MarkerSetImpl>> markerSetCache = LazyMap.lazyMap(new HashMap(), () -> new ArrayList());
    private SwingUpdateManager updater;
    private GoToService goToService;
    private Navigatable navigatable;
    private MarginProvider marginProvider;
    private OverviewProvider overviewProvider;
    private PluginTool tool;
    private String owner;
    private Program currentProgram;
    private Map<Program, AddressColorCache> colorCache = LazyMap.lazyMap(new HashMap(), () -> new AddressColorCache());
    private PopupWindow popupWindow;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private MarkerClickedListener markerClickedListener = null;

    public MarkerManager(Plugin ownerPlugin) {
        this(ownerPlugin.getName(), ownerPlugin.getTool());
    }

    public MarkerManager(String owner, PluginTool tool) {
        this.owner = owner;
        this.tool = tool;
        this.updater = new SwingUpdateManager(100, 60000, () -> {
            this.markerPanel.repaint();
            this.navigationPanel.repaint();
            this.notifyListeners();
        });
        this.navigationPanel = new NavigationPanel(this);
        this.navigationPanel.setPreferredSize(new Dimension(16, 1));
        this.navigationPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MarkerManager.this.updateMarkerSets(true, true, true);
            }
        });
        this.overviewProvider = new MyOverviewProvider();
        this.markerPanel = new MarkerPanel(this);
        this.markerPanel.setPreferredSize(new Dimension(16, 1));
        this.marginProvider = new MyMarginProvider();
        this.markerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2 || MarkerManager.this.markerClickedListener == null) {
                    return;
                }
                Address addr = MarkerManager.this.getAddress(e.getY());
                if (addr == null) {
                    return;
                }
                MarkerSetImpl marker = MarkerManager.this.getMarkerSet(addr);
                MarkerLocation location = new MarkerLocation(marker, MarkerManager.this.currentProgram, addr, e.getX(), e.getY());
                MarkerManager.this.markerClickedListener.markerDoubleClicked(location);
            }
        });
        this.actionList = new MarkerActionList();
    }

    void programClosed(Program program) {
        this.markerSetCache.remove(program);
        Map<String, Map<Program, MarkerSetImpl>> values = this.programMarkersByGroup;
        Collection<Map<Program, MarkerSetImpl>> valueValues = values.values();
        for (Map<Program, MarkerSetImpl> map : valueValues) {
            map.remove(program);
        }
    }

    @Override
    public MarkerSet createAreaMarker(String name, String markerDescription, Program program, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color color) {
        AreaMarkerSet mgr = new AreaMarkerSet(this, name, markerDescription, priority, showMarkers, showNavigation, colorBackground, color, program);
        this.insertMarkers(mgr, program);
        return mgr;
    }

    @Override
    public MarkerSet createAreaMarker(String name, String markerDescription, Program program, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color color, boolean isPreferred) {
        AreaMarkerSet mgr = new AreaMarkerSet(this, name, markerDescription, priority, showMarkers, showNavigation, colorBackground, color, isPreferred, program);
        this.insertMarkers(mgr, program);
        return mgr;
    }

    @Override
    public MarkerSet createPointMarker(String name, String markerDescription, Program program, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color color, ImageIcon icon) {
        PointMarkerSet markers = new PointMarkerSet(this, name, markerDescription, priority, showMarkers, showNavigation, colorBackground, color, icon, program);
        this.insertMarkers(markers, program);
        return markers;
    }

    @Override
    public MarkerSet createPointMarker(String name, String markerDescription, Program program, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color color, ImageIcon icon, boolean isPreferred) {
        PointMarkerSet markers = new PointMarkerSet(this, name, markerDescription, priority, showMarkers, showNavigation, colorBackground, color, icon, isPreferred, program);
        this.insertMarkers(markers, program);
        return markers;
    }

    @Override
    public MarkerSet getMarkerSet(String name, Program program) {
        if (name == null) {
            throw new NullPointerException("Marker set name cannot be null.");
        }
        if (program == null) {
            throw new NullPointerException("Program cannot be null.");
        }
        List<MarkerSetImpl> list = this.markerSetCache.get(program);
        for (MarkerSetImpl set : list) {
            if (!name.equals(set.getName())) continue;
            return set;
        }
        return null;
    }

    @Override
    public void removeMarker(MarkerSet markers, Program program) {
        if (program == null) {
            throw new NullPointerException("Cannot remove marker set for a null program.");
        }
        this.doRemoveMarker(markers, program);
        this.actionList.refresh();
        this.markersChanged(program);
    }

    private void doRemoveMarker(MarkerSet markers, Program program) {
        if (markers == null || program == null) {
            return;
        }
        List<MarkerSetImpl> list = this.markerSetCache.get(program);
        list.remove(markers);
        Collection<Map<Program, MarkerSetImpl>> values = this.programMarkersByGroup.values();
        for (Map<Program, MarkerSetImpl> map : values) {
            MarkerSetImpl markerSetImpl = map.get(program);
            if (markerSetImpl != markers) continue;
            map.clear();
            break;
        }
    }

    public MarginProvider getMarginProvider() {
        return this.marginProvider;
    }

    public OverviewProvider getOverviewProvider() {
        return this.overviewProvider;
    }

    public void setProgram(Program program) {
        this.currentProgram = program;
        if (program == null) {
            this.currentMarkerSets = Collections.emptyList();
            this.updater.update();
            return;
        }
        this.colorCache.get(program).clear();
        this.setCurrentMarkerSets(program);
        this.actionList.refresh();
        this.updater.update();
    }

    public void dispose() {
        this.updater.dispose();
        this.actionList.dispose();
        this.currentMarkerSets.clear();
        this.markerSetCache.clear();
        this.colorCache.clear();
    }

    void navigateTo(int x, int y) {
        int viewHeight = this.navigationPanel.getHeight() - 4;
        for (int i = this.currentMarkerSets.size() - 1; i >= 0; --i) {
            MarkerSetImpl markers = this.currentMarkerSets.get(i);
            if (!markers.isActive()) continue;
            GoToService service = this.getGoToService();
            ProgramLocation loc = markers.getProgramLocation(y, viewHeight, this.addrMap, x);
            if (loc == null || service == null) continue;
            service.goTo(this.navigatable, loc, loc.getProgram());
            break;
        }
    }

    void paintMarkers(Graphics g) {
        Iterator<MarkerSetImpl> it = this.currentMarkerSets.iterator();
        int count = 0;
        while (it.hasNext()) {
            MarkerSetImpl markers = it.next();
            if (!markers.isActive()) continue;
            markers.paintMarkers(g, count++, this.pixmap, this.addrMap);
        }
    }

    void paintNavigation(Graphics g, NavigationPanel panel) {
        if (this.addrMap == null) {
            return;
        }
        int viewHeight = panel.getHeight() - 4;
        for (MarkerSetImpl markers : this.currentMarkerSets) {
            if (!markers.active) continue;
            markers.paintNavigation(g, viewHeight, panel, this.addrMap);
        }
    }

    String getTooltip(MouseEvent event) {
        String tip = this.generateToolTip(event);
        if (tip == null) {
            return null;
        }
        JToolTip toolTip = new JToolTip();
        toolTip.setTipText("<html><font size=\"4\">" + tip);
        if (this.popupWindow != null) {
            this.popupWindow.dispose();
        }
        this.popupWindow = new PopupWindow(event.getComponent(), (JComponent)toolTip);
        this.popupWindow.setWindowName(POPUP_WINDOW_NAME);
        this.popupWindow.showPopup(event);
        return null;
    }

    String generateToolTip(MouseEvent event) {
        if (this.pixmap == null) {
            return null;
        }
        int y = event.getY();
        int x = event.getX();
        int layoutIndex = this.pixmap.findLayoutAt(y);
        Address layoutAddress = this.pixmap.getLayoutAddress(layoutIndex);
        if (layoutAddress == null) {
            return null;
        }
        List<String> lines = this.getMarkerTooltipLines(y, x, layoutIndex, layoutAddress);
        return this.toHTML(lines);
    }

    private List<String> getMarkerTooltipLines(int y, int x, int layoutIndex, Address layoutAddress) {
        Address endAddr = this.pixmap.getLayoutEndAddress(layoutIndex);
        ArrayList<String> lines = new ArrayList<String>();
        block0: for (int i = this.currentMarkerSets.size() - 1; i >= 0; --i) {
            MarkerSetImpl markers = this.currentMarkerSets.get(i);
            if (!markers.displayInMarkerBar()) continue;
            AddressSet set = markers.getAddressSet();
            AddressSet intersection = set.intersect((AddressSetView)new AddressSet(layoutAddress, endAddr));
            for (Address a : intersection.getAddresses(true)) {
                lines.add(this.getMarkerToolTip(markers, a, x, y));
                if (markers instanceof AreaMarkerSet) continue block0;
                if (lines.size() < 10) continue;
                lines.add("...");
                return lines;
            }
        }
        return lines;
    }

    private String getMarkerToolTip(MarkerSetImpl marker, Address a, int x, int y) {
        String tip = marker.getTooltip(a, x, y);
        if (tip == null) {
            tip = marker.getName();
        }
        return tip;
    }

    private String toHTML(List<String> lines) {
        if (lines.isEmpty()) {
            return null;
        }
        StringBuilder buffy = new StringBuilder("<html><font size=\"4\">");
        for (String string : lines) {
            buffy.append(string).append("<BR>");
        }
        return buffy.toString();
    }

    void markersChanged(Program p) {
        this.colorCache.get(p).clear();
        this.updater.update();
    }

    private void insertMarkers(MarkerSetImpl markers, Program program) {
        if (program == null) {
            throw new AssertException("Program cannot be null");
        }
        List<MarkerSetImpl> markerSets = this.markerSetCache.get(program);
        if (markerSets == null) {
            return;
        }
        int index = Collections.binarySearch(markerSets, markers);
        if (index < 0) {
            index = -(index + 1);
        }
        markerSets.add(index, markers);
        this.actionList.refresh();
    }

    private void setCurrentMarkerSets(Program program) {
        boolean switchingLists;
        List<MarkerSetImpl> markerSets = this.markerSetCache.get(program);
        boolean bl = switchingLists = markerSets != this.currentMarkerSets;
        if (!switchingLists) {
            return;
        }
        this.currentMarkerSets = markerSets;
        Collections.sort(this.currentMarkerSets);
    }

    private Address getAddress(int y) {
        if (this.pixmap == null) {
            return null;
        }
        int i = this.pixmap.findLayoutAt(y);
        return this.pixmap.getLayoutAddress(i);
    }

    private void updateMarkerSets(boolean updateMarkers, boolean updateNavigation, boolean updateNow) {
        for (MarkerSetImpl marker : this.currentMarkerSets) {
            marker.updateView(updateMarkers, updateNavigation);
        }
        if (updateNow) {
            this.updater.updateNow();
        } else {
            this.updater.update();
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(null);
        }
    }

    private MarkerSetImpl getMarkerSet(Address addr) {
        for (int i = this.currentMarkerSets.size() - 1; i >= 0; --i) {
            MarkerSetImpl markers = this.currentMarkerSets.get(i);
            if (!markers.displayInMarkerBar() || !markers.contains(addr)) continue;
            return markers;
        }
        return null;
    }

    Program getProgram() {
        return this.currentProgram;
    }

    @Override
    public void setMarkerForGroup(String groupName, MarkerSet ms, Program program) {
        if (!(ms instanceof MarkerSetImpl)) {
            throw new IllegalArgumentException("Invalid marker set provided");
        }
        MarkerSetImpl markers = (MarkerSetImpl)ms;
        Map<Program, MarkerSetImpl> markersByProgram = this.programMarkersByGroup.get(groupName);
        MarkerSetImpl previousMarkers = markersByProgram.get(program);
        if (markers == previousMarkers) {
            return;
        }
        this.removeMarker(previousMarkers, program);
        markersByProgram.put(program, markers);
        this.insertMarkers(markers, program);
    }

    @Override
    public void removeMarkerForGroup(String groupName, MarkerSet markers, Program program) {
        Map<Program, MarkerSetImpl> markersByProgram = this.programMarkersByGroup.get(groupName);
        MarkerSet previousMarkers = markersByProgram.get(program);
        if (markers == previousMarkers) {
            markersByProgram.remove(program);
            this.removeMarker(previousMarkers, program);
        }
    }

    @Override
    public Color getBackgroundColor(Address address) {
        return this.getBackgroundColor(this.currentProgram, this.currentMarkerSets, address);
    }

    @Override
    public Color getBackgroundColor(Program program, Address address) {
        Program markerProgram = program == null ? this.currentProgram : program;
        return this.getBackgroundColor(markerProgram, this.markerSetCache.get(markerProgram), address);
    }

    private Color getBackgroundColor(Program program, List<MarkerSetImpl> markerSets, Address address) {
        AddressColorCache addressColorCache = this.colorCache.get(program);
        if (addressColorCache.containsKey(address)) {
            return (Color)addressColorCache.get(address);
        }
        for (int index = markerSets.size() - 1; index >= 0; --index) {
            MarkerSet markers = markerSets.get(index);
            if (!markers.isActive() || !markers.isColoringBackground() || !markers.contains(address)) continue;
            Color color = markers.getMarkerColor();
            addressColorCache.put(address, color);
            return color;
        }
        return null;
    }

    public GoToService getGoToService() {
        if (this.goToService == null) {
            this.goToService = (GoToService)this.tool.getService(GoToService.class);
        }
        return this.goToService;
    }

    public void setGoToService(GoToService goToService) {
        this.goToService = goToService;
    }

    public void setNavigatable(Navigatable navigatable) {
        this.navigatable = navigatable;
    }

    @Override
    public void setMarkerClickedListener(MarkerClickedListener listener) {
        if (listener != null && this.markerClickedListener != null) {
            throw new IllegalStateException("Attempted to assign more than one MarkerClickedListener!");
        }
        this.markerClickedListener = listener;
    }

    static class AddressColorCache
    extends FixedSizeHashMap<Address, Color> {
        private static final int MAX_SIZE = 50;

        AddressColorCache() {
            super(50, 50);
        }
    }

    private class MyOverviewProvider
    implements OverviewProvider {
        private MyOverviewProvider() {
        }

        @Override
        public JComponent getComponent() {
            return MarkerManager.this.navigationPanel;
        }

        @Override
        public void setAddressIndexMap(AddressIndexMap map) {
            MarkerManager.this.addrMap = map;
            MarkerManager.this.updateMarkerSets(true, true, false);
        }
    }

    private class MyMarginProvider
    implements MarginProvider {
        private MyMarginProvider() {
        }

        @Override
        public JComponent getComponent() {
            return MarkerManager.this.markerPanel;
        }

        @Override
        public MarkerLocation getMarkerLocation(int x, int y) {
            Address addr = MarkerManager.this.getAddress(y);
            if (addr == null) {
                return null;
            }
            MarkerSetImpl marker = MarkerManager.this.getMarkerSet(addr);
            return new MarkerLocation(marker, MarkerManager.this.currentProgram, addr, x, y);
        }

        @Override
        public boolean isResizeable() {
            return false;
        }

        @Override
        public void setPixelMap(VerticalPixelAddressMap pixmap) {
            MarkerManager.this.pixmap = pixmap;
            MarkerManager.this.updateMarkerSets(true, false, true);
        }
    }

    private static class ActivateMarkerGroupAction
    extends ToggleDockingAction {
        private List<MarkerSetImpl> markerSets;
        private NavigationPanel panel;
        private Options options;

        ActivateMarkerGroupAction(String owner, List<MarkerSetImpl> managerList, NavigationPanel panel, Options options) {
            super(managerList.get(0).getName(), owner);
            this.markerSets = managerList;
            this.panel = panel;
            this.options = options;
            HelpLocation helpLocation = new HelpLocation("CodeBrowserPlugin", "Markers");
            options.registerOption(this.getName(), (Object)true, helpLocation, "This options enables/disables the display of " + this.getName() + " marker types.");
            this.setEnabled(true);
            this.setSelected(this.isActive());
            ImageIcon icon = managerList.get(0).getNavIcon();
            this.setPopupMenuData(new MenuData(new String[]{this.getName()}, (Icon)icon));
            boolean isEnabled = this.isOptionEnabled();
            this.setSelected(isEnabled);
            this.setActive(isEnabled);
            this.setHelpLocation(helpLocation);
        }

        private void setActive(boolean active) {
            for (MarkerSetImpl manager : this.markerSets) {
                manager.setActive(active);
            }
        }

        private boolean isActive() {
            return this.markerSets.stream().anyMatch(markers -> markers.isActive());
        }

        public boolean isEnabledForContext(ActionContext context) {
            Object contextObject = context.getContextObject();
            return contextObject == this.panel;
        }

        void optionsChanged() {
            boolean selected = this.isOptionEnabled();
            if (selected != this.isSelected()) {
                this.setSelected(selected);
                this.setActive(selected);
            }
        }

        private boolean isOptionEnabled() {
            return this.options.getBoolean(this.getName(), true);
        }

        public void actionPerformed(ActionContext context) {
            this.options.setBoolean(this.getName(), this.isSelected());
            this.setActive(this.isSelected());
        }
    }

    private static class ActivateMarkerAction
    extends ToggleDockingAction {
        private MarkerSetImpl markers;
        private NavigationPanel panel;
        private Options options;

        ActivateMarkerAction(String owner, MarkerSetImpl markers, NavigationPanel panel, Options options) {
            super(markers.getName(), owner);
            this.markers = markers;
            this.panel = panel;
            this.options = options;
            HelpLocation helpLocation = new HelpLocation("CodeBrowserPlugin", "Markers");
            options.registerOption(markers.getName(), (Object)true, helpLocation, "This options enables/disables the display of " + markers.getName() + " marker types.");
            this.setEnabled(true);
            this.setSelected(markers.active);
            this.setPopupMenuData(new MenuData(new String[]{markers.getName()}, (Icon)markers.getNavIcon(), null));
            boolean isEnabled = this.isOptionEnabled();
            this.setSelected(isEnabled);
            markers.setActive(isEnabled);
            HelpLocation location = new HelpLocation("CodeBrowserPlugin", "Markers");
            this.setHelpLocation(location);
        }

        public boolean isEnabledForContext(ActionContext context) {
            Object contextObject = context.getContextObject();
            return contextObject == this.panel;
        }

        void optionsChanged() {
            boolean selected = this.isOptionEnabled();
            if (selected != this.isSelected()) {
                this.setSelected(selected);
                this.markers.setActive(selected);
            }
        }

        private boolean isOptionEnabled() {
            return this.options.getBoolean(this.markers.getName(), true);
        }

        public void actionPerformed(ActionContext context) {
            this.options.setBoolean(this.markers.getName(), this.isSelected());
            this.markers.setActive(this.isSelected());
        }
    }

    class MarkerActionList
    implements OptionsChangeListener {
        private ArrayList<DockingAction> actions = new ArrayList();
        private ToolOptions listOptions;

        MarkerActionList() {
            this.initOptions();
            this.refresh();
        }

        private void initOptions() {
            this.listOptions = MarkerManager.this.tool.getOptions("Navigation Markers");
            this.listOptions.removeOptionsChangeListener((OptionsChangeListener)this);
            this.listOptions.addOptionsChangeListener((OptionsChangeListener)this);
        }

        public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
            for (DockingAction action : this.actions) {
                if (action instanceof ActivateMarkerAction) {
                    ((ActivateMarkerAction)action).optionsChanged();
                }
                if (!(action instanceof ActivateMarkerGroupAction)) continue;
                ((ActivateMarkerGroupAction)action).optionsChanged();
            }
        }

        void refresh() {
            SystemUtilities.runSwingLater(() -> this.doRefresh());
        }

        private void doRefresh() {
            ToggleDockingAction action;
            if (MarkerManager.this.tool == null || MarkerManager.this.currentProgram == null) {
                return;
            }
            for (DockingAction action2 : this.actions) {
                MarkerManager.this.tool.removeAction((DockingActionIf)action2);
            }
            this.actions.clear();
            ArrayList<MarkerSetImpl> list = new ArrayList<MarkerSetImpl>(MarkerManager.this.currentMarkerSets);
            List<List<MarkerSetImpl>> groupsList = this.extractManagerGroups(list);
            Collections.sort(groupsList, (ms1, ms2) -> ((MarkerSetImpl)ms1.get(0)).getName().compareTo(((MarkerSetImpl)ms2.get(0)).getName()));
            for (List<MarkerSetImpl> group : groupsList) {
                action = new ActivateMarkerGroupAction(MarkerManager.this.owner, group, MarkerManager.this.navigationPanel, (Options)this.listOptions);
                this.actions.add((DockingAction)action);
                MarkerManager.this.tool.addAction((DockingActionIf)action);
            }
            Collections.sort(list, (ms1, ms2) -> ms1.getName().compareTo(ms2.getName()));
            for (MarkerSetImpl mgr : list) {
                action = new ActivateMarkerAction(MarkerManager.this.owner, mgr, MarkerManager.this.navigationPanel, (Options)this.listOptions);
                this.actions.add((DockingAction)action);
                MarkerManager.this.tool.addAction((DockingActionIf)action);
            }
            MarkerManager.this.navigationPanel.repaint();
        }

        private List<List<MarkerSetImpl>> extractManagerGroups(List<MarkerSetImpl> fromList) {
            HashMap<String, ArrayList<MarkerSetImpl>> nameToManagerMap = new HashMap<String, ArrayList<MarkerSetImpl>>();
            Iterator<MarkerSetImpl> iterator = fromList.iterator();
            while (iterator.hasNext()) {
                MarkerSetImpl markerSetImpl = iterator.next();
                String name = markerSetImpl.getName();
                ArrayList<MarkerSetImpl> subList = (ArrayList<MarkerSetImpl>)nameToManagerMap.get(name);
                if (subList == null) {
                    subList = new ArrayList<MarkerSetImpl>();
                    nameToManagerMap.put(name, subList);
                }
                subList.add(markerSetImpl);
                iterator.remove();
            }
            ArrayList<List<MarkerSetImpl>> groupList = new ArrayList<List<MarkerSetImpl>>(fromList.size());
            Set entrySet = nameToManagerMap.entrySet();
            for (Map.Entry entry : entrySet) {
                List listValue = (List)entry.getValue();
                if (listValue.size() == 1) {
                    fromList.add((MarkerSetImpl)listValue.get(0));
                    continue;
                }
                groupList.add(listValue);
            }
            return groupList;
        }

        void dispose() {
            this.listOptions.removeOptionsChangeListener((OptionsChangeListener)this);
            this.actions.forEach(a -> MarkerManager.this.tool.removeAction((DockingActionIf)a));
        }
    }
}

