/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import ghidra.app.plugin.core.navigation.locationreferences.DataTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

class UnionLocationDescriptor
extends DataTypeLocationDescriptor {
    private Union union;

    UnionLocationDescriptor(ProgramLocation location, Program program) {
        super(location, program);
    }

    @Override
    protected void doGetReferences(Accumulator<LocationReference> accumulator, TaskMonitor monitor) throws CancelledException {
        String fieldName = null;
        ReferenceUtils.findDataTypeReferences(accumulator, (DataType)this.union, fieldName, this.program, this.useDynamicSearching, monitor);
    }

    @Override
    protected String generateLabel() {
        return this.getDataTypeName();
    }

    @Override
    protected DataType getSourceDataType() {
        Data data = this.getData(this.getLocation());
        Data parentData = this.getParent(data);
        DataType dataType = parentData.getDataType();
        if (!(dataType instanceof Union)) {
            throw new AssertException("A Union is required for this LocationDescriptor");
        }
        this.union = (Union)dataType;
        return dataType;
    }

    private Data getParent(Data data) {
        Data parent = data.getParent();
        if (parent == null) {
            return data;
        }
        Data nextParent = this.getParent(parent);
        if (nextParent != null) {
            return nextParent;
        }
        return data;
    }

    @Override
    protected String getDataTypeName() {
        return this.union.getDisplayName();
    }
}

