/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import ghidra.app.plugin.core.navigation.locationreferences.FunctionParameterNameLocationDescriptor;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableNameFieldLocation;
import ghidra.util.exception.AssertException;

class VariableNameLocationDescriptor
extends FunctionParameterNameLocationDescriptor {
    private OperandFieldLocation alternateHomeLocation;

    VariableNameLocationDescriptor(VariableNameFieldLocation location, Program program) {
        super((FunctionLocation)location, program);
        Variable variable = this.getVariable();
        this.homeAddress = variable != null ? variable.getMinAddress() : location.getAddress();
    }

    VariableNameLocationDescriptor(VariableNameFieldLocation location, OperandFieldLocation alternateHomeLocation, Program program) {
        super((FunctionLocation)location, program);
        this.alternateHomeLocation = alternateHomeLocation;
        this.homeAddress = alternateHomeLocation.getAddress();
    }

    @Override
    protected void validate(FunctionLocation location) {
        if (location == null) {
            throw new NullPointerException("Cannot create a LocationDescriptor from a null ProgramLocation");
        }
        if (!(this.programLocation instanceof VariableNameFieldLocation)) {
            throw new AssertException("Unexpected ProgramLocation type - Cannot create a LocationDescriptor for type: " + this.programLocation);
        }
    }

    @Override
    ProgramLocation getHomeLocation() {
        if (this.alternateHomeLocation != null) {
            return this.alternateHomeLocation;
        }
        return super.getHomeLocation();
    }

    @Override
    protected Variable getVariable() {
        return ((VariableNameFieldLocation)this.programLocation).getVariable();
    }

    @Override
    protected String getVariableName() {
        return ((VariableNameFieldLocation)this.programLocation).getName();
    }
}

