/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.DialogComponentProvider;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.cmd.refs.SetExternalNameCmd;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.SymbolTreeProvider;
import ghidra.app.plugin.core.symboltree.actions.SymbolTreeContextAction;
import ghidra.app.plugin.core.symboltree.nodes.LibrarySymbolNode;
import ghidra.framework.cmd.Command;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.util.HelpLocation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import resources.ResourceManager;

public class SetExternalProgramAction
extends SymbolTreeContextAction {
    private static ImageIcon EDIT_ICON = ResourceManager.loadImage((String)"images/editbytes.gif");
    private final SymbolTreePlugin plugin;
    private SymbolTreeProvider provider;

    public SetExternalProgramAction(SymbolTreePlugin plugin, SymbolTreeProvider provider) {
        super("Set External Program", plugin.getName());
        this.plugin = plugin;
        this.provider = provider;
        this.setPopupMenuData(new MenuData(new String[]{"Set External Program"}, (Icon)EDIT_ICON, "0External"));
        this.setToolBarData(new ToolBarData((Icon)EDIT_ICON, null));
        this.setEnabled(false);
    }

    @Override
    public boolean isEnabledForContext(SymbolTreeActionContext context) {
        Object object;
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        return selectionPaths.length == 1 && (object = selectionPaths[0].getLastPathComponent()) instanceof LibrarySymbolNode;
    }

    @Override
    public void actionPerformed(SymbolTreeActionContext context) {
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        if (selectionPaths.length != 1) {
            return;
        }
        Object object = selectionPaths[0].getLastPathComponent();
        if (!(object instanceof LibrarySymbolNode)) {
            return;
        }
        LibrarySymbolNode libraryNode = (LibrarySymbolNode)((Object)object);
        final String externalName = libraryNode.getName();
        Program program = this.plugin.getProgram();
        ExternalManager externalManager = program.getExternalManager();
        final String externalLibraryPath = externalManager.getExternalLibraryPath(externalName);
        final DataTreeDialog dialog = new DataTreeDialog(this.provider.getComponent(), "Choose External Program (" + externalName + ")", 0);
        dialog.setSearchText(externalName);
        dialog.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e1) {
                DomainFile domainFile = dialog.getDomainFile();
                if (domainFile == null) {
                    return;
                }
                String pathName = domainFile.toString();
                dialog.close();
                if (!pathName.equals(externalLibraryPath)) {
                    SetExternalNameCmd cmd = new SetExternalNameCmd(externalName, domainFile.getPathname());
                    SetExternalProgramAction.this.plugin.getTool().execute((Command)cmd, (DomainObject)SetExternalProgramAction.this.plugin.getProgram());
                }
            }
        });
        dialog.setHelpLocation(new HelpLocation("SymbolTreePlugin", "ChooseExternalProgram"));
        if (externalLibraryPath != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Project project = AppInfo.getActiveProject();
                    ProjectData pd = project.getProjectData();
                    DomainFile domainFile = pd.getFile(externalLibraryPath);
                    if (domainFile != null) {
                        dialog.selectDomainFile(domainFile);
                    }
                }
            });
        }
        this.plugin.getTool().showDialog((DialogComponentProvider)dialog);
    }
}

