/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc;

import ghidra.app.plugin.exceptionhandlers.gcc.AbstractDwarfEHDecoder;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecodeContext;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDataApplicationMode;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDataDecodeFormat;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDecoder;
import ghidra.app.plugin.exceptionhandlers.gcc.datatype.SignedLeb128DataType;
import ghidra.app.plugin.exceptionhandlers.gcc.datatype.UnsignedLeb128DataType;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.program.model.scalar.Scalar;
import java.util.concurrent.ConcurrentHashMap;

public class DwarfDecoderFactory {
    private static final ConcurrentHashMap<Integer, DwarfEHDecoder> decoderMap = new ConcurrentHashMap();

    public static DwarfEHDecoder getDecoder(int mode) {
        DwarfEHDecoder dwarfEHDecoder = decoderMap.get(mode);
        if (dwarfEHDecoder != null) {
            return dwarfEHDecoder;
        }
        int format = mode & 0xF;
        int appl = mode & 0x70;
        boolean isIndirect = (mode & 0x80) == 128;
        DwarfEHDataDecodeFormat style = DwarfEHDataDecodeFormat.valueOf(format);
        DwarfEHDataApplicationMode mod = DwarfEHDataApplicationMode.valueOf(appl);
        dwarfEHDecoder = (mode & 0xFF) == 255 ? new DW_EH_PE_omit_Decoder(DwarfEHDataApplicationMode.DW_EH_PE_omit, false) : DwarfDecoderFactory.createDecoder(style, mod, isIndirect);
        decoderMap.put(mode, dwarfEHDecoder);
        return dwarfEHDecoder;
    }

    private static DwarfEHDecoder createDecoder(DwarfEHDataDecodeFormat style, DwarfEHDataApplicationMode mod, boolean isIndirect) {
        switch (style) {
            case DW_EH_PE_absptr: {
                return new DW_EH_PE_absptr_Decoder(mod, isIndirect);
            }
            case DW_EH_PE_uleb128: {
                return new DW_EH_PE_uleb128_Decoder(mod, isIndirect);
            }
            case DW_EH_PE_udata2: {
                return new DW_EH_PE_udata2_Decoder(mod, isIndirect);
            }
            case DW_EH_PE_udata4: {
                return new DW_EH_PE_udata4_Decoder(mod, isIndirect);
            }
            case DW_EH_PE_udata8: {
                return new DW_EH_PE_udata8_Decoder(mod, isIndirect);
            }
            case DW_EH_PE_signed: {
                return new DW_EH_PE_signed_Decoder(mod, isIndirect);
            }
            case DW_EH_PE_sleb128: {
                return new DW_EH_PE_sleb128_Decoder(mod, isIndirect);
            }
            case DW_EH_PE_sdata2: {
                return new DW_EH_PE_sdata2_Decoder(mod, isIndirect);
            }
            case DW_EH_PE_sdata4: {
                return new DW_EH_PE_sdata4_Decoder(mod, isIndirect);
            }
            case DW_EH_PE_sdata8: {
                return new DW_EH_PE_sdata8_Decoder(mod, isIndirect);
            }
        }
        return new DW_EH_PE_omit_Decoder(mod, isIndirect);
    }

    static final class DW_EH_PE_sdata8_Decoder
    extends AbstractSignedDwarEHfDecoder {
        public DW_EH_PE_sdata8_Decoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
            super(mode, isIndirect);
        }

        @Override
        public DwarfEHDataDecodeFormat getDataFormat() {
            return DwarfEHDataDecodeFormat.DW_EH_PE_sdata8;
        }

        @Override
        public int getDecodeSize(Program program) {
            return 8;
        }

        @Override
        public long doDecode(DwarfDecodeContext context) throws MemoryAccessException {
            Program program = context.getProgram();
            Address addr = context.getAddress();
            long offset = DW_EH_PE_sdata8_Decoder.readQWord(program, addr);
            context.setDecodedValue(offset, 8);
            return offset;
        }

        @Override
        public DataType getDataType(Program program) {
            return QWORD_DATA_TYPE;
        }
    }

    static final class DW_EH_PE_sdata4_Decoder
    extends AbstractSignedDwarEHfDecoder {
        public DW_EH_PE_sdata4_Decoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
            super(mode, isIndirect);
        }

        @Override
        public DwarfEHDataDecodeFormat getDataFormat() {
            return DwarfEHDataDecodeFormat.DW_EH_PE_sdata4;
        }

        @Override
        public int getDecodeSize(Program program) {
            return 4;
        }

        @Override
        public long doDecode(DwarfDecodeContext context) throws MemoryAccessException {
            Program program = context.getProgram();
            Address addr = context.getAddress();
            long offset = DW_EH_PE_sdata4_Decoder.readDWord(program, addr);
            context.setDecodedValue(offset, 4);
            return offset;
        }

        @Override
        public DataType getDataType(Program program) {
            return DWORD_DATA_TYPE;
        }
    }

    static final class DW_EH_PE_sdata2_Decoder
    extends AbstractSignedDwarEHfDecoder {
        public DW_EH_PE_sdata2_Decoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
            super(mode, isIndirect);
        }

        @Override
        public DwarfEHDataDecodeFormat getDataFormat() {
            return DwarfEHDataDecodeFormat.DW_EH_PE_sdata2;
        }

        @Override
        public int getDecodeSize(Program program) {
            return 2;
        }

        @Override
        public long doDecode(DwarfDecodeContext context) throws MemoryAccessException {
            Program program = context.getProgram();
            Address addr = context.getAddress();
            long offset = DW_EH_PE_sdata2_Decoder.readWord(program, addr);
            context.setDecodedValue(offset, 2);
            return offset;
        }

        @Override
        public DataType getDataType(Program program) {
            return WORD_DATA_TYPE;
        }
    }

    static final class DW_EH_PE_sleb128_Decoder
    extends AbstractSignedDwarEHfDecoder {
        public DW_EH_PE_sleb128_Decoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
            super(mode, isIndirect);
        }

        @Override
        public DwarfEHDataDecodeFormat getDataFormat() {
            return DwarfEHDataDecodeFormat.DW_EH_PE_sleb128;
        }

        @Override
        public int getDecodeSize(Program program) {
            return -1;
        }

        @Override
        public long doDecode(DwarfDecodeContext context) throws MemoryAccessException {
            Program program = context.getProgram();
            Address addr = context.getAddress();
            DumbMemBufferImpl buf = new DumbMemBufferImpl(program.getMemory(), addr);
            SignedLeb128DataType sleb = SignedLeb128DataType.dataType;
            int numAvailBytes = sleb.getLength((MemBuffer)buf, -1);
            Scalar scalar = (Scalar)sleb.getValue((MemBuffer)buf, sleb.getDefaultSettings(), numAvailBytes);
            long offset = scalar.getSignedValue();
            int readLen = sleb.getLength((MemBuffer)buf, numAvailBytes);
            context.setDecodedValue(offset, readLen);
            return offset;
        }

        @Override
        public DataType getDataType(Program program) {
            return SLEB_DATA_TYPE;
        }
    }

    static final class DW_EH_PE_signed_Decoder
    extends AbstractSignedDwarEHfDecoder {
        public DW_EH_PE_signed_Decoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
            super(mode, isIndirect);
        }

        @Override
        public DwarfEHDataDecodeFormat getDataFormat() {
            return DwarfEHDataDecodeFormat.DW_EH_PE_signed;
        }

        @Override
        public int getDecodeSize(Program program) {
            return -1;
        }

        @Override
        public long doDecode(DwarfDecodeContext context) throws MemoryAccessException {
            throw new MemoryAccessException("Don't know now to decode DW_EH_PE_signed-encoded values");
        }

        @Override
        public DataType getDataType(Program program) {
            return new VoidDataType();
        }
    }

    static final class DW_EH_PE_udata8_Decoder
    extends AbstractUnsignedDwarfEHDecoder {
        public DW_EH_PE_udata8_Decoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
            super(mode, isIndirect);
        }

        @Override
        public DwarfEHDataDecodeFormat getDataFormat() {
            return DwarfEHDataDecodeFormat.DW_EH_PE_udata8;
        }

        @Override
        public int getDecodeSize(Program program) {
            return 8;
        }

        @Override
        public long doDecode(DwarfDecodeContext context) throws MemoryAccessException {
            Program program = context.getProgram();
            Address addr = context.getAddress();
            long offset = DW_EH_PE_udata8_Decoder.readQWord(program, addr);
            context.setDecodedValue(offset, 8);
            return offset;
        }

        @Override
        public DataType getDataType(Program program) {
            return QWORD_DATA_TYPE;
        }
    }

    static final class DW_EH_PE_udata4_Decoder
    extends AbstractUnsignedDwarfEHDecoder {
        public DW_EH_PE_udata4_Decoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
            super(mode, isIndirect);
        }

        @Override
        public DwarfEHDataDecodeFormat getDataFormat() {
            return DwarfEHDataDecodeFormat.DW_EH_PE_udata4;
        }

        @Override
        public int getDecodeSize(Program program) {
            return 4;
        }

        @Override
        public long doDecode(DwarfDecodeContext context) throws MemoryAccessException {
            Program program = context.getProgram();
            Address addr = context.getAddress();
            long offset = DW_EH_PE_udata4_Decoder.readDWord(program, addr);
            context.setDecodedValue(offset, 4);
            return offset;
        }

        @Override
        public DataType getDataType(Program program) {
            return DWORD_DATA_TYPE;
        }
    }

    static final class DW_EH_PE_udata2_Decoder
    extends AbstractUnsignedDwarfEHDecoder {
        public DW_EH_PE_udata2_Decoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
            super(mode, isIndirect);
        }

        @Override
        public DwarfEHDataDecodeFormat getDataFormat() {
            return DwarfEHDataDecodeFormat.DW_EH_PE_udata2;
        }

        @Override
        public int getDecodeSize(Program program) {
            return 2;
        }

        @Override
        public long doDecode(DwarfDecodeContext context) throws MemoryAccessException {
            Program program = context.getProgram();
            Address addr = context.getAddress();
            long offset = DW_EH_PE_udata2_Decoder.readWord(program, addr);
            context.setDecodedValue(offset, 2);
            return offset;
        }

        @Override
        public DataType getDataType(Program program) {
            return WORD_DATA_TYPE;
        }
    }

    static final class DW_EH_PE_uleb128_Decoder
    extends AbstractUnsignedDwarfEHDecoder {
        public DW_EH_PE_uleb128_Decoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
            super(mode, isIndirect);
        }

        @Override
        public DwarfEHDataDecodeFormat getDataFormat() {
            return DwarfEHDataDecodeFormat.DW_EH_PE_uleb128;
        }

        @Override
        public int getDecodeSize(Program program) {
            return -1;
        }

        @Override
        public long doDecode(DwarfDecodeContext context) throws MemoryAccessException {
            Program program = context.getProgram();
            Address addr = context.getAddress();
            DumbMemBufferImpl buf = new DumbMemBufferImpl(program.getMemory(), addr);
            UnsignedLeb128DataType uleb = UnsignedLeb128DataType.dataType;
            int numAvailBytes = uleb.getLength((MemBuffer)buf, -1);
            Scalar scalar = (Scalar)uleb.getValue((MemBuffer)buf, uleb.getDefaultSettings(), numAvailBytes);
            long offset = scalar.getUnsignedValue();
            int readLen = uleb.getLength((MemBuffer)buf, numAvailBytes);
            context.setDecodedValue(offset, readLen);
            return offset;
        }

        @Override
        public DataType getDataType(Program program) {
            return ULEB_DATA_TYPE;
        }
    }

    static final class DW_EH_PE_omit_Decoder
    extends AbstractUnsignedDwarfEHDecoder {
        public DW_EH_PE_omit_Decoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
            super(mode, isIndirect);
        }

        @Override
        public DwarfEHDataDecodeFormat getDataFormat() {
            return DwarfEHDataDecodeFormat.DW_EH_PE_omit;
        }

        @Override
        public int getDecodeSize(Program program) {
            return 0;
        }

        @Override
        public long doDecode(DwarfDecodeContext context) throws MemoryAccessException {
            context.setDecodedValue(null, 0);
            return 0L;
        }

        @Override
        public DataType getDataType(Program program) {
            return new VoidDataType();
        }
    }

    static final class DW_EH_PE_absptr_Decoder
    extends AbstractUnsignedDwarfEHDecoder {
        public DW_EH_PE_absptr_Decoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
            super(mode, isIndirect);
        }

        @Override
        public DwarfEHDataDecodeFormat getDataFormat() {
            return DwarfEHDataDecodeFormat.DW_EH_PE_absptr;
        }

        @Override
        public int getDecodeSize(Program program) {
            AddressSpace defaultAddressSpace = program.getAddressFactory().getDefaultAddressSpace();
            Address maxAddress = defaultAddressSpace.getMaxAddress();
            int pointerSize = maxAddress.getPointerSize();
            switch (pointerSize) {
                case 3: {
                    return 4;
                }
                case 5: 
                case 6: 
                case 7: {
                    return 8;
                }
            }
            return pointerSize;
        }

        @Override
        public long doDecode(DwarfDecodeContext context) throws MemoryAccessException {
            Program program = context.getProgram();
            Address addr = context.getAddress();
            MemoryBufferImpl memBuf = new MemoryBufferImpl(program.getMemory(), addr);
            int decodeSize = this.getDecodeSize(program);
            long offset = this.ptrval((MemBuffer)memBuf, decodeSize);
            context.setDecodedValue(offset, decodeSize);
            return offset;
        }

        @Override
        public DataType getDataType(Program program) {
            int ptrSize = this.getDecodeSize(program);
            switch (ptrSize) {
                case 2: {
                    return WORD_DATA_TYPE;
                }
                case 4: {
                    return DWORD_DATA_TYPE;
                }
                case 8: {
                    return QWORD_DATA_TYPE;
                }
            }
            throw new IllegalStateException("Don't have a type for " + ptrSize + "-byte pointers");
        }
    }

    private static abstract class AbstractUnsignedDwarfEHDecoder
    extends AbstractDwarfEHDecoder {
        public AbstractUnsignedDwarfEHDecoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
            super(mode, isIndirect);
        }

        @Override
        public boolean isSigned() {
            return false;
        }
    }

    private static abstract class AbstractSignedDwarEHfDecoder
    extends AbstractDwarfEHDecoder {
        public AbstractSignedDwarEHfDecoder(DwarfEHDataApplicationMode mode, boolean isIndirect) {
            super(mode, isIndirect);
        }

        @Override
        public boolean isSigned() {
            return true;
        }
    }
}

