/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import generic.jar.ResourceFile;
import ghidra.app.script.ResourceFileJavaFileObject;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class ResourceFileJavaFileManager
implements JavaFileManager {
    private StandardJavaFileManager fileManager;
    private List<ResourceFile> sourceDirs;
    private Set<ResourceFile> filesToAvoid;

    public ResourceFileJavaFileManager(List<ResourceFile> sourceDirs, Set<ResourceFile> filesToAvoid) {
        this.sourceDirs = sourceDirs;
        this.filesToAvoid = filesToAvoid;
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (javaCompiler == null) {
            throw new AssertException("Can't find java compiler");
        }
        this.fileManager = javaCompiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
    }

    @Override
    public int isSupportedOption(String option) {
        return this.fileManager.isSupportedOption(option);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.fileManager.getClassLoader(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (location.equals(StandardLocation.SOURCE_PATH)) {
            String relativePath = packageName.replace('.', '/');
            ArrayList<JavaFileObject> newResult = new ArrayList<JavaFileObject>();
            for (ResourceFile sourceDir : this.sourceDirs) {
                ResourceFile packageDir = relativePath.isEmpty() ? sourceDir : new ResourceFile(sourceDir, relativePath);
                if (!packageDir.isDirectory()) continue;
                this.gatherFiles(sourceDir, packageDir, newResult, kinds, recurse);
            }
            return newResult;
        }
        return this.fileManager.list(location, packageName, kinds, recurse);
    }

    private void gatherFiles(ResourceFile root, ResourceFile file, List<JavaFileObject> accumulator, Set<JavaFileObject.Kind> kinds, boolean recurse) {
        ArrayList<ResourceFile> listFiles = new ArrayList<ResourceFile>(Arrays.asList(file.listFiles()));
        listFiles.removeAll(this.filesToAvoid);
        block0: for (ResourceFile resourceFile : listFiles) {
            if (resourceFile.isDirectory()) {
                if (!recurse) continue;
                this.gatherFiles(root, resourceFile, accumulator, kinds, recurse);
                continue;
            }
            for (JavaFileObject.Kind kind : kinds) {
                if (kind == JavaFileObject.Kind.CLASS) {
                    if (!resourceFile.getName().endsWith(".class")) continue;
                    accumulator.add(this.createFileObject(root, resourceFile, kind));
                    continue block0;
                }
                if (kind != JavaFileObject.Kind.SOURCE || !resourceFile.getName().endsWith(".java")) continue;
                accumulator.add(this.createFileObject(root, resourceFile, kind));
                continue block0;
            }
        }
    }

    private JavaFileObject createFileObject(ResourceFile root, ResourceFile resourceFile, JavaFileObject.Kind kind) {
        try {
            return new ResourceFileJavaFileObject(root, resourceFile, kind);
        }
        catch (Exception e) {
            throw new AssertException("Unexpected url exception on resource file" + resourceFile);
        }
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof ResourceFileJavaFileObject) {
            String name = file.getName();
            int lastIndexOf = name.lastIndexOf(".java");
            if (lastIndexOf >= 0) {
                String path = name.substring(0, lastIndexOf);
                path = path.replace('/', '.').replace('\\', '.');
                return path;
            }
            throw new AssertException("Expected name to end in .java but got " + name);
        }
        String inferBinaryName = this.fileManager.inferBinaryName(location, file);
        return inferBinaryName;
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return a.toUri().equals(b.toUri());
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.fileManager.handleOption(current, remaining);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        if (location.equals(StandardLocation.SOURCE_PATH)) {
            return true;
        }
        return this.fileManager.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        if (!location.equals(StandardLocation.SOURCE_PATH) || "module-info".equals(className)) {
            return this.fileManager.getJavaFileForInput(location, className, kind);
        }
        String relativePath = className.replace('.', '/');
        for (ResourceFile sourceDir : this.sourceDirs) {
            ResourceFile file = new ResourceFile(sourceDir, relativePath);
            if (!file.exists()) continue;
            return this.createFileObject(sourceDir, file, kind);
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return this.fileManager.getJavaFileForOutput(location, className, kind, sibling);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.fileManager.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.fileManager.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public void flush() throws IOException {
        this.fileManager.flush();
    }

    @Override
    public void close() throws IOException {
        this.fileManager.close();
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        return this.fileManager.getLocationForModule(location, moduleName);
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        return this.fileManager.getLocationForModule(location, fo);
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) throws IOException {
        return this.fileManager.inferModuleName(location);
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        return this.fileManager.listLocationsForModules(location);
    }

    @Override
    public boolean contains(JavaFileManager.Location location, FileObject fo) throws IOException {
        return this.fileManager.contains(location, fo);
    }

    @Override
    public <S> ServiceLoader<S> getServiceLoader(JavaFileManager.Location location, Class<S> service) throws IOException {
        return this.fileManager.getServiceLoader(location, service);
    }
}

