/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.util.HexLong;
import ghidra.app.util.OptionListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.util.NumericUtilities;
import java.awt.Component;

public class Option {
    private final String group;
    private final String name;
    private final Class<?> valueClass;
    private final String commandLineArgument;
    private Object value;
    private OptionListener listener;

    public Option(String name, Object value) {
        this(null, name, value);
    }

    public Option(String group, String name, Object value) {
        this(name, Option.getValueClass(value), value, null, group);
    }

    public Option(String name, Class<?> valueClass) {
        this(name, valueClass, null, null, null);
    }

    public Option(String name, Object value, Class<?> valueClass, String arg) {
        this(name, valueClass, value, arg, null);
    }

    public Option(String name, Class<?> valueClass, Object value, String arg, String group) {
        this.name = name;
        this.valueClass = valueClass;
        this.commandLineArgument = arg;
        this.group = group;
        this.value = value;
    }

    public void setOptionListener(OptionListener listener) {
        this.listener = listener;
    }

    public Component getCustomEditorComponent() {
        return null;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        if (object != null && !this.valueClass.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("Value class does not match! Expected " + this.valueClass + ", but got " + object.getClass());
        }
        this.value = object;
        if (this.listener != null) {
            this.listener.optionChanged(this);
        }
    }

    public boolean parseAndSetValueByType(String str, AddressFactory addressFactory) {
        if (this.getValueClass() == null) {
            return false;
        }
        if (Boolean.class.isAssignableFrom(this.getValueClass())) {
            Boolean b = null;
            if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("t") || str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("y")) {
                b = true;
            } else if (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("f") || str.equalsIgnoreCase("no") || str.equalsIgnoreCase("n")) {
                b = false;
            }
            if (b == null) {
                return false;
            }
            this.setValue(b);
        } else if (HexLong.class.isAssignableFrom(this.getValueClass())) {
            try {
                this.setValue(new HexLong(NumericUtilities.parseHexLong((String)str)));
            }
            catch (NumberFormatException e) {
                return false;
            }
        } else if (Address.class.isAssignableFrom(this.getValueClass())) {
            try {
                Address origAddr = (Address)this.getValue();
                Address newAddr = null;
                if (origAddr != null) {
                    newAddr = origAddr.getAddress(str);
                } else {
                    if (addressFactory == null) {
                        throw new RuntimeException("Attempted to use Address type option (" + this.getName() + ") without specifying Address Factory");
                    }
                    newAddr = addressFactory.getDefaultAddressSpace().getAddress(str);
                }
                if (newAddr == null) {
                    return false;
                }
                this.setValue(newAddr);
            }
            catch (AddressFormatException e) {
                return false;
            }
        } else if (String.class.isAssignableFrom(this.getValueClass())) {
            this.setValue(str);
        } else {
            return false;
        }
        return true;
    }

    public String getArg() {
        return this.commandLineArgument;
    }

    public String toString() {
        return "Group:\"" + this.group + "\" Name:\"" + this.name + "\" Arg:\"" + this.commandLineArgument + "\" Type:\"" + this.valueClass + "\" Value:\"" + this.value + "\"";
    }

    public Option copy() {
        return new Option(this.name, this.valueClass, this.value, this.commandLineArgument, this.group);
    }

    private static Class<?> getValueClass(Object v) {
        if (v == null) {
            throw new IllegalArgumentException("Value cannot be null without specifying class.");
        }
        return v.getClass();
    }
}

