/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next.sectionprovider;

import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.RandomAccessByteProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.program.model.listing.Program;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DSymSectionProvider
implements DWARFSectionProvider {
    private MachHeader machHeader;
    private Map<String, Section> machSectionsByName = new HashMap<String, Section>();
    private RandomAccessByteProvider provider;

    public static File getDSYMForProgram(Program program) {
        File exePath = new File(program.getExecutablePath());
        File dSymFile = new File(exePath.getParentFile(), exePath.getName() + ".dSYM/Contents/Resources/DWARF/" + exePath.getName());
        return dSymFile.isFile() ? dSymFile : null;
    }

    public static DSymSectionProvider createSectionProviderFor(Program program) {
        File dsymFile;
        if ("Mac OS X Mach-O".equals(program.getExecutableFormat()) && (dsymFile = DSymSectionProvider.getDSYMForProgram(program)) != null) {
            try {
                return new DSymSectionProvider(dsymFile);
            }
            catch (MachException | IOException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public DSymSectionProvider(File dsymFile) throws IOException, MachException {
        this.provider = new RandomAccessByteProvider(dsymFile);
        this.machHeader = MachHeader.createMachHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, this.provider);
        this.machHeader.parse();
        for (Section s : this.machHeader.getAllSections()) {
            String fixedSectionName = s.getSectionName().replaceFirst("^_*", "");
            this.machSectionsByName.put(fixedSectionName, s);
        }
    }

    @Override
    public ByteProvider getSectionAsByteProvider(String sectionName) throws IOException {
        Section s = this.machSectionsByName.get(sectionName);
        return s != null ? new ByteProviderWrapper(this.provider, this.machHeader.getStartIndex() + (long)s.getOffset(), s.getSize()) : null;
    }

    @Override
    public void close() {
        try {
            this.provider.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasSection(String ... sectionNames) {
        for (String sectionName : sectionNames) {
            if (this.machSectionsByName.get(sectionName) != null) continue;
            return false;
        }
        return true;
    }
}

