/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.ne.InvalidWindowsHeaderException;
import ghidra.util.Conv;
import java.io.IOException;

public class InformationBlock {
    private static final String TAB = "        ";
    public static final byte FLAGS_PROG_NO_AUTO_DATA = 0;
    public static final byte FLAGS_PROG_SINGLE_DATA = 1;
    public static final byte FLAGS_PROG_MULTIPLE_DATA = 2;
    public static final byte FLAGS_PROG_GLOBAL_INIT = 4;
    public static final byte FLAGS_PROG_PROTECTED_MODE = 8;
    public static final byte FLAGS_PROG_8086 = 16;
    public static final byte FLAGS_PROG_80286 = 32;
    public static final byte FLAGS_PROG_80386 = 64;
    public static final byte FLAGS_PROG_80x87 = -128;
    public static final byte FLAGS_APP_FULL_SCREEN = 1;
    public static final byte FLAGS_APP_WIN_PM_COMPATIBLE = 2;
    public static final byte FLAGS_APP_WINDOWS_PM = 3;
    public static final byte FLAGS_APP_LOAD_CODE = 8;
    public static final byte FLAGS_APP_LINK_ERRS = 32;
    public static final byte FLAGS_APP_NONCONFORMING_PROG = 64;
    public static final byte FLAGS_APP_LIBRARY_MODULE = -128;
    public static final byte EXETYPE_UNKNOWN = 0;
    public static final byte EXETYPE_OS2 = 1;
    public static final byte EXETYPE_WINDOWS = 2;
    public static final byte EXETYPE_EUROPEAN_DOS_4 = 4;
    public static final byte EXETYPE_RESERVED4 = 8;
    public static final byte EXETYPE_WINDOWS_386 = 4;
    public static final byte EXETYPE_BOSS = 5;
    public static final byte EXETYPE_PHARLAP_286_OS2 = -127;
    public static final byte EXETYPE_PHARLAP_286_WIN = -126;
    public static final byte OTHER_FLAGS_SUPPORTS_LONG_NAMES = 0;
    public static final byte OTHER_FLAGS_PROTECTED_MODE = 1;
    public static final byte OTHER_FLAGS_PROPORTIONAL_FONT = 2;
    public static final byte OTHER_FLAGS_GANGLOAD_AREA = 4;
    private short ne_magic;
    private byte ne_ver;
    private byte ne_rev;
    private short ne_enttab;
    private short ne_cbenttab;
    private int ne_crc;
    private byte ne_flags_prog;
    private byte ne_flags_app;
    private short ne_autodata;
    private short ne_heap;
    private short ne_stack;
    private int ne_csip;
    private int ne_sssp;
    private short ne_cseg;
    private short ne_cmod;
    private short ne_cbnrestab;
    private short ne_segtab;
    private short ne_rsrctab;
    private short ne_restab;
    private short ne_modtab;
    private short ne_imptab;
    private int ne_nrestab;
    private short ne_cmovent;
    private short ne_align;
    private short ne_cres;
    private byte ne_exetyp;
    private byte ne_flagsothers;
    private short ne_pretthunks;
    private short ne_psegrefbytes;
    private short ne_swaparea;
    private short ne_expver;

    InformationBlock(FactoryBundledWithBinaryReader reader, short index) throws InvalidWindowsHeaderException, IOException {
        long oldIndex = reader.getPointerIndex();
        reader.setPointerIndex(Conv.shortToInt((short)index));
        this.ne_magic = reader.readNextShort();
        if (this.ne_magic != 17742) {
            throw new InvalidWindowsHeaderException();
        }
        this.ne_ver = reader.readNextByte();
        this.ne_rev = reader.readNextByte();
        this.ne_enttab = reader.readNextShort();
        this.ne_cbenttab = reader.readNextShort();
        this.ne_crc = reader.readNextInt();
        this.ne_flags_prog = reader.readNextByte();
        this.ne_flags_app = reader.readNextByte();
        this.ne_autodata = reader.readNextShort();
        this.ne_heap = reader.readNextShort();
        this.ne_stack = reader.readNextShort();
        this.ne_csip = reader.readNextInt();
        this.ne_sssp = reader.readNextInt();
        this.ne_cseg = reader.readNextShort();
        this.ne_cmod = reader.readNextShort();
        this.ne_cbnrestab = reader.readNextShort();
        this.ne_segtab = reader.readNextShort();
        this.ne_rsrctab = reader.readNextShort();
        this.ne_restab = reader.readNextShort();
        this.ne_modtab = reader.readNextShort();
        this.ne_imptab = reader.readNextShort();
        this.ne_nrestab = reader.readNextInt();
        this.ne_cmovent = reader.readNextShort();
        this.ne_align = reader.readNextShort();
        this.ne_cres = reader.readNextShort();
        this.ne_exetyp = reader.readNextByte();
        this.ne_flagsothers = reader.readNextByte();
        this.ne_pretthunks = reader.readNextShort();
        this.ne_psegrefbytes = reader.readNextShort();
        this.ne_swaparea = reader.readNextShort();
        this.ne_expver = reader.readNextShort();
        reader.setPointerIndex(oldIndex);
    }

    public short getMagicNumber() {
        return this.ne_magic;
    }

    public short getVersion() {
        return this.ne_ver;
    }

    public short getRevision() {
        return this.ne_rev;
    }

    public int getChecksum() {
        return this.ne_crc;
    }

    public short getInitialHeapSize() {
        return this.ne_heap;
    }

    public short getInitialStackSize() {
        return this.ne_stack;
    }

    public byte getTargetOpSys() {
        return this.ne_exetyp;
    }

    public short getMinCodeSwapSize() {
        return this.ne_swaparea;
    }

    public short getExpectedWindowsVersion() {
        return this.ne_expver;
    }

    public short getAutomaticDataSegment() {
        return this.ne_autodata;
    }

    public byte getOtherFlags() {
        return this.ne_flagsothers;
    }

    public String getOtherFlagsAsString() {
        StringBuffer buffer = new StringBuffer();
        if ((this.ne_flagsothers & 4) != 0) {
            buffer.append("        Gangload Area\n");
        }
        if ((this.ne_flagsothers & 2) != 0) {
            buffer.append("        Proportional Font\n");
        }
        if ((this.ne_flagsothers & 1) != 0) {
            buffer.append("        Protected Mode\n");
        }
        if ((this.ne_flagsothers & 0) != 0) {
            buffer.append("        Long Name Support\n");
        }
        return buffer.toString();
    }

    public byte getProgramFlags() {
        return this.ne_flags_prog;
    }

    public byte getApplicationFlags() {
        return this.ne_flags_app;
    }

    public short getEntryPointSegment() {
        return (short)(this.ne_csip >> 16 & 0xFFFF);
    }

    public short getEntryPointOffset() {
        return (short)(this.ne_csip & 0xFFFF);
    }

    public short getStackPointerSegment() {
        return (short)(this.ne_sssp >> 16 & 0xFFFF);
    }

    public short getStackPointerOffset() {
        return (short)(this.ne_sssp & 0xFFFF);
    }

    short getSegmentTableOffset() {
        return this.ne_segtab;
    }

    short getSegmentCount() {
        return this.ne_cseg;
    }

    short getSegmentAlignmentShiftCount() {
        return this.ne_align;
    }

    short getResourceTableOffset() {
        return this.ne_rsrctab;
    }

    short getResidentNameTableOffset() {
        return this.ne_restab;
    }

    short getModuleReferenceTableOffset() {
        return this.ne_modtab;
    }

    short getModuleReferenceTableCount() {
        return this.ne_cmod;
    }

    short getImportedNamesTableOffset() {
        return this.ne_imptab;
    }

    short getEntryTableOffset() {
        return this.ne_enttab;
    }

    short getEntryTableSize() {
        return this.ne_cbenttab;
    }

    int getNonResidentNameTableOffset() {
        return this.ne_nrestab;
    }

    short getNonResidentNameTableSize() {
        return this.ne_cbnrestab;
    }

    short getMoveableEntriesCount() {
        return this.ne_cmovent;
    }

    short getResourceSegmentCount() {
        return this.ne_cres;
    }

    short getReturnOffsetThunk() {
        return this.ne_pretthunks;
    }

    short getSegmentRefByteOffset() {
        return this.ne_psegrefbytes;
    }

    public String getTargetOpSysAsString() {
        switch (this.ne_exetyp) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "OS/2";
            }
            case 2: {
                return "Windows";
            }
            case 8: {
                return "Reserved 4";
            }
            case 4: {
                return "Windows 386";
            }
            case 5: {
                return "Borland Operating System Services";
            }
            case -127: {
                return "Pharlap 286 OS/2";
            }
            case -126: {
                return "Pharlap 286 Windows";
            }
        }
        return null;
    }

    public String getApplicationFlagsAsString() {
        StringBuffer buffer = new StringBuffer();
        byte application_type = (byte)(this.ne_flags_app & 3);
        if (application_type == 1) {
            buffer.append("        Full Screen\n");
        } else if (application_type == 2) {
            buffer.append("        Windows P.M. API Compatible\n");
        } else if (application_type == 3) {
            buffer.append("        Windows P.M. API\n");
        }
        if ((this.ne_flags_app & 0xFFFFFF80) != 0) {
            buffer.append("        Library Module\n");
        }
        if ((this.ne_flags_app & 0x20) != 0) {
            buffer.append("        Link Errors\n");
        }
        if ((this.ne_flags_app & 8) != 0) {
            buffer.append("        Load Code\n");
        }
        if ((this.ne_flags_app & 0x40) != 0) {
            buffer.append("        Nonconforming\n");
        }
        return buffer.toString();
    }

    public String getProgramFlagsAsString() {
        StringBuffer buffer = new StringBuffer();
        if ((this.ne_flags_prog & 0x20) != 0) {
            buffer.append("        80286\n");
        }
        if ((this.ne_flags_prog & 0x40) != 0) {
            buffer.append("        80386\n");
        }
        if ((this.ne_flags_prog & 0x10) != 0) {
            buffer.append("        8086\n");
        }
        if ((this.ne_flags_prog & 4) != 0) {
            buffer.append("        Global Init\n");
        }
        if ((this.ne_flags_prog & 1) != 0) {
            buffer.append("        Single Data\n");
        }
        if ((this.ne_flags_prog & 2) != 0) {
            buffer.append("        Multi Data\n");
        }
        if ((this.ne_flags_prog & 0) != 0) {
            buffer.append("        No Auto Data\n");
        }
        if ((this.ne_flags_prog & 8) != 0) {
            buffer.append("        Protected Mode\n");
        }
        return buffer.toString();
    }
}

