/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import generic.continues.GenericFactory;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.mz.DOSHeader;
import ghidra.app.util.bin.format.ne.InvalidWindowsHeaderException;
import ghidra.app.util.bin.format.ne.WindowsHeader;
import ghidra.program.model.address.SegmentedAddress;
import java.io.IOException;

public class NewExecutable {
    private FactoryBundledWithBinaryReader reader;
    private DOSHeader dosHeader;
    private WindowsHeader winHeader;

    public NewExecutable(GenericFactory factory, ByteProvider bp, SegmentedAddress baseAddr) throws IOException {
        this.reader = new FactoryBundledWithBinaryReader(factory, bp, true);
        this.dosHeader = DOSHeader.createDOSHeader(this.reader);
        if (this.dosHeader.isDosSignature()) {
            try {
                this.winHeader = new WindowsHeader(this.reader, baseAddr, (short)this.dosHeader.e_lfanew());
            }
            catch (InvalidWindowsHeaderException invalidWindowsHeaderException) {
                // empty catch block
            }
        }
    }

    public FactoryBundledWithBinaryReader getBinaryReader() {
        return this.reader;
    }

    public DOSHeader getDOSHeader() {
        return this.dosHeader;
    }

    public WindowsHeader getWindowsHeader() {
        return this.winHeader;
    }
}

