/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.ne.EntryTable;
import ghidra.app.util.bin.format.ne.ImportedNameTable;
import ghidra.app.util.bin.format.ne.InformationBlock;
import ghidra.app.util.bin.format.ne.InvalidWindowsHeaderException;
import ghidra.app.util.bin.format.ne.ModuleReferenceTable;
import ghidra.app.util.bin.format.ne.NonResidentNameTable;
import ghidra.app.util.bin.format.ne.ResidentNameTable;
import ghidra.app.util.bin.format.ne.ResourceTable;
import ghidra.app.util.bin.format.ne.SegmentTable;
import ghidra.program.model.address.SegmentedAddress;
import java.io.IOException;

public class WindowsHeader {
    public static final short IMAGE_NE_SIGNATURE = 17742;
    private InformationBlock infoBlock;
    private SegmentTable segTable;
    private ResourceTable rsrcTable;
    private ResidentNameTable resNameTable;
    private ModuleReferenceTable modRefTable;
    private ImportedNameTable impNameTable;
    private EntryTable entryTable;
    private NonResidentNameTable nonResNameTable;

    public WindowsHeader(FactoryBundledWithBinaryReader reader, SegmentedAddress baseAddr, short index) throws InvalidWindowsHeaderException, IOException {
        this.infoBlock = new InformationBlock(reader, index);
        short segTableIndex = (short)(this.infoBlock.getSegmentTableOffset() + index);
        this.segTable = new SegmentTable(reader, baseAddr, segTableIndex, this.infoBlock.getSegmentCount(), this.infoBlock.getSegmentAlignmentShiftCount());
        if (this.infoBlock.getResourceTableOffset() != this.infoBlock.getResidentNameTableOffset()) {
            short rsrcTableIndex = (short)(this.infoBlock.getResourceTableOffset() + index);
            this.rsrcTable = new ResourceTable(reader, rsrcTableIndex);
        }
        short resNameTableIndex = (short)(this.infoBlock.getResidentNameTableOffset() + index);
        this.resNameTable = new ResidentNameTable(reader, resNameTableIndex);
        short impNameTableIndex = (short)(this.infoBlock.getImportedNamesTableOffset() + index);
        this.impNameTable = new ImportedNameTable(reader, impNameTableIndex);
        short modRefTableIndex = (short)(this.infoBlock.getModuleReferenceTableOffset() + index);
        this.modRefTable = new ModuleReferenceTable(reader, modRefTableIndex, this.infoBlock.getModuleReferenceTableCount(), this.impNameTable);
        short entryTableIndex = (short)(this.infoBlock.getEntryTableOffset() + index);
        this.entryTable = new EntryTable(reader, entryTableIndex, this.infoBlock.getEntryTableSize());
        this.nonResNameTable = new NonResidentNameTable(reader, this.infoBlock.getNonResidentNameTableOffset(), this.infoBlock.getNonResidentNameTableSize());
    }

    public String getProcessorName() {
        return "x86";
    }

    public InformationBlock getInformationBlock() {
        return this.infoBlock;
    }

    public SegmentTable getSegmentTable() {
        return this.segTable;
    }

    public ResourceTable getResourceTable() {
        return this.rsrcTable;
    }

    public ResidentNameTable getResidentNameTable() {
        return this.resNameTable;
    }

    public ModuleReferenceTable getModuleReferenceTable() {
        return this.modRefTable;
    }

    public ImportedNameTable getImportedNameTable() {
        return this.impNameTable;
    }

    public EntryTable getEntryTable() {
        return this.entryTable;
    }

    public NonResidentNameTable getNonResidentNameTable() {
        return this.nonResNameTable;
    }
}

