/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.DemanglerUtil;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class DemangledObject
implements Demangled {
    protected static final String SPACE = " ";
    protected static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    protected static final String NAMESPACE_SEPARATOR = "::";
    protected static final String EMPTY_STRING = "";
    protected final String mangled;
    protected final String originalDemangled;
    protected String specialPrefix;
    protected Demangled namespace;
    protected String visibility;
    protected String storageClass;
    protected boolean isStatic;
    protected boolean isVirtual;
    private String demangledName;
    private String name;
    private boolean isConst;
    private boolean isVolatile;
    private boolean isPointer64;
    protected boolean isThunk;
    protected boolean isUnaligned;
    protected boolean isRestrict;
    protected String basedName;
    protected String memberScope;
    private String plateComment;
    private boolean demangledNameSucceeded = false;

    DemangledObject(String mangled, String originalDemangled) {
        this.mangled = mangled;
        this.originalDemangled = originalDemangled;
    }

    @Override
    public String getDemangledName() {
        return this.demangledName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public void setConst(boolean isConst) {
        this.isConst = isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void setVolatile(boolean isVolatile) {
        this.isVolatile = isVolatile;
    }

    public boolean isPointer64() {
        return this.isPointer64;
    }

    public void setPointer64(boolean isPointer64) {
        this.isPointer64 = isPointer64;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
    }

    public boolean isThunk() {
        return this.isThunk;
    }

    public void setThunk(boolean isThunk) {
        this.isThunk = isThunk;
    }

    public void setUnaligned() {
        this.isUnaligned = true;
    }

    public boolean isUnaligned() {
        return this.isUnaligned;
    }

    public void setRestrict() {
        this.isRestrict = true;
    }

    public boolean isRestrict() {
        return this.isRestrict;
    }

    public String getBasedName() {
        return this.basedName;
    }

    public void setBasedName(String basedName) {
        this.basedName = basedName;
    }

    public String getMemberScope() {
        return this.memberScope;
    }

    public void setMemberScope(String memberScope) {
        this.memberScope = memberScope;
    }

    @Override
    public void setName(String name) {
        this.demangledName = name;
        this.name = name;
        if (name != null) {
            this.name = DemanglerUtil.stripSuperfluousSignatureSpaces(name).trim().replace(' ', '_');
        }
        this.demangledNameSucceeded = !this.mangled.equals(name);
    }

    public boolean demangledNameSuccessfully() {
        return this.demangledNameSucceeded;
    }

    @Override
    public String getMangledString() {
        return this.mangled;
    }

    @Override
    public String getOriginalDemangled() {
        return this.originalDemangled;
    }

    @Override
    public Demangled getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(Demangled namespace) {
        this.namespace = namespace;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibilty(String visibility) {
        this.visibility = visibility;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public String getSpecialPrefix() {
        return this.specialPrefix;
    }

    public void setSpecialPrefix(String special) {
        this.specialPrefix = special;
    }

    public abstract String getSignature(boolean var1);

    @Override
    public final String getSignature() {
        return this.getSignature(false);
    }

    @Override
    public String getNamespaceName() {
        return this.getName();
    }

    public String toString() {
        return this.getSignature(false);
    }

    @Override
    public String getNamespaceString() {
        StringBuilder buffer = new StringBuilder();
        if (this.namespace != null) {
            buffer.append(this.namespace.getNamespaceString());
            buffer.append(NAMESPACE_SEPARATOR);
        }
        buffer.append(this.getNamespaceName());
        return buffer.toString();
    }

    protected boolean isAlreadyDemangled(Program program, Address address) {
        Symbol[] symbols;
        String symbolName = DemangledObject.ensureNameLength(this.name);
        if (address.isExternalAddress()) {
            Symbol extSymbol = program.getSymbolTable().getPrimarySymbol(address);
            if (extSymbol == null) {
                return false;
            }
            ExternalLocation extLoc = program.getExternalManager().getExternalLocation(extSymbol);
            return extLoc.getOriginalImportedName() != null;
        }
        for (Symbol symbol : symbols = program.getSymbolTable().getSymbols(address)) {
            SymbolType symbolType;
            if (!symbol.getName().equals(symbolName) || symbol.getParentNamespace().isGlobal() || (symbolType = symbol.getSymbolType()) != SymbolType.LABEL && symbolType != SymbolType.FUNCTION) continue;
            return true;
        }
        return false;
    }

    public boolean applyTo(Program program, Address address, DemanglerOptions options, TaskMonitor monitor) throws Exception {
        return this.applyPlateCommentOnly(program, address);
    }

    public boolean applyPlateCommentOnly(Program program, Address address) throws Exception {
        if (!this.demangledNameSuccessfully()) {
            throw new DemangledException("Symbol did not demangle at address: " + address);
        }
        if (!address.isMemoryAddress() || !program.getMemory().contains(address)) {
            return true;
        }
        Object comment = program.getListing().getComment(3, address);
        String newComment = this.generatePlateComment();
        if (comment == null || ((String)comment).indexOf(newComment) < 0) {
            comment = comment == null ? newComment : (String)comment + "\n" + newComment;
            program.getListing().setComment(address, 3, (String)comment);
        }
        return true;
    }

    public void setBackupPlateComment(String plateComment) {
        this.plateComment = plateComment;
    }

    protected String generatePlateComment() {
        if (this.originalDemangled != null) {
            return this.originalDemangled;
        }
        return this.plateComment == null ? this.getSignature(true) : this.plateComment;
    }

    protected Symbol applyDemangledName(Address addr, boolean setPrimary, boolean functionNamespacePermitted, Program prog) throws InvalidInputException {
        return this.applyDemangledName(this.name, addr, setPrimary, functionNamespacePermitted, prog);
    }

    protected Symbol applyDemangledName(String symbolName, Address addr, boolean setPrimary, boolean functionNamespacePermitted, Program prog) throws InvalidInputException {
        symbolName = DemangledObject.ensureNameLength(symbolName);
        if (addr.isExternalAddress()) {
            return this.updateExternalSymbol(prog, addr, symbolName, this.namespace);
        }
        SymbolTable symbolTable = prog.getSymbolTable();
        Namespace ns = DemangledObject.createNamespace(prog, this.namespace, null, functionNamespacePermitted);
        Symbol demangledSymbol = SymbolUtilities.createPreferredLabelOrFunctionSymbol((Program)prog, (Address)addr, (Namespace)ns, (String)symbolName, (SourceType)SourceType.ANALYSIS);
        if (demangledSymbol == null || !setPrimary) {
            return demangledSymbol;
        }
        SetLabelPrimaryCmd cmd = new SetLabelPrimaryCmd(addr, symbolName, ns);
        cmd.applyTo((DomainObject)prog);
        return symbolTable.getPrimarySymbol(addr);
    }

    private Symbol updateExternalSymbol(Program program, Address externalAddr, String symbolName, Demangled demangledNamespace) {
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol s = symbolTable.getPrimarySymbol(externalAddr);
        if (s == null) {
            Msg.error(DemangledObject.class, (Object)("No such external address " + externalAddr + " for " + symbolName));
        }
        try {
            Namespace ns = DemangledObject.createNamespace(program, demangledNamespace, s.getParentNamespace(), false);
            ExternalLocation extLoc = s.getProgram().getExternalManager().getExternalLocation(s);
            extLoc.setName(ns, symbolName, SourceType.IMPORTED);
        }
        catch (Exception e) {
            Msg.error(DemangledObject.class, (Object)("Unexpected Exception setting name and namespace for " + symbolName + " in " + s.getParentNamespace()), (Throwable)e);
        }
        return s;
    }

    private static List<String> getNamespaceList(Demangled typeNamespace) {
        ArrayList<String> list = new ArrayList<String>();
        for (Demangled ns = typeNamespace; ns != null; ns = ns.getNamespace()) {
            list.add(0, ns.getNamespaceName());
        }
        return list;
    }

    public static Namespace createNamespace(Program program, Demangled typeNamespace, Namespace parentNamespace, boolean functionPermitted) {
        Namespace namespace = parentNamespace;
        if (namespace == null) {
            namespace = program.getGlobalNamespace();
        }
        SymbolTable symbolTable = program.getSymbolTable();
        for (String namespaceName : DemangledObject.getNamespaceList(typeNamespace)) {
            namespaceName = DemangledObject.ensureNameLength(namespaceName);
            try {
                namespace = symbolTable.getOrCreateNameSpace(namespace, namespaceName, SourceType.IMPORTED);
            }
            catch (DuplicateNameException e) {
                Msg.error(DemangledObject.class, (Object)("Failed to create namespace due to name conflict: " + NamespaceUtils.getNamespaceQualifiedName((Namespace)namespace, (String)namespaceName, (boolean)false)));
                break;
            }
            catch (InvalidInputException e) {
                Msg.error(DemangledObject.class, (Object)("Failed to create namespace: " + e.getMessage()));
                break;
            }
            Symbol nsSymbol = namespace.getSymbol();
            if (DemangledObject.isPermittedNamespaceType(nsSymbol.getSymbolType(), functionPermitted)) continue;
            Object allowedTypes = "SymbolType.CLASS, SymbolType.NAMESPACE";
            if (functionPermitted) {
                allowedTypes = (String)allowedTypes + ", SymbolType.FUNCTION";
            }
            Msg.error(DemangledObject.class, (Object)("Bad namespace type - must be one of: " + (String)allowedTypes + NamespaceUtils.getNamespaceQualifiedName((Namespace)namespace, (String)namespaceName, (boolean)false)));
            break;
        }
        return namespace;
    }

    private static boolean isPermittedNamespaceType(SymbolType symbolType, boolean functionPermitted) {
        if (symbolType == SymbolType.CLASS || symbolType == SymbolType.NAMESPACE) {
            return true;
        }
        return functionPermitted && symbolType == SymbolType.FUNCTION;
    }

    protected static String ensureNameLength(String name) {
        int length = name.length();
        if (length <= 2000) {
            return name;
        }
        StringBuilder buffy = new StringBuilder();
        buffy.append(name.substring(0, 1000));
        buffy.append("...");
        buffy.append(name.substring(length - 100));
        return buffy.toString();
    }
}

