/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.headless;

import generic.jar.ResourceFile;
import generic.stl.Pair;
import generic.util.Path;
import ghidra.GhidraApplicationLayout;
import ghidra.GhidraJarApplicationLayout;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.osgi.BundleHost;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.GhidraState;
import ghidra.app.util.headless.HeadlessErrorLogger;
import ghidra.app.util.headless.HeadlessOptions;
import ghidra.app.util.headless.HeadlessScript;
import ghidra.app.util.headless.HeadlessTimedTaskMonitor;
import ghidra.app.util.importer.AutoImporter;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.BinaryLoader;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.HeadlessGhidraApplicationConfiguration;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.data.CheckinHandler;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.TransientDataManager;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.project.DefaultProject;
import ghidra.framework.project.DefaultProjectManager;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.GhidraURLConnection;
import ghidra.framework.protocol.ghidra.GhidraURLWrappedContent;
import ghidra.framework.protocol.ghidra.Handler;
import ghidra.framework.remote.User;
import ghidra.framework.store.LockException;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.program.util.ProgramLocation;
import ghidra.util.ErrorLogger;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.NotOwnerException;
import ghidra.util.UserSearchUtils;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.exception.UserAccessException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import utilities.util.FileUtilities;
import utility.application.ApplicationLayout;

public class HeadlessAnalyzer {
    private static HeadlessAnalyzer instance;
    private HeadlessOptions options = new HeadlessOptions();
    private HeadlessGhidraProjectManager projectManager;
    private Project project;
    private boolean analysisTimedOut;
    private DomainFolder saveDomainFolder;
    private Map<String, Object> storage;
    private URLClassLoader classLoaderForDotClassScripts;

    public static HeadlessAnalyzer getLoggableInstance(File logFile, File scriptLogFile, boolean useLog4j) throws IllegalStateException, IOException {
        if (instance != null) {
            throw new IllegalStateException("A headless analzyer instance has already been retrieved.  Use HeadlessAnalyzer.getInstance() to get it.");
        }
        if (Application.isInitialized()) {
            throw new IllegalStateException("Logging cannot be set because the application has already been initialized.  Use HeadlessAnalyzer.getInstance() to get the headless analyzer.");
        }
        HeadlessGhidraApplicationConfiguration configuration = new HeadlessGhidraApplicationConfiguration();
        if (useLog4j) {
            if (logFile != null) {
                configuration.setApplicationLogFile(logFile);
            }
            if (scriptLogFile != null) {
                configuration.setScriptLogFile(scriptLogFile);
            }
        } else {
            configuration.setInitializeLogging(false);
            Msg.setErrorLogger((ErrorLogger)new HeadlessErrorLogger(logFile));
        }
        Application.initializeApplication((ApplicationLayout)HeadlessAnalyzer.getApplicationLayout(), (ApplicationConfiguration)configuration);
        instance = new HeadlessAnalyzer();
        return instance;
    }

    public static HeadlessAnalyzer getInstance() throws IOException {
        if (instance != null) {
            return instance;
        }
        if (!Application.isInitialized()) {
            HeadlessGhidraApplicationConfiguration configuration = new HeadlessGhidraApplicationConfiguration();
            configuration.setInitializeLogging(false);
            Msg.setErrorLogger((ErrorLogger)new HeadlessErrorLogger(null));
            Application.initializeApplication((ApplicationLayout)HeadlessAnalyzer.getApplicationLayout(), (ApplicationConfiguration)configuration);
        }
        instance = new HeadlessAnalyzer();
        return instance;
    }

    private static GhidraApplicationLayout getApplicationLayout() throws IOException {
        GhidraApplicationLayout layout;
        try {
            layout = new GhidraApplicationLayout();
        }
        catch (IOException e) {
            layout = new GhidraJarApplicationLayout();
        }
        return layout;
    }

    private HeadlessAnalyzer() {
        Handler.registerHandler();
        System.setProperty("java.awt.headless", "true");
        System.setProperty("SystemUtilities.isHeadless", Boolean.TRUE.toString());
        DomainObjectAdapter.setDefaultContentClass(ProgramDB.class);
        this.reset();
    }

    public void reset() {
        this.options.reset();
        this.project = null;
        this.analysisTimedOut = false;
        this.saveDomainFolder = null;
        this.storage = new HashMap<String, Object>();
        this.classLoaderForDotClassScripts = null;
    }

    public HeadlessOptions getOptions() {
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processURL(URL ghidraURL, List<File> filesToImport) throws IOException, MalformedURLException {
        if (this.options.readOnly && this.options.commit) {
            Msg.error((Object)this, (Object)"Abort due to Headless analyzer error: The requested readOnly option is in conflict with the commit option");
            return;
        }
        if (!"ghidra".equals(ghidraURL.getProtocol())) {
            throw new MalformedURLException("Unsupported repository URL: " + ghidraURL);
        }
        if (GhidraURL.isLocalProjectURL((URL)ghidraURL)) {
            Msg.error((Object)this, (Object)"Ghidra URL command form does not supported local project URLs (ghidra:/path...)");
            return;
        }
        String path = ghidraURL.getPath();
        if (path == null) {
            throw new MalformedURLException("Unsupported repository URL: " + ghidraURL);
        }
        if ((path = path.trim()).length() == 0) {
            throw new MalformedURLException("Unsupported repository URL: " + ghidraURL);
        }
        if (!this.options.runScriptsNoImport) {
            if ((filesToImport == null || filesToImport.size() == 0) && this.options.preScripts.isEmpty() && this.options.postScripts.isEmpty()) {
                Msg.warn((Object)this, (Object)"REPORT: Nothing to do ... must specify files for import.");
                return;
            }
            if (!path.endsWith("/")) {
                ghidraURL = new URL("ghidra", ghidraURL.getHost(), ghidraURL.getPort(), path + "/");
            }
        } else if (path.endsWith("/") && path.length() > 1) {
            ghidraURL = new URL("ghidra", ghidraURL.getHost(), ghidraURL.getPort(), path.substring(0, path.length() - 1));
        }
        List<String> parsedScriptPaths = this.parseScriptPaths(this.options.scriptPaths);
        GhidraScriptUtil.initialize(new BundleHost(), parsedScriptPaths);
        try {
            this.showConfiguredScriptPaths();
            this.compileScripts();
            Msg.info(HeadlessAnalyzer.class, (Object)"HEADLESS: execution starts");
            GhidraURLConnection c = (GhidraURLConnection)ghidraURL.openConnection();
            c.setReadOnly(this.options.readOnly);
            if (c.getRepositoryName() == null) {
                throw new MalformedURLException("Unsupported repository URL: " + ghidraURL);
            }
            Msg.info((Object)this, (Object)("Opening ghidra repository project: " + ghidraURL));
            Object obj = c.getContent();
            if (!(obj instanceof GhidraURLWrappedContent)) {
                throw new IOException("Connect to repository folder failed. Response code: " + c.getResponseCode());
            }
            GhidraURLWrappedContent wrappedContent = (GhidraURLWrappedContent)obj;
            Object content = null;
            try {
                content = wrappedContent.getContent((Object)this);
                if (!(content instanceof DomainFolder)) {
                    throw new IOException("Connect to repository folder failed");
                }
                DomainFolder folder = (DomainFolder)content;
                this.project = new HeadlessProject(this.getProjectManager(), c);
                if (!this.checkUpdateOptions()) {
                    return;
                }
                if (this.options.runScriptsNoImport) {
                    this.processNoImport(folder.getPathname());
                } else {
                    this.processWithImport(folder.getPathname(), filesToImport);
                }
            }
            catch (NotFoundException e) {
                throw new IOException("Connect to repository folder failed");
            }
            finally {
                if (content != null) {
                    wrappedContent.release(content, (Object)this);
                }
                if (this.project != null) {
                    this.project.close();
                }
            }
        }
        finally {
            GhidraScriptUtil.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLocal(String projectLocation, String projectName, String rootFolderPath, List<File> filesToImport) throws IOException {
        if (this.options.readOnly && this.options.commit) {
            Msg.error((Object)this, (Object)"Abort due to Headless analyzer error: The requested readOnly option is in conflict with the commit option");
            return;
        }
        if (this.options.runScriptsNoImport) {
            if (((String)rootFolderPath).endsWith("/") && ((String)rootFolderPath).length() > 1) {
                rootFolderPath = ((String)rootFolderPath).substring(0, ((String)rootFolderPath).length() - 1);
            }
        } else {
            if ((filesToImport == null || filesToImport.size() == 0) && this.options.preScripts.isEmpty() && this.options.postScripts.isEmpty()) {
                Msg.warn((Object)this, (Object)"REPORT: Nothing to do ... must specify file(s) for import.");
                return;
            }
            if (!((String)rootFolderPath).endsWith("/")) {
                rootFolderPath = (String)rootFolderPath + "/";
            }
        }
        List<String> parsedScriptPaths = this.parseScriptPaths(this.options.scriptPaths);
        GhidraScriptUtil.initialize(new BundleHost(), parsedScriptPaths);
        try {
            this.showConfiguredScriptPaths();
            this.compileScripts();
            Msg.info(HeadlessAnalyzer.class, (Object)"HEADLESS: execution starts");
            File dir = new File(projectLocation);
            ProjectLocator locator = new ProjectLocator(dir.getAbsolutePath(), projectName);
            if (locator.getProjectDir().exists()) {
                this.project = this.openProject(locator);
            } else {
                if (this.options.runScriptsNoImport) {
                    Msg.error((Object)this, (Object)("Could not find project: " + locator + " -- should already exist in -process mode."));
                    throw new IOException("Could not find project: " + locator);
                }
                if (!this.options.runScriptsNoImport && this.options.readOnly) {
                    this.options.deleteProject = true;
                }
                Msg.info((Object)this, (Object)("Creating " + (this.options.deleteProject ? "temporary " : "") + "project: " + locator));
                this.project = this.getProjectManager().createProject(locator, null, false);
            }
            try {
                if (!this.checkUpdateOptions()) {
                    return;
                }
                if (this.options.runScriptsNoImport) {
                    this.processNoImport((String)rootFolderPath);
                } else {
                    this.processWithImport((String)rootFolderPath, filesToImport);
                }
            }
            finally {
                this.project.close();
                if (!this.options.runScriptsNoImport && this.options.deleteProject) {
                    FileUtilities.deleteDir((File)locator.getProjectDir());
                    locator.getMarkerFile().delete();
                }
            }
        }
        finally {
            GhidraScriptUtil.dispose();
        }
    }

    public boolean checkAnalysisTimedOut() {
        return this.analysisTimedOut;
    }

    void setSaveFolder(DomainFolder domFolder) {
        this.saveDomainFolder = domFolder;
        if (domFolder != null) {
            Msg.info((Object)this, (Object)("Save location changed to: " + domFolder.getPathname()));
        }
    }

    void addVariableToStorage(String nameOfVar, Object valOfVar) {
        if (this.storage.containsKey(nameOfVar)) {
            Msg.warn((Object)this, (Object)("Overwriting existing storage variable: " + nameOfVar));
        }
        this.storage.put(nameOfVar, valOfVar);
    }

    Set<String> getStorageKeys() {
        return this.storage.keySet();
    }

    Object getVariableFromStorage(String nameOfVar) {
        if (!this.storage.containsKey(nameOfVar)) {
            Msg.warn((Object)this, (Object)("The storage variable '" + nameOfVar + "' does not exist in HeadlessAnalyzer storage."));
            return null;
        }
        return this.storage.get(nameOfVar);
    }

    DomainFolder getDomainFolder(String folderPath, boolean create) throws IOException, InvalidNameException {
        DomainFolder domFolder = this.project.getProjectData().getFolder(folderPath);
        if (create && domFolder == null) {
            String cleanPath = folderPath.replaceAll("^/+", "");
            cleanPath = cleanPath.replaceAll("/+$", "");
            String[] subfolders = cleanPath.split("/+");
            int folderIndex = 0;
            String currPath = "/" + subfolders[folderIndex];
            DomainFolder testFolder = this.project.getProjectData().getFolder(currPath);
            DomainFolder baseFolder = null;
            while (testFolder != null && folderIndex < subfolders.length - 1) {
                baseFolder = testFolder;
                testFolder = baseFolder.getFolder(subfolders[++folderIndex]);
            }
            if (folderIndex == 0) {
                baseFolder = this.project.getProjectData().getRootFolder();
            }
            for (int i = folderIndex; i < subfolders.length; ++i) {
                baseFolder = baseFolder.createFolder(subfolders[i]);
                Msg.info((Object)this, (Object)("Created project folder: " + subfolders[i]));
            }
            domFolder = baseFolder;
        }
        return domFolder;
    }

    boolean storageContainsKey(String nameOfVar) {
        return this.storage.containsKey(nameOfVar);
    }

    private boolean runScript(GhidraState scriptState, GhidraScript script) {
        ResourceFile srcFile;
        if (script instanceof HeadlessScript) {
            ((HeadlessScript)script).setHeadlessInstance(this);
        }
        String scriptName = (srcFile = script.getSourceFile()) != null ? srcFile.getAbsolutePath() : script.getClass().getName() + ".class";
        try {
            PrintWriter writer = new PrintWriter(System.out);
            Msg.info((Object)this, (Object)("SCRIPT: " + scriptName));
            script.execute(scriptState, TaskMonitor.DUMMY, writer);
            writer.flush();
        }
        catch (Exception exc) {
            Program prog = scriptState.getCurrentProgram();
            String path = prog != null ? " ( " + prog.getExecutablePath() + " ) " : "";
            String logErrorMsg = "REPORT SCRIPT ERROR: " + path + " " + scriptName + " : " + exc.getMessage();
            Msg.error((Object)this, (Object)logErrorMsg, (Throwable)exc);
            return false;
        }
        return true;
    }

    private boolean checkUpdateOptions() {
        boolean isImport = !this.options.runScriptsNoImport;
        boolean commitAllowed = this.isCommitAllowed();
        if (this.options.readOnly) {
            String readOnlyError = "Abort due to Headless analyzer error: The requested -readOnly option is in conflict with the ";
            if (this.options.commit) {
                Msg.error((Object)this, (Object)(readOnlyError + "-commit option."));
                return false;
            }
            if (this.options.okToDelete) {
                Msg.error((Object)this, (Object)(readOnlyError + "-okToDelete option."));
                return false;
            }
        }
        if (this.options.commit && !commitAllowed) {
            Msg.error((Object)this, (Object)"Commit to repository not possible (due to permission or connection issue)");
            return false;
        }
        if (this.project.getProjectLocator().isTransient() && !this.options.commit && commitAllowed && !this.options.readOnly) {
            Msg.info((Object)this, (Object)"When processing a URL, -commit is automatically enabled unless -readOnly mode is specified.  Enabling -commit and continuing.");
            this.options.commit = true;
        }
        if (this.options.overwrite) {
            if (!isImport) {
                Msg.info((Object)this, (Object)"Ignoring -overwrite because it is not applicable to -process mode.");
            } else if (this.options.readOnly) {
                Msg.info((Object)this, (Object)"Ignoring -overwrite because it is not applicable to -readOnly import mode.");
                this.options.overwrite = false;
            }
        }
        return true;
    }

    private boolean isCommitAllowed() {
        RepositoryAdapter repository = this.project.getRepository();
        if (repository == null) {
            return true;
        }
        try {
            repository.connect();
            if (!repository.isConnected()) {
                return false;
            }
            User user = repository.getUser();
            if (!user.hasWritePermission()) {
                Msg.warn((Object)this, (Object)("User '" + user.getName() + "' does not have write permission to repository - commit not allowed"));
                return false;
            }
            return true;
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Repository connection failed (" + repository.getServerInfo() + ") - commit not allowed"));
            return false;
        }
    }

    private List<String> parseScriptPaths(List<String> scriptPaths) {
        if (scriptPaths == null) {
            return null;
        }
        ArrayList<String> parsedScriptPaths = new ArrayList<String>();
        for (String path : scriptPaths) {
            ResourceFile pathFile = Path.fromPathString((String)path);
            String absPath = pathFile.getAbsolutePath();
            if (pathFile.exists()) {
                parsedScriptPaths.add(absPath);
                continue;
            }
            Msg.warn((Object)this, (Object)("REPORT: Could not find -scriptPath entry, skipping: " + absPath));
        }
        return parsedScriptPaths;
    }

    private void showConfiguredScriptPaths() {
        StringBuffer buf = new StringBuffer("HEADLESS Script Paths:");
        for (ResourceFile dir : GhidraScriptUtil.getScriptSourceDirectories()) {
            buf.append("\n    ");
            buf.append(dir.getAbsolutePath());
        }
        Msg.info(HeadlessAnalyzer.class, (Object)buf.toString());
    }

    private ResourceFile findScript(String scriptName) {
        ResourceFile scriptSource = new ResourceFile(scriptName);
        if ((scriptSource = scriptSource.getCanonicalFile()).exists()) {
            return scriptSource;
        }
        scriptSource = GhidraScriptUtil.findScriptByName(scriptName);
        if (scriptSource != null) {
            return scriptSource;
        }
        throw new IllegalArgumentException("Script not found: " + scriptName);
    }

    private ResourceFile checkScript(String scriptName) {
        String classExtension = ".class";
        if (scriptName.endsWith(classExtension)) {
            String className = scriptName.substring(0, scriptName.length() - classExtension.length());
            try {
                List<ResourceFile> dirs = GhidraScriptUtil.getScriptSourceDirectories();
                ArrayList<URL> urls = new ArrayList<URL>();
                for (ResourceFile dir : dirs) {
                    try {
                        urls.add(dir.toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                this.classLoaderForDotClassScripts = URLClassLoader.newInstance(urls.toArray(new URL[0]));
                Class<?> c = Class.forName(className, true, this.classLoaderForDotClassScripts);
                if (GhidraScript.class.isAssignableFrom(c)) {
                    return null;
                }
                Msg.error((Object)this, (Object)("REPORT SCRIPT ERROR: java class '" + className + "' is not a GhidraScript"));
            }
            catch (ClassNotFoundException e) {
                Msg.error((Object)this, (Object)("REPORT SCRIPT ERROR: java class not found for '" + className + "'"));
            }
            throw new IllegalArgumentException("Invalid script: " + scriptName);
        }
        try {
            ResourceFile scriptSource = this.findScript(scriptName);
            GhidraScriptProvider provider = GhidraScriptUtil.getProvider(scriptSource);
            if (provider == null) {
                throw new IOException("Missing plugin needed to run scripts of this type. Please ensure you have installed the necessary plugin.");
            }
            return scriptSource;
        }
        catch (Exception | NoClassDefFoundError exc) {
            String logErrorMsg = "REPORT SCRIPT ERROR: " + scriptName + " : " + exc.getMessage();
            Msg.error((Object)this, (Object)logErrorMsg);
            throw new IllegalArgumentException("Invalid script: " + scriptName);
        }
    }

    private Map<String, ResourceFile> checkScriptsList(List<Pair<String, String[]>> scriptsList) {
        HashMap<String, ResourceFile> map = new HashMap<String, ResourceFile>();
        for (Pair<String, String[]> scriptPair : scriptsList) {
            String scriptName = (String)scriptPair.first;
            ResourceFile scriptFile = this.checkScript(scriptName);
            map.put(scriptName, scriptFile);
        }
        return map;
    }

    private void compileScripts() throws IOException {
        if (this.options.propertiesFileStrPaths.size() > 0) {
            this.options.propertiesFilePaths.clear();
            for (String path : this.options.propertiesFileStrPaths) {
                Path currPath = new Path(path, true, false, true);
                ResourceFile resource = currPath.getPath();
                if (!resource.isDirectory()) {
                    throw new IOException("Properties file path: '" + path + "' either does not exist, or is not a valid directory.");
                }
                if (!currPath.isEnabled() || this.options.propertiesFilePaths.contains(resource)) continue;
                this.options.propertiesFilePaths.add(resource);
            }
        }
        if (this.options.preScriptFileMap == null) {
            this.options.preScriptFileMap = this.checkScriptsList(this.options.preScripts);
        }
        if (this.options.postScriptFileMap == null) {
            this.options.postScriptFileMap = this.checkScriptsList(this.options.postScripts);
        }
    }

    private HeadlessScript.HeadlessContinuationOption runScriptsList(List<Pair<String, String[]>> scriptsList, Map<String, ResourceFile> scriptFileMap, GhidraState scriptState, HeadlessScript.HeadlessContinuationOption continueOption) {
        HeadlessScript.HeadlessContinuationOption retOption = continueOption;
        boolean isHeadlessScript = false;
        String scriptName = "";
        try {
            for (Pair<String, String[]> scriptPair : scriptsList) {
                GhidraScript currScript;
                scriptName = (String)scriptPair.first;
                String[] scriptArgs = (String[])scriptPair.second;
                if (scriptName.endsWith(".class")) {
                    if (this.classLoaderForDotClassScripts == null) {
                        throw new IllegalArgumentException("Invalid script: " + scriptName);
                    }
                    String className = scriptName.substring(0, scriptName.length() - 6);
                    Class<?> c = Class.forName(className, true, this.classLoaderForDotClassScripts);
                    File parentFile = new File(c.getResource(c.getSimpleName() + ".class").toURI()).getParentFile();
                    currScript = (GhidraScript)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                    currScript.setScriptArgs(scriptArgs);
                    if (this.options.propertiesFilePaths.size() > 0) {
                        currScript.setPotentialPropertiesFileLocations(this.options.propertiesFilePaths);
                    }
                    currScript.setPropertiesFileLocation(parentFile.getAbsolutePath(), className);
                } else {
                    ResourceFile currScriptFile = scriptFileMap.get(scriptName);
                    GhidraScriptProvider provider = GhidraScriptUtil.getProvider(currScriptFile);
                    PrintWriter writer = new PrintWriter(System.out);
                    currScript = provider.getScriptInstance(currScriptFile, writer);
                    currScript.setScriptArgs(scriptArgs);
                    if (this.options.propertiesFilePaths.size() > 0) {
                        currScript.setPotentialPropertiesFileLocations(this.options.propertiesFilePaths);
                    }
                }
                boolean bl = isHeadlessScript = currScript instanceof HeadlessScript;
                if (isHeadlessScript) {
                    ((HeadlessScript)currScript).setInitialContinuationOption(retOption);
                }
                boolean scriptSuccess = this.runScript(scriptState, currScript);
                if (!isHeadlessScript) continue;
                if (scriptSuccess) {
                    retOption = ((HeadlessScript)currScript).getContinuationOption();
                    if (retOption != HeadlessScript.HeadlessContinuationOption.ABORT && retOption != HeadlessScript.HeadlessContinuationOption.ABORT_AND_DELETE) continue;
                    return retOption;
                }
                Msg.warn((Object)this, (Object)"Script does not exist or encountered problems; further processing is aborted.");
                return HeadlessScript.HeadlessContinuationOption.ABORT;
            }
        }
        catch (Exception exc) {
            String logErrorMsg = "REPORT SCRIPT ERROR: " + scriptName + " : " + exc.getMessage();
            Msg.error((Object)this, (Object)logErrorMsg, (Throwable)exc);
        }
        return retOption;
    }

    private GhidraState getInitialProgramState(Program program) {
        ProgramLocation location = null;
        AddressSetView initializedMem = program.getMemory().getLoadedAndInitializedAddressSet();
        if (!initializedMem.isEmpty()) {
            location = new ProgramLocation(program, initializedMem.getMinAddress());
        }
        return new GhidraState(null, this.project, program, location, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean analyzeProgram(String fileAbsolutePath, Program program) {
        this.analysisTimedOut = false;
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
        mgr.initializeOptions();
        GhidraState scriptState = null;
        HeadlessScript.HeadlessContinuationOption scriptStatus = HeadlessScript.HeadlessContinuationOption.CONTINUE;
        boolean abortProcessing = false;
        boolean deleteProgram = false;
        if (!this.options.preScripts.isEmpty()) {
            scriptState = this.getInitialProgramState(program);
            scriptStatus = this.runScriptsList(this.options.preScripts, this.options.preScriptFileMap, scriptState, scriptStatus);
        }
        switch (scriptStatus) {
            case ABORT_AND_DELETE: {
                abortProcessing = true;
                deleteProgram = true;
                break;
            }
            case CONTINUE_THEN_DELETE: {
                abortProcessing = false;
                deleteProgram = true;
                break;
            }
            case ABORT: {
                abortProcessing = true;
                deleteProgram = false;
                break;
            }
        }
        if (abortProcessing) {
            Msg.info((Object)this, (Object)"Processing aborted as a result of pre-script.");
            return !deleteProgram;
        }
        int txId = program.startTransaction("Analysis");
        try {
            if (this.options.analyze) {
                Msg.info((Object)this, (Object)("ANALYZING all memory and code: " + fileAbsolutePath));
                mgr.initializeOptions();
                mgr.reAnalyzeAll(null);
                if (this.options.perFileTimeout == -1) {
                    mgr.startAnalysis(TaskMonitor.DUMMY);
                    Msg.info((Object)this, (Object)("REPORT: Analysis succeeded for file: " + fileAbsolutePath));
                    GhidraProgramUtilities.setAnalyzedFlag(program, true);
                } else {
                    HeadlessTimedTaskMonitor timerMonitor = new HeadlessTimedTaskMonitor(this.options.perFileTimeout);
                    mgr.startAnalysis(timerMonitor);
                    if (timerMonitor.isCancelled()) {
                        Msg.error((Object)this, (Object)("REPORT: Analysis timed out at " + this.options.perFileTimeout + " seconds. Processing not completed for file: " + fileAbsolutePath));
                        if (this.options.postScripts.isEmpty()) {
                            boolean bl = !deleteProgram;
                            return bl;
                        }
                        this.analysisTimedOut = true;
                    } else {
                        timerMonitor.cancel();
                        Msg.info((Object)this, (Object)("REPORT: Analysis succeeded for file: " + fileAbsolutePath));
                        GhidraProgramUtilities.setAnalyzedFlag(program, true);
                    }
                }
            }
        }
        finally {
            program.endTransaction(txId, true);
        }
        if (!this.options.postScripts.isEmpty()) {
            if (scriptState == null) {
                scriptState = this.getInitialProgramState(program);
            }
            scriptStatus = this.runScriptsList(this.options.postScripts, this.options.postScriptFileMap, scriptState, scriptStatus);
            switch (scriptStatus) {
                case ABORT_AND_DELETE: {
                    abortProcessing = true;
                    deleteProgram = true;
                    break;
                }
                case CONTINUE_THEN_DELETE: {
                    abortProcessing = false;
                    deleteProgram = true;
                    break;
                }
                case ABORT: {
                    abortProcessing = true;
                    break;
                }
            }
            if (abortProcessing) {
                Msg.info((Object)this, (Object)"Processing aborted as a result of post-script.");
            } else if (this.options.analyze && !this.options.postScripts.isEmpty()) {
                Msg.info((Object)this, (Object)("ANALYZING changes made by post scripts: " + fileAbsolutePath));
                txId = program.startTransaction("Post-Analysis");
                try {
                    mgr.startAnalysis(TaskMonitor.DUMMY);
                }
                finally {
                    program.endTransaction(txId, true);
                }
                Msg.info((Object)this, (Object)("REPORT: Post-analysis succeeded for file: " + fileAbsolutePath));
            }
        }
        return !deleteProgram;
    }

    /*
     * Exception decompiling
     */
    private void processFileNoImport(DomainFile domFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deleteDomainFile(DomainFile domFile) {
        if (domFile.isCheckedOut()) {
            Msg.error((Object)this, (Object)("Failed to delete file as requested due to pre-existing checkout: " + domFile.getPathname()));
            return;
        }
        try {
            domFile.delete();
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Failed to delete file as requested - " + e.getMessage() + ": " + domFile.getPathname()));
        }
    }

    private boolean processFolderNoImport(DomainFolder parentFolder, Pattern filenamePattern) throws IOException {
        if (parentFolder.isEmpty()) {
            return false;
        }
        boolean filesProcessed = false;
        for (DomainFile domainFile : parentFolder.getFiles()) {
            if (filenamePattern != null && !filenamePattern.matcher(domainFile.getName()).matches() || !"Program".equals(domainFile.getContentType())) continue;
            filesProcessed = true;
            this.processFileNoImport(domainFile);
        }
        if (this.options.recursive) {
            for (DomainFile domainFile : parentFolder.getFolders()) {
                filesProcessed |= this.processFolderNoImport((DomainFolder)domainFile, filenamePattern);
            }
        }
        return filesProcessed;
    }

    private boolean processFolderNoImport(DomainFolder parentFolder, String filename) throws IOException {
        if (parentFolder.isEmpty()) {
            return false;
        }
        boolean filesProcessed = false;
        DomainFile domFile = parentFolder.getFile(filename);
        if ("Program".equals(domFile.getContentType())) {
            filesProcessed = true;
            this.processFileNoImport(domFile);
        }
        if (this.options.recursive) {
            for (DomainFolder folder : parentFolder.getFolders()) {
                filesProcessed |= this.processFolderNoImport(folder, filename);
            }
        }
        return filesProcessed;
    }

    private void processNoImport(String rootFolderPath) throws IOException {
        this.storage.clear();
        DomainFolder domFolder = this.project.getProjectData().getFolder(rootFolderPath);
        if (domFolder == null) {
            throw new IOException("Specified project folder not found: " + rootFolderPath);
        }
        Pattern filenamePattern = null;
        if (this.options.domainFileNameToProcess != null) {
            filenamePattern = this.createFilenamePattern(this.options.domainFileNameToProcess);
        }
        boolean filesProcessed = false;
        filesProcessed = filenamePattern == null && this.options.domainFileNameToProcess != null ? this.processFolderNoImport(domFolder, this.options.domainFileNameToProcess) : this.processFolderNoImport(domFolder, filenamePattern);
        if (!filesProcessed) {
            if (this.options.domainFileNameToProcess != null) {
                throw new IOException("Requested project program file(s) not found: " + this.options.domainFileNameToProcess);
            }
            throw new IOException("No program files found within specified project folder: " + domFolder.getPathname());
        }
    }

    private Pattern createFilenamePattern(String name) {
        if (name.indexOf(42) == -1 && name.indexOf(63) == -1) {
            return null;
        }
        if (name.startsWith("'") && name.endsWith("'")) {
            name = name.substring(1, name.length() - 1);
        }
        Pattern p = UserSearchUtils.createSearchPattern((String)name, (boolean)true);
        return p;
    }

    private boolean checkOverwrite(DomainFile df) throws IOException {
        block9: {
            if (this.options.overwrite) {
                try {
                    if (df.isHijacked()) {
                        Msg.error((Object)this, (Object)("REPORT: Found conflicting program file in project which is hijacked - overwrite denied: " + df.getPathname()));
                        return false;
                    }
                    if (df.isVersioned()) {
                        if (!this.options.commit) {
                            Msg.error((Object)this, (Object)("REPORT: Found conflicting versioned program file in project with changes - overwrite denied when commit disabled: " + df.getPathname()));
                            return false;
                        }
                        if (df.isCheckedOut()) {
                            df.undoCheckout(false);
                        }
                    }
                    try {
                        df.delete();
                        break block9;
                    }
                    catch (IOException e) {
                        Msg.error((Object)this, (Object)("REPORT: Failed to remove conflicting program file (" + e.getMessage() + "): " + df.getPathname()));
                        return false;
                    }
                }
                catch (UserAccessException e) {
                    Msg.error((Object)this, (Object)("REPORT: Found conflicting program file in project which user is unable to overwrite: " + df.getPathname()));
                    return false;
                }
            }
            Msg.error((Object)this, (Object)("REPORT: Found conflicting program file in project: " + df.getPathname()));
            return false;
        }
        Msg.warn((Object)this, (Object)("REPORT: Removed conflicting program file from project: " + df.getPathname()));
        return true;
    }

    private void commitProgram(DomainFile df) throws IOException {
        RepositoryAdapter rep = this.project.getRepository();
        if (rep != null) {
            try {
                rep.connect();
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)rep, (Exception)e, (String)"Connect", null);
            }
            if (!rep.isConnected()) {
                Msg.error((Object)this, (Object)(df.getPathname() + ": File check-in failed - repository connection error"));
                throw new IOException(df.getPathname() + ": File check-in failed - repository connection error");
            }
        }
        if (df.canAddToRepository()) {
            try {
                df.addToVersionControl(this.options.commitComment, false, TaskMonitor.DUMMY);
                Msg.info((Object)this, (Object)("REPORT: Added file to repository: " + df.getPathname()));
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)(df.getPathname() + ": File check-in failed - " + e.getMessage()));
                throw e;
            }
            catch (CancelledException e) {}
        } else if (df.canCheckin()) {
            try {
                df.checkin(new CheckinHandler(){

                    public boolean keepCheckedOut() throws CancelledException {
                        return true;
                    }

                    public String getComment() throws CancelledException {
                        return HeadlessAnalyzer.this.options.commitComment;
                    }

                    public boolean createKeepFile() throws CancelledException {
                        return false;
                    }
                }, true, TaskMonitor.DUMMY);
                Msg.info((Object)this, (Object)("REPORT: Committed file changes to repository: " + df.getPathname()));
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)(df.getPathname() + ": File check-in failed - " + e.getMessage()));
                throw e;
            }
            catch (VersionException e) {
                Msg.error((Object)this, (Object)(df.getPathname() + ": File check-in failed - version error occurred"));
            }
            catch (CancelledException cancelledException) {}
        } else {
            Msg.error((Object)this, (Object)(df.getPathname() + ": Unable to commit file"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processFileWithImport(File file, String folderPath) {
        Msg.info((Object)this, (Object)("IMPORTING: " + file.getAbsolutePath()));
        program = null;
        dfName = null;
        df = null;
        domainFolder = null;
        try {
            domainFolder = this.getDomainFolder(folderPath, false);
            dfName = file.getName();
            if (dfName.toLowerCase().endsWith(".gzf") || dfName.toLowerCase().endsWith(".xml")) {
                index = dfName.lastIndexOf(46);
                dfName = dfName.substring(0, (int)index);
            }
            if (this.options.readOnly) ** GOTO lbl31
            if (domainFolder != null) {
                df = domainFolder.getFile(dfName);
            }
            if (df != null && !this.checkOverwrite(df)) {
                index = false;
                return index;
            }
            df = null;
        }
        catch (Exception exc) {
            Msg.error((Object)this, (Object)("REPORT: " + exc.getMessage()), (Throwable)exc);
            exc.printStackTrace();
            var8_9 = false;
            return var8_9;
        }
        finally {
            if (program != null) {
                program.release((Object)this);
                program = null;
            }
        }
lbl31:
        // 2 sources

        if ((program = this.loadProgram(file)) == null) {
            index = false;
            return index;
        }
        if (program.getMemory().getAllInitializedAddressSet().isEmpty()) {
            Msg.error((Object)this, (Object)("REPORT: Error: No memory blocks were defined for file '" + file.getAbsolutePath() + "'."));
            index = false;
            return index;
        }
        Msg.info((Object)this, (Object)("REPORT: Import succeeded with language \"" + program.getLanguageID().getIdAsString() + "\" and cspec \"" + program.getCompilerSpec().getCompilerSpecID().getIdAsString() + "\" for file: " + file.getAbsolutePath()));
        try {
            v0 = doSave = this.analyzeProgram(file.getAbsolutePath(), program) != false && this.options.readOnly == false;
            if (!doSave) {
                program.setTemporary(true);
            }
            if (program.isTemporary()) {
                if (this.options.readOnly) {
                    Msg.info((Object)this, (Object)("REPORT: Discarded file import due to readOnly option: " + file.getAbsolutePath()));
                } else {
                    Msg.info((Object)this, (Object)("REPORT: Discarded file import as a result of script activity or analysis timeout: " + file.getAbsolutePath()));
                }
                var8_10 = true;
                return var8_10;
            }
            if (this.saveDomainFolder == null) ** GOTO lbl58
            df = this.saveDomainFolder.getFile(dfName);
            if (df != null && !this.checkOverwrite(df)) {
                var8_11 = false;
                return var8_11;
            }
            try {
                block36: {
                    domainFolder = this.saveDomainFolder;
                    break block36;
lbl58:
                    // 1 sources

                    if (domainFolder == null) {
                        domainFolder = this.getDomainFolder(folderPath, true);
                    }
                }
                df = domainFolder.createFile(dfName, (DomainObject)program, TaskMonitor.DUMMY);
                Msg.info((Object)this, (Object)("REPORT: Save succeeded for file: " + df.getPathname()));
                if (this.options.commit) {
                    AutoAnalysisManager.getAnalysisManager(program).dispose();
                    program.release((Object)this);
                    program = null;
                    this.commitProgram(df);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IOException("Cannot create file: " + domainFolder.getPathname() + "/" + dfName, e);
            }
        }
        catch (Exception exc) {
            logErrorMsg = file.getAbsolutePath() + " Error during analysis: " + exc.getMessage();
            Msg.info((Object)this, (Object)logErrorMsg);
            var10_16 = false;
            if (program == null) return var10_16;
            program.release((Object)this);
            program = null;
            return var10_16;
        }
        finally {
            if (program != null) {
                AutoAnalysisManager.getAnalysisManager(program).dispose();
            }
        }
        var8_14 = true;
        return var8_14;
    }

    private Program loadProgram(File file) throws VersionException, InvalidNameException, DuplicateNameException, CancelledException, IOException {
        MessageLog messageLog = new MessageLog();
        Program program = null;
        program = this.options.loaderClass == null ? (this.options.language == null ? AutoImporter.importByUsingBestGuess(file, null, (Object)this, messageLog, TaskMonitor.DUMMY) : AutoImporter.importByLookingForLcs(file, null, this.options.language, this.options.compilerSpec, this, messageLog, TaskMonitor.DUMMY)) : (this.options.language == null ? AutoImporter.importByUsingSpecificLoaderClass(file, null, this.options.loaderClass, this.options.loaderArgs, this, messageLog, TaskMonitor.DUMMY) : AutoImporter.importByUsingSpecificLoaderClassAndLcs(file, null, this.options.loaderClass, this.options.loaderArgs, this.options.language, this.options.compilerSpec, this, messageLog, TaskMonitor.DUMMY));
        if (program == null) {
            Msg.error((Object)this, (Object)("The AutoImporter could not successfully load " + file.getAbsolutePath() + " with the provided import parameters. Please ensure that any specified processor/cspec arguments are compatible with the loader that is used during import and try again."));
            if (this.options.loaderClass != null && this.options.loaderClass != BinaryLoader.class) {
                Msg.error((Object)this, (Object)("NOTE: Import failure may be due to missing opinion for \"" + this.options.loaderClass.getSimpleName() + "\". If so, please contact Ghidra team for assistance."));
            }
            return null;
        }
        return program;
    }

    private void processWithImport(File file, String folderPath, boolean isFirstTime) throws IOException {
        if (file.isFile()) {
            boolean importSucceeded = this.processFileWithImport(file, (String)folderPath);
            ArrayList domainFileContainer = new ArrayList();
            TransientDataManager.getTransients(domainFileContainer);
            if (domainFileContainer.size() > 0) {
                TransientDataManager.releaseFiles((Object)this);
            }
            if (!importSucceeded) {
                Msg.error((Object)this, (Object)("REPORT: Import failed for file: " + file.getAbsolutePath()));
            }
            return;
        }
        if (isFirstTime || !isFirstTime && this.options.recursive) {
            Msg.info((Object)this, (Object)("REPORT: Importing all files from " + file.getName()));
            File dirFile = file;
            if (!((String)folderPath).endsWith("/")) {
                folderPath = (String)folderPath + "/";
            }
            String subfolderPath = (String)folderPath + file.getName();
            String[] names = dirFile.list();
            if (names != null) {
                Collections.sort(Arrays.asList(names));
                for (String name : names) {
                    if (name.charAt(0) == '.') {
                        Msg.warn((Object)this, (Object)("Ignoring file '" + name + "'."));
                        continue;
                    }
                    file = new File(dirFile, name);
                    try {
                        HeadlessAnalyzer.checkValidFilename(file);
                        this.processWithImport(file, subfolderPath, false);
                    }
                    catch (InvalidInputException invalidInputException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void processWithImport(String folderPath, List<File> inputDirFiles) throws IOException {
        this.storage.clear();
        if (inputDirFiles != null && !inputDirFiles.isEmpty()) {
            Msg.info((Object)this, (Object)"REPORT: Processing input files: ");
            Msg.info((Object)this, (Object)("     project: " + this.project.getProjectLocator()));
            for (File f : inputDirFiles) {
                this.processWithImport(f, folderPath, true);
            }
        } else {
            GhidraState scriptState = new GhidraState(null, this.project, null, null, null, null);
            HeadlessScript.HeadlessContinuationOption scriptStatus = HeadlessScript.HeadlessContinuationOption.CONTINUE;
            scriptStatus = this.runScriptsList(this.options.preScripts, this.options.preScriptFileMap, scriptState, scriptStatus);
            switch (scriptStatus) {
                case ABORT_AND_DELETE: 
                case ABORT: {
                    return;
                }
            }
            this.runScriptsList(this.options.postScripts, this.options.postScriptFileMap, scriptState, scriptStatus);
        }
    }

    private Project openProject(ProjectLocator locator) throws IOException {
        HeadlessProject tempProject;
        if (this.options.deleteProject) {
            Msg.warn((Object)this, (Object)("Project already exists and will not be deleted: " + locator));
            this.options.deleteProject = false;
        }
        Msg.info((Object)this, (Object)("Opening existing project: " + locator));
        try {
            tempProject = new HeadlessProject(this.getProjectManager(), locator);
        }
        catch (NotOwnerException e) {
            throw new IOException(e);
        }
        catch (LockException e) {
            throw new IOException(e);
        }
        return tempProject;
    }

    static void checkValidFilename(File currFile) throws InvalidInputException {
        boolean isDir = currFile.isDirectory();
        String filename = currFile.getName();
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (LocalFileSystem.isValidNameCharacter((char)c)) continue;
            if (isDir) {
                throw new InvalidInputException("The directory '" + filename + "' contains the invalid characgter: '" + c + "' and can not be created in the project (full path: " + currFile.getAbsolutePath() + "). To allow successful import of the directory and its contents, please rename the directory.");
            }
            throw new InvalidInputException("The file '" + filename + "' contains the invalid character: '" + c + "' and can not be imported (full path: " + currFile.getAbsolutePath() + "). Please rename the file.");
        }
    }

    private HeadlessGhidraProjectManager getProjectManager() {
        if (this.projectManager == null) {
            this.projectManager = new HeadlessGhidraProjectManager();
        }
        return this.projectManager;
    }

    private static class HeadlessGhidraProjectManager
    extends DefaultProjectManager {
        private HeadlessGhidraProjectManager() {
        }
    }

    private static class HeadlessProject
    extends DefaultProject {
        HeadlessProject(HeadlessGhidraProjectManager projectManager, GhidraURLConnection connection) throws IOException {
            super((DefaultProjectManager)projectManager, connection);
        }

        HeadlessProject(HeadlessGhidraProjectManager projectManager, ProjectLocator projectLocator) throws NotOwnerException, LockException, IOException {
            super((DefaultProjectManager)projectManager, projectLocator, false);
        }
    }
}

