/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.util.HTMLUtilities;
import ghidra.util.StringUtilities;
import ghidra.util.exception.AssertException;
import org.apache.commons.lang3.StringUtils;

public class PointerDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    private String truncatedHtmlData;

    public PointerDataTypeHTMLRepresentation(Pointer pointer) {
        super(PointerDataTypeHTMLRepresentation.buildHTMLText(pointer, false));
        this.truncatedHtmlData = PointerDataTypeHTMLRepresentation.buildHTMLText(pointer, true);
    }

    @Override
    public String getHTMLString() {
        return "<HTML>" + this.truncatedHtmlData + "</HTML>";
    }

    @Override
    public String getHTMLContentString() {
        return this.truncatedHtmlData;
    }

    private static String buildHTMLText(Pointer pointer, boolean trim) {
        Pointer baseDataType = pointer;
        while (baseDataType instanceof Pointer) {
            baseDataType = baseDataType.getDataType();
        }
        if (baseDataType == null) {
            return PointerDataTypeHTMLRepresentation.getDefaultDescription(pointer);
        }
        StringBuilder buffer = new StringBuilder();
        int length = pointer.getLength();
        String bits = length * 8 + " bit ";
        String baseName = baseDataType.getName();
        if (trim) {
            baseName = StringUtilities.trimMiddle((String)baseName, (int)80);
        }
        Object fullDescription = bits + " Pointer";
        fullDescription = HTMLUtilities.friendlyEncodeHTML((String)fullDescription);
        buffer.append("&#47;").append("&#47;").append("&nbsp;");
        buffer.append(HTMLUtilities.friendlyEncodeHTML((String)pointer.getName()));
        buffer.append("<BR>");
        buffer.append((String)fullDescription);
        buffer.append("<BR>");
        buffer.append("Size: ").append(length >= 0 ? Integer.valueOf(length) : "default");
        buffer.append("<BR>").append("<BR>");
        buffer.append("Pointer Base Data Type: ").append("<BR>");
        if (baseDataType instanceof BuiltInDataType) {
            String simpleName = baseDataType.getClass().getSimpleName();
            buffer.append("<DIV STYLE='margin-left: 10px;'>");
            buffer.append(simpleName);
            PointerDataTypeHTMLRepresentation.addDataTypeLength((DataType)baseDataType, buffer);
            buffer.append("</DIV>");
        } else {
            buffer.append("<DIV STYLE='margin-left: 10px;'>");
            HTMLDataTypeRepresentation representation = ToolTipUtils.getHTMLRepresentation((DataType)baseDataType);
            String baseHTML = representation.getFullHTMLContentString();
            if (trim) {
                baseHTML = representation.getHTMLContentString();
            }
            buffer.append(baseHTML);
            if (baseHTML.indexOf("Length: ") < 0) {
                PointerDataTypeHTMLRepresentation.addDataTypeLength((DataType)baseDataType, buffer);
            }
            buffer.append("</DIV>");
        }
        return buffer.toString();
    }

    private static String getDefaultDescription(Pointer pointer) {
        char firstChar;
        Object description = pointer.getDescription();
        if (StringUtils.isBlank((CharSequence)description)) {
            description = pointer.getDisplayName();
        }
        if (!Character.isUpperCase(firstChar = ((String)description).charAt(0))) {
            description = Character.toUpperCase(firstChar) + ((String)description).substring(1);
        }
        return description;
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        throw new AssertException("Pointer types are not diffable at this time");
    }
}

