/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.multilisting;

import docking.widgets.fieldpanel.Layout;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingModelListener;
import ghidra.app.util.viewer.multilisting.AddressTranslator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.util.task.TaskMonitor;

public class ListingModelConverter
implements ListingModel {
    private ListingModel primaryModel;
    private ListingModel model;
    private Program primaryProgram;
    private Program program;
    private AddressTranslator translator;

    public ListingModelConverter(ListingModel primaryModel, ListingModel model) {
        this.primaryModel = primaryModel;
        this.model = model;
        this.primaryProgram = primaryModel.getProgram();
        this.program = model.getProgram();
    }

    @Override
    public void addListener(ListingModelListener listener) {
        this.model.addListener(listener);
    }

    @Override
    public void dispose() {
        this.model.dispose();
    }

    @Override
    public Address getAddressAfter(Address primaryModelAddress) {
        Address retAddr;
        Address addr = this.getConvertedAddress(primaryModelAddress);
        Address address = retAddr = addr != null ? this.model.getAddressAfter(addr) : null;
        if (retAddr == null) {
            Address addressBefore = this.primaryModel.getAddressAfter(primaryModelAddress);
            retAddr = SimpleDiffUtility.getCompatibleAddress((Program)this.primaryProgram, (Address)addressBefore, (Program)this.program);
        }
        return retAddr;
    }

    @Override
    public Address getAddressBefore(Address primaryModelAddress) {
        Address retAddr;
        Address addr = this.getConvertedAddress(primaryModelAddress);
        Address address = retAddr = addr != null ? this.model.getAddressBefore(addr) : null;
        if (retAddr == null) {
            Address addressBefore = this.primaryModel.getAddressBefore(primaryModelAddress);
            retAddr = SimpleDiffUtility.getCompatibleAddress((Program)this.primaryProgram, (Address)addressBefore, (Program)this.program);
        }
        return retAddr;
    }

    @Override
    public AddressSetView getAddressSet() {
        AddressSetView addressSet = this.primaryModel.getAddressSet();
        return DiffUtility.getCompatibleAddressSet(addressSet, this.program);
    }

    @Override
    public Layout getLayout(Address primaryAddress, boolean isGapAddress) {
        Address addr = this.getConvertedAddress(primaryAddress);
        if (addr == null) {
            return null;
        }
        return this.model.getLayout(addr, isGapAddress);
    }

    private Address getConvertedAddress(Address primaryAddress) {
        return this.translator != null ? this.translator.translate(primaryAddress, this.primaryProgram, this.program) : SimpleDiffUtility.getCompatibleAddress((Program)this.primaryProgram, (Address)primaryAddress, (Program)this.program);
    }

    @Override
    public int getMaxWidth() {
        return this.model.getMaxWidth();
    }

    @Override
    public Program getProgram() {
        return this.model.getProgram();
    }

    @Override
    public boolean isClosed() {
        return this.model.isClosed();
    }

    @Override
    public boolean isOpen(Data data) {
        return this.model.isOpen(data);
    }

    @Override
    public boolean openData(Data data) {
        return this.model.openData(data);
    }

    @Override
    public void openAllData(Data data, TaskMonitor monitor) {
        this.model.openAllData(data, null);
    }

    @Override
    public void openAllData(AddressSetView addresses, TaskMonitor monitor) {
        this.model.openAllData(addresses, monitor);
    }

    @Override
    public void closeData(Data data) {
        this.model.closeData(data);
    }

    @Override
    public void closeAllData(Data data, TaskMonitor monitor) {
        this.model.closeAllData(data, null);
    }

    @Override
    public void closeAllData(AddressSetView addresses, TaskMonitor monitor) {
        this.model.closeAllData(addresses, monitor);
    }

    @Override
    public void removeListener(ListingModelListener listener) {
        this.model.removeListener(listener);
    }

    @Override
    public void setFormatManager(FormatManager formatManager) {
        this.model.setFormatManager(formatManager);
    }

    @Override
    public void toggleOpen(Data data) {
        this.model.toggleOpen(data);
    }

    @Override
    public AddressSet adjustAddressSetToCodeUnitBoundaries(AddressSet addressSet) {
        AddressSet compatibleAddressSet = DiffUtility.getCompatibleAddressSet((AddressSetView)addressSet, this.program);
        return this.model.adjustAddressSetToCodeUnitBoundaries(compatibleAddressSet);
    }

    public void setAddressTranslator(AddressTranslator translator) {
        this.translator = translator;
    }

    @Override
    public ListingModel copy() {
        return new ListingModelConverter(this.primaryModel.copy(), this.model.copy());
    }
}

