/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.action.MenuData;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.DomainFileArchive;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.editor.DataTypeEditorManager;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.SaveDataDialog;
import ghidra.framework.main.datatable.DomainFileContext;
import ghidra.framework.main.datatree.ArchiveProvider;
import ghidra.framework.main.datatree.UndoActionDialog;
import ghidra.framework.main.projectdata.actions.VersionControlAction;
import ghidra.framework.model.DomainFile;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class VersionControlDataTypeArchiveUndoCheckoutAction
extends VersionControlAction {
    private DataTypeManagerPlugin dtmPlugin;
    private ArchiveProvider archiveProvider;

    public VersionControlDataTypeArchiveUndoCheckoutAction(DataTypeManagerPlugin plugin, ArchiveProvider provider) {
        super("UndoCheckOut", plugin.getName(), plugin.getTool());
        this.dtmPlugin = plugin;
        this.archiveProvider = provider;
        ImageIcon icon = ResourceManager.loadImage((String)"images/vcUndoCheckOut.png");
        this.setPopupMenuData(new MenuData(new String[]{"Undo Checkout"}, (Icon)icon, "Repository"));
        this.setDescription("Undo checkout");
    }

    public void actionPerformed(DomainFileContext context) {
        this.undoCheckOut();
    }

    public boolean isEnabledForContext(DomainFileContext context) {
        if (this.isFileSystemBusy()) {
            return false;
        }
        List domainFiles = context.getSelectedFiles();
        for (DomainFile domainFile : domainFiles) {
            if (!domainFile.isCheckedOut()) continue;
            return true;
        }
        return false;
    }

    protected void undoCheckOut() {
        if (!this.checkRepositoryConnected()) {
            return;
        }
        this.closeEditorsForUndoCheckOut();
        List<Archive> archiveList = this.archiveProvider.getArchives();
        ArrayList<DomainFileArchive> unmodifiedCheckOutsList = new ArrayList<DomainFileArchive>();
        ArrayList<DomainFileArchive> modifiedCheckOutsList = new ArrayList<DomainFileArchive>();
        for (Archive archive2 : archiveList) {
            ProjectArchive archive = (ProjectArchive)archive2;
            DomainFile domainFile = archive.getDomainFile();
            if (!domainFile.isCheckedOut()) continue;
            if (domainFile.modifiedSinceCheckout() || domainFile.isChanged()) {
                modifiedCheckOutsList.add(archive);
                continue;
            }
            unmodifiedCheckOutsList.add(archive);
        }
        try {
            this.undoCheckOuts(unmodifiedCheckOutsList, modifiedCheckOutsList);
        }
        catch (CancelledException e) {
            this.tool.setStatusInfo("Undo checkouts was canceled");
            return;
        }
    }

    private void closeEditorsForUndoCheckOut() {
        DataTypeEditorManager editorManager = this.dtmPlugin.getEditorManager();
        List<Archive> archiveList = this.archiveProvider.getArchives();
        for (Archive archive : archiveList) {
            if (!editorManager.checkEditors(archive.getDataTypeManager(), true)) continue;
            editorManager.dismissEditors(archive.getDataTypeManager());
        }
    }

    protected void undoCheckOuts(List<DomainFileArchive> unmodifiedArchivesList, List<DomainFileArchive> modifiedArchivesList) throws CancelledException {
        boolean saveCopy = false;
        DomainFile[] selectedFiles = new DomainFile[]{};
        boolean undoWasCancelled = false;
        List<DomainFileArchive> selectedArchives = modifiedArchivesList;
        if (modifiedArchivesList.size() > 0) {
            UndoActionDialog dialog = new UndoActionDialog("Confirm Undo Checkout", ResourceManager.loadImage((String)"images/vcUndoCheckOut.png"), "UndoCheckOut", "checkout", this.getDomainFileList(modifiedArchivesList));
            int actionID = dialog.showDialog(this.tool);
            if (actionID != 1) {
                saveCopy = dialog.saveCopy();
                selectedFiles = dialog.getSelectedDomainFiles();
                selectedArchives = this.getMatchingArchives(modifiedArchivesList, selectedFiles);
            } else {
                throw new CancelledException();
            }
        }
        if (unmodifiedArchivesList.size() > 0 || selectedFiles.length > 0) {
            this.tool.execute((Task)new DataTypeArchiveUndoCheckOutTask(unmodifiedArchivesList, selectedArchives, saveCopy));
        }
        if (undoWasCancelled) {
            this.tool.setStatusInfo("Undo check out was canceled");
        }
    }

    private List<DomainFileArchive> getMatchingArchives(List<DomainFileArchive> archivesList, DomainFile[] selectedFiles) {
        ArrayList<DomainFileArchive> archiveList = new ArrayList<DomainFileArchive>(selectedFiles.length);
        for (DomainFile domainFile : selectedFiles) {
            DomainFileArchive archive = this.getArchiveForDomainFile(archivesList, domainFile);
            if (archive == null) {
                throw new AssertException("Can't find data type archive for domain file " + domainFile.getName());
            }
            archiveList.add(archive);
        }
        return archiveList;
    }

    private DomainFileArchive getArchiveForDomainFile(List<DomainFileArchive> archivesList, DomainFile domainFile) {
        for (DomainFileArchive domainFileArchive : archivesList) {
            if (domainFileArchive.getDomainFile() != domainFile) continue;
            return domainFileArchive;
        }
        return null;
    }

    private List<DomainFile> getDomainFileList(List<DomainFileArchive> modifiedArchivesList) {
        ArrayList<DomainFile> dfList = new ArrayList<DomainFile>(modifiedArchivesList.size());
        for (DomainFileArchive dfArchive : modifiedArchivesList) {
            dfList.add(dfArchive.getDomainFile());
        }
        return dfList;
    }

    protected void saveCheckOutChanges(List<DomainFile> changedList) throws CancelledException {
        if (changedList.size() > 0) {
            boolean cancelled;
            SaveDataDialog dialog = new SaveDataDialog(this.tool);
            boolean bl = cancelled = !dialog.showDialog(changedList);
            if (cancelled) {
                throw new CancelledException();
            }
        }
    }

    private class DataTypeArchiveUndoCheckOutTask
    extends Task {
        private List<DomainFileArchive> unmodifiedCheckOutsList;
        private List<DomainFileArchive> modifiedCheckedOutFiles;
        private boolean saveCopy;

        DataTypeArchiveUndoCheckOutTask(List<DomainFileArchive> unmodifiedCheckOutsList, List<DomainFileArchive> modifiedCheckedOutFiles, boolean saveCopy) {
            super("Undo Check Out", true, true, true);
            this.unmodifiedCheckOutsList = unmodifiedCheckOutsList;
            this.modifiedCheckedOutFiles = modifiedCheckedOutFiles;
            this.saveCopy = saveCopy;
        }

        public void run(TaskMonitor monitor) {
            try {
                for (int i = 0; i < this.unmodifiedCheckOutsList.size(); ++i) {
                    DomainFileArchive archive = this.unmodifiedCheckOutsList.get(i);
                    DomainFile df = archive.getDomainFile();
                    if (!df.isCheckedOut() || VersionControlDataTypeArchiveUndoCheckoutAction.this.dtmPlugin == null) continue;
                    archive.close();
                    df.undoCheckout(false);
                    VersionControlDataTypeArchiveUndoCheckoutAction.this.dtmPlugin.openArchive(df);
                }
                for (DomainFileArchive currentArchive : this.modifiedCheckedOutFiles) {
                    monitor.checkCanceled();
                    DomainFile currentDF = currentArchive.getDomainFile();
                    if (this.saveCopy && currentDF.isChanged()) {
                        monitor.setMessage("Saving " + currentDF.getName());
                        currentDF.save(monitor);
                    }
                    monitor.setMessage("Undoing Check Out " + currentDF.getName());
                    currentArchive.close();
                    currentDF.undoCheckout(this.saveCopy);
                    VersionControlDataTypeArchiveUndoCheckoutAction.this.dtmPlugin.openArchive(currentDF);
                }
            }
            catch (CancelledException e) {
                VersionControlDataTypeArchiveUndoCheckoutAction.this.tool.setStatusInfo("Undo check out was canceled");
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)VersionControlDataTypeArchiveUndoCheckoutAction.this.repository, (Exception)e, (String)"Undo Check Out", (Component)VersionControlDataTypeArchiveUndoCheckoutAction.this.tool.getToolFrame());
            }
        }
    }
}

