/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeSlowLoadingNode;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.GFile;
import ghidra.plugins.fsbrowser.FSBDirNode;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public abstract class FSBNode
extends GTreeSlowLoadingNode {
    public abstract FSRL getFSRL();

    public String getToolTip() {
        return this.getName();
    }

    public Icon getIcon(boolean expanded) {
        return null;
    }

    public String getName() {
        return this.getFSRL().getName();
    }

    public FSBRootNode getFSBRootNode() {
        GTreeNode node;
        for (node = this.getParent(); node != null && !(node instanceof FSBRootNode); node = node.getParent()) {
        }
        return node instanceof FSBRootNode ? (FSBRootNode)node : null;
    }

    protected abstract void updateFileAttributes(TaskMonitor var1) throws CancelledException;

    public static FSBRootNode findContainingFileSystemFSBRootNode(FSBNode node) {
        GTreeNode parent;
        for (parent = node.getParent(); parent != null && !(parent instanceof FSBRootNode); parent = parent.getParent()) {
        }
        return parent instanceof FSBRootNode ? (FSBRootNode)parent : null;
    }

    public static List<GTreeNode> createNodesFromFileList(List<GFile> files, TaskMonitor monitor) {
        files = new ArrayList<GFile>(files);
        Collections.sort(files, FSUtilities.GFILE_NAME_TYPE_COMPARATOR);
        ArrayList<GTreeNode> nodes = new ArrayList<GTreeNode>(files.size());
        for (GFile child : files) {
            FSBFileNode node = FSBNode.createNodeFromFile(child);
            if (node.isLeaf()) {
                node.updateFileAttributes(monitor);
            }
            nodes.add((GTreeNode)node);
        }
        return nodes;
    }

    public static FSBFileNode createNodeFromFile(GFile file) {
        return file.isDirectory() ? new FSBDirNode(file) : new FSBFileNode(file);
    }
}

