/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.event.mouse.GMouseListenerAdapter;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeRenderer;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.TextEditorService;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemEventListener;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.plugin.importer.ProgramMappingService;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBActionManager;
import ghidra.plugins.fsbrowser.FSBDirNode;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import ghidra.plugins.fsbrowser.FSBUtils;
import ghidra.plugins.fsbrowser.FileIconService;
import ghidra.plugins.fsbrowser.FileSystemBrowserPlugin;
import ghidra.plugins.fsbrowser.ImageManager;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class FileSystemBrowserComponentProvider
extends ComponentProviderAdapter
implements FileSystemEventListener {
    private static final String TITLE = "Filesystem Viewer";
    private FileSystemBrowserPlugin plugin;
    private FSBActionManager actionManager;
    private GTree gTree;
    private FSBRootNode rootNode;
    private FileSystemService fsService = FileSystemService.getInstance();

    public FileSystemBrowserComponentProvider(FileSystemBrowserPlugin plugin, FileSystemRef fsRef) {
        super(plugin.getTool(), fsRef.getFilesystem().getName(), plugin.getName());
        this.plugin = plugin;
        this.rootNode = new FSBRootNode(fsRef);
        this.setTransient();
        this.setIcon(ImageManager.PHOTO);
        this.gTree = new GTree((GTreeNode)this.rootNode);
        this.gTree.getSelectionModel().setSelectionMode(4);
        this.gTree.getSelectionModel().addTreeSelectionListener(e -> {
            this.tool.contextChanged((ComponentProvider)this);
            TreePath[] paths = this.gTree.getSelectionPaths();
            if (paths.length == 1) {
                GTreeNode clickedNode = (GTreeNode)paths[0].getLastPathComponent();
                this.handleSingleClick(clickedNode);
            }
        });
        this.gTree.addMouseListener((MouseListener)new GMouseListenerAdapter(){

            public void doubleClickTriggered(MouseEvent e) {
                FileSystemBrowserComponentProvider.this.handleDoubleClick(FileSystemBrowserComponentProvider.this.gTree.getNodeForLocation(e.getX(), e.getY()));
                e.consume();
            }

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (!e.isConsumed()) {
                    FileSystemBrowserComponentProvider.this.handleSingleClick(FileSystemBrowserComponentProvider.this.gTree.getNodeForLocation(e.getX(), e.getY()));
                }
            }
        });
        this.gTree.setCellRenderer(new GTreeRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof FSBRootNode) {
                    this.renderFS((FSBRootNode)((Object)value), selected);
                } else if (!(value instanceof FSBDirNode)) {
                    if (value instanceof FSBFileNode) {
                        this.renderFile((FSBFileNode)((Object)value), selected);
                    } else if (value instanceof FSBNode) {
                        this.renderNode((FSBNode)((Object)value), selected);
                    }
                }
                return this;
            }

            private void renderFS(FSBRootNode node, boolean selected) {
                FileSystemRef nodeFSRef = node.getFSRef();
                if (nodeFSRef == null || nodeFSRef.getFilesystem() == null) {
                    return;
                }
                FSRLRoot fsFSRL = nodeFSRef.getFilesystem().getFSRL();
                String containerFilename = fsFSRL.hasContainer() ? fsFSRL.getContainer().getName() : "unknown";
                Icon image = FileIconService.getInstance().getImage(containerFilename, "filesystem");
                this.setIcon(image);
            }

            private void renderFile(FSBFileNode node, boolean selected) {
                FSRL fsrl = node.getFSRL();
                String filename = fsrl.getName();
                String importOverlay = ProgramMappingService.isFileImportedIntoProject(fsrl) ? "imported" : null;
                String mountedOverlay = FileSystemBrowserComponentProvider.this.fsService.isFilesystemMountedAt(fsrl) ? "filesystem" : null;
                String missingPasswordOverlay = node.hasMissingPassword() ? "password_missing" : null;
                Icon ico = FileIconService.getInstance().getImage(filename, importOverlay, mountedOverlay, missingPasswordOverlay);
                this.setIcon(ico);
                if (ProgramMappingService.isFileOpen(fsrl)) {
                    this.setForeground(selected ? Color.CYAN : Color.MAGENTA);
                }
            }

            private void renderNode(FSBNode node, boolean selected) {
            }
        });
        this.actionManager = new FSBActionManager(plugin, this, (TextEditorService)plugin.getTool().getService(TextEditorService.class), this.gTree);
        this.setHelpLocation(new HelpLocation("FileSystemBrowserPlugin", "FileSystemBrowserIntroduction"));
        fsRef.getFilesystem().getRefManager().addListener(this);
    }

    GTree getGTree() {
        return this.gTree;
    }

    FSRL getFSRL() {
        return this.rootNode != null ? this.rootNode.getFSRL() : null;
    }

    FSBActionManager getActionManager() {
        return this.actionManager;
    }

    void dispose() {
        if (this.rootNode != null && this.rootNode.getFSRef() != null && !this.rootNode.getFSRef().isClosed()) {
            this.rootNode.getFSRef().getFilesystem().getRefManager().removeListener(this);
        }
        this.removeFromTool();
        if (this.actionManager != null) {
            this.actionManager.dispose();
            this.actionManager = null;
        }
        if (this.gTree != null) {
            this.gTree.dispose();
            this.gTree = null;
        }
        this.rootNode = null;
        this.plugin = null;
    }

    public void componentHidden() {
        if (this.plugin != null) {
            this.plugin.removeFileSystemBrowserComponent(this);
            this.dispose();
        }
    }

    public void afterAddedToTool() {
        this.actionManager.registerComponentActionsInTool();
    }

    @Override
    public void onFilesystemClose(GFileSystem fs) {
        Msg.info((Object)this, (Object)("File system " + fs.getFSRL() + " was closed! Closing browser window"));
        Swing.runIfSwingOrRunLater(() -> this.componentHidden());
    }

    @Override
    public void onFilesystemRefChange(GFileSystem fs, FileSystemRefManager refManager) {
    }

    private boolean quickShowProgram(FSRL fsrl) {
        Object consumer;
        Program program;
        ProgramManager programManager;
        if (this.plugin.hasProgramManager() && (programManager = FSBUtils.getProgramManager(this.plugin.getTool(), false)) != null && (program = ProgramMappingService.findMatchingOpenProgram(fsrl, consumer = new Object())) != null) {
            programManager.setCurrentProgram(program);
            program.release(consumer);
            return true;
        }
        return false;
    }

    private void handleSingleClick(GTreeNode clickedNode) {
        FSBFileNode node;
        if (clickedNode instanceof FSBFileNode && (node = (FSBFileNode)clickedNode).getFSRL() != null) {
            this.quickShowProgram(node.getFSRL());
            this.updatePasswordStatus(node);
        }
    }

    private void updatePasswordStatus(FSBFileNode node) {
        if (node.hasMissingPassword()) {
            this.gTree.runTask(monitor -> {
                if (node.needsFileAttributesUpdate(monitor)) {
                    this.actionManager.doRefreshInfo(List.of(node), monitor);
                }
            });
        }
    }

    private void handleDoubleClick(GTreeNode clickedNode) {
        FSBFileNode node;
        if (clickedNode instanceof FSBFileNode && clickedNode.isLeaf() && (node = (FSBFileNode)clickedNode).getFSRL() != null && !this.quickShowProgram(node.getFSRL())) {
            this.actionManager.actionOpenPrograms.actionPerformed((ActionContext)this.getActionContext(null));
        }
    }

    public FSBActionContext getActionContext(MouseEvent event) {
        return new FSBActionContext(this, this.getSelectedNodes(event), event, this.gTree);
    }

    private FSBNode[] getSelectedNodes(MouseEvent event) {
        TreePath[] selectionPaths = this.gTree.getSelectionPaths();
        ArrayList<FSBNode> list = new ArrayList<FSBNode>(selectionPaths.length);
        for (TreePath selectionPath : selectionPaths) {
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof FSBNode)) continue;
            list.add((FSBNode)((Object)lastPathComponent));
        }
        if (list.isEmpty() && event != null) {
            GTreeNode nodeAtEventLocation;
            JTree sourceTree;
            Object source = event.getSource();
            int x = event.getX();
            int y = event.getY();
            if (source instanceof JTree && this.gTree.isMyJTree(sourceTree = (JTree)source) && (nodeAtEventLocation = this.gTree.getNodeForLocation(x, y)) != null && nodeAtEventLocation instanceof FSBNode) {
                list.add((FSBNode)nodeAtEventLocation);
            }
        }
        return (FSBNode[])list.toArray(FSBNode[]::new);
    }

    public JComponent getComponent() {
        return this.gTree;
    }

    public String getName() {
        return TITLE;
    }

    public WindowPosition getDefaultWindowPosition() {
        return WindowPosition.WINDOW;
    }
}

