/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectData;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class ELFExternalSymbolResolver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fixUnresolvedExternalSymbols(Program program, boolean saveIfModified, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, IOException {
        ProjectData projectData = program.getDomainFile().getParent().getProjectData();
        Collection<Long> unresolvedExternalFunctionIds = ELFExternalSymbolResolver.getUnresolvedExternalFunctionIds(program);
        if (unresolvedExternalFunctionIds.size() == 0) {
            return;
        }
        List<Library> libSearchList = ELFExternalSymbolResolver.getLibrarySearchList(program);
        if (libSearchList.isEmpty()) {
            return;
        }
        int transactionID = program.startTransaction("Resolve External Symbols");
        try {
            messageLog.appendMsg("----- [" + program.getName() + "] Resolve " + unresolvedExternalFunctionIds.size() + " external symbols -----");
            for (Library extLibrary : libSearchList) {
                monitor.checkCanceled();
                String libName = extLibrary.getName();
                String libPath = extLibrary.getAssociatedProgramPath();
                if (libPath == null) continue;
                DomainFile libDomainFile = projectData.getFile(libPath);
                if (libDomainFile == null) {
                    messageLog.appendMsg("Referenced external program not found: " + libPath);
                    continue;
                }
                Object consumer = new Object();
                DomainObject libDomainObject = null;
                try {
                    libDomainObject = libDomainFile.getDomainObject(consumer, false, false, monitor);
                    if (!(libDomainObject instanceof Program)) {
                        messageLog.appendMsg("Referenced external program is not a program: " + libPath);
                        continue;
                    }
                    monitor.setMessage("Resolving symbols published by library " + libName);
                    ELFExternalSymbolResolver.resolveSymbolsToLibrary(program, unresolvedExternalFunctionIds, extLibrary, (Program)libDomainObject, messageLog, monitor);
                }
                catch (IOException e) {
                    messageLog.appendMsg("Failed to open library dependency project file: " + libDomainFile.getPathname());
                }
                catch (VersionException e) {
                    messageLog.appendMsg("Referenced external program requires updgrade, unable to consider symbols: " + libPath);
                }
                finally {
                    if (libDomainObject == null) continue;
                    libDomainObject.release(consumer);
                }
            }
            messageLog.appendMsg("Unresolved external symbols which remain: " + unresolvedExternalFunctionIds.size());
        }
        finally {
            program.endTransaction(transactionID, true);
        }
        if (saveIfModified && program.canSave() && program.isChanged()) {
            program.save("ExternalSymbolResolver", monitor);
        }
    }

    private static void resolveSymbolsToLibrary(Program program, Collection<Long> unresolvedExternalFunctionIds, Library extLibrary, Program libProgram, MessageLog messageLog, TaskMonitor monitor) throws CancelledException {
        int libResolvedCount = 0;
        ExternalManager externalManager = program.getExternalManager();
        SymbolTable symbolTable = program.getSymbolTable();
        Iterator<Long> idIterator = unresolvedExternalFunctionIds.iterator();
        while (idIterator.hasNext()) {
            monitor.checkCanceled();
            Symbol s = symbolTable.getSymbol(idIterator.next().longValue());
            if (s == null || !s.isExternal() || s.getSymbolType() != SymbolType.FUNCTION) {
                Msg.error(ELFExternalSymbolResolver.class, (Object)"Concurrent modification of symbol table while resolving external symbols");
                idIterator.remove();
                continue;
            }
            ExternalLocation extLoc = externalManager.getExternalLocation(s);
            if (s.getSource() == SourceType.DEFAULT || !ELFExternalSymbolResolver.isLocationContainedInLibrary(libProgram, extLoc)) continue;
            try {
                s.setNamespace((Namespace)extLibrary);
                idIterator.remove();
                ++libResolvedCount;
                Msg.debug(ELFExternalSymbolResolver.class, (Object)("External symbol " + extLoc.getLabel() + " resolved to " + extLibrary.getName()));
            }
            catch (CircularDependencyException | DuplicateNameException | InvalidInputException e) {
                Msg.error(ELFExternalSymbolResolver.class, (Object)("Error setting external symbol namespace for " + extLoc.getLabel()), (Throwable)e);
            }
        }
        messageLog.appendMsg("Resolved " + libResolvedCount + " symbols to library " + extLibrary.getName());
    }

    private static boolean isLocationContainedInLibrary(Program libProgram, ExternalLocation extLoc) {
        String name = extLoc.getOriginalImportedName();
        if (name == null) {
            name = extLoc.getLabel();
        }
        for (Symbol s : libProgram.getSymbolTable().getLabelOrFunctionSymbols(name, null)) {
            if (!s.isExternalEntryPoint()) continue;
            return true;
        }
        return false;
    }

    private static Collection<Long> getUnresolvedExternalFunctionIds(Program program) {
        ArrayList<Long> symbolIds = new ArrayList<Long>();
        ExternalManager externalManager = program.getExternalManager();
        Library library = externalManager.getExternalLibrary("<EXTERNAL>");
        if (library != null) {
            for (Symbol s : program.getSymbolTable().getSymbols((Namespace)library)) {
                if (s.getSymbolType() != SymbolType.FUNCTION) continue;
                symbolIds.add(s.getID());
            }
        }
        return symbolIds;
    }

    private static Collection<String> getOrderedLibraryNamesNeeded(Program program) {
        TreeMap<Integer, String> orderLibraryMap = new TreeMap<Integer, String>();
        Options options = program.getOptions("Program Information");
        for (String optionName : options.getOptionNames()) {
            String libName;
            if (!optionName.startsWith("ELF Required Library [") || !optionName.endsWith("]") || (libName = options.getString(optionName, null)) == null) continue;
            String indexStr = optionName.substring("ELF Required Library [".length(), optionName.length() - 1).trim();
            try {
                orderLibraryMap.put(Integer.parseInt(indexStr), libName.trim());
            }
            catch (NumberFormatException e) {
                Msg.error(ELFExternalSymbolResolver.class, (Object)("Program contains invalid property: " + optionName));
            }
        }
        return orderLibraryMap.values();
    }

    private static List<Library> getLibrarySearchList(Program program) {
        ArrayList<Library> result = new ArrayList<Library>();
        ExternalManager externalManager = program.getExternalManager();
        for (String libName : ELFExternalSymbolResolver.getOrderedLibraryNamesNeeded(program)) {
            Library lib = externalManager.getExternalLibrary(libName);
            if (lib == null) continue;
            result.add(lib);
        }
        return result;
    }
}

