/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.object;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.naming.MDFragmentName;
import mdemangler.object.MDObjectCPP;
import mdemangler.object.MDObjectReserved;

public class MDObjectBracket
extends MDObjectReserved {
    private MDFragmentName fragmentName;
    private MDObjectCPP objectCPP;
    private MDFragmentName dollarOption;

    public MDObjectBracket(MDMang dmang) {
        super(dmang);
    }

    public String getPrefix() {
        StringBuilder bracketBuilder = new StringBuilder();
        if (this.dollarOption != null) {
            this.dmang.insertString(bracketBuilder, "]");
            this.dollarOption.insert(bracketBuilder);
            this.dmang.insertString(bracketBuilder, "[");
        }
        this.dmang.insertString(bracketBuilder, "]");
        this.fragmentName.insert(bracketBuilder);
        this.dmang.insertString(bracketBuilder, "[");
        return bracketBuilder.toString();
    }

    public MDObjectCPP getObjectCPP() {
        return this.objectCPP;
    }

    @Override
    public void insert(StringBuilder builder) {
        super.insert(builder);
        this.objectCPP.insert(builder);
        this.dmang.insertSpacedString(builder, this.getPrefix());
    }

    @Override
    protected void parseInternal() throws MDException {
        if (this.dmang.peek() != '_' && this.dmang.peek(1) != '_') {
            throw new MDException("Missing prefix in MDObjectBracket parsing");
        }
        this.dmang.increment(2);
        this.fragmentName = new MDFragmentName(this.dmang);
        this.fragmentName.parse();
        StringBuilder fragBuilder = new StringBuilder();
        this.fragmentName.insert(fragBuilder);
        this.fragmentName.setName(fragBuilder.toString().toUpperCase());
        this.objectCPP = new MDObjectCPP(this.dmang);
        this.objectCPP.parse();
        this.objectCPP = this.dmang.getEmbeddedObject(this.objectCPP);
    }
}

