/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

public enum OperatingSystem {
    WINDOWS("Windows"),
    LINUX("Linux"),
    MAC_OS_X("Mac OS X"),
    UNSUPPORTED("Unsupported Operating System");

    public static final OperatingSystem CURRENT_OPERATING_SYSTEM;
    private String operatingSystemName;
    private String operatingSystemProperty = System.getProperty("os.name");

    private OperatingSystem(String operatingSystemName) {
        this.operatingSystemName = operatingSystemName;
    }

    private static OperatingSystem findCurrentOperatingSystem() {
        String operatingSystemNameProperty = System.getProperty("os.name");
        for (OperatingSystem operatingSystem : OperatingSystem.values()) {
            if (operatingSystemNameProperty.toLowerCase().indexOf(operatingSystem.operatingSystemName.toLowerCase()) <= -1) continue;
            return operatingSystem;
        }
        return UNSUPPORTED;
    }

    public String toString() {
        return this.name() + "(" + this.operatingSystemProperty + ")";
    }

    static {
        CURRENT_OPERATING_SYSTEM = OperatingSystem.findCurrentOperatingSystem();
    }
}

