/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.GroovyClassLoader;
import groovy.transform.CompilationUnitAware;
import groovy.transform.RecordBase;
import groovy.transform.options.PropertyHandler;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.TupleConstructorASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class RecordTypeASTTransformation
extends AbstractASTTransformation
implements CompilationUnitAware {
    private CompilationUnit compilationUnit;
    private static final Class<? extends Annotation> MY_CLASS = RecordBase.class;
    public static final ClassNode MY_TYPE = ClassHelper.makeWithoutCaching(MY_CLASS, false);
    private static final String MY_TYPE_NAME = MY_TYPE.getNameWithoutPackage();

    @Override
    public String getAnnotationName() {
        return MY_TYPE_NAME;
    }

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            GroovyClassLoader classLoader = this.compilationUnit != null ? this.compilationUnit.getTransformLoader() : source.getClassLoader();
            PropertyHandler handler = PropertyHandler.createPropertyHandler(this, classLoader, (ClassNode)parent);
            if (handler == null) {
                return;
            }
            if (!handler.validateAttributes(this, anno)) {
                return;
            }
            this.doMakeImmutable((ClassNode)parent, anno, handler);
        }
    }

    private void doMakeImmutable(ClassNode cNode, AnnotationNode node, PropertyHandler handler) {
        ArrayList<PropertyNode> newProperties = new ArrayList<PropertyNode>();
        String cName = cNode.getName();
        if (!this.checkNotInterface(cNode, MY_TYPE_NAME)) {
            return;
        }
        RecordTypeASTTransformation.makeClassFinal(this, cNode);
        List<PropertyNode> pList = GeneralUtils.getInstanceProperties(cNode);
        for (PropertyNode propertyNode : pList) {
            RecordTypeASTTransformation.adjustPropertyForImmutability(propertyNode, newProperties, handler);
        }
        for (PropertyNode propertyNode : newProperties) {
            cNode.getProperties().remove(propertyNode);
            PropertyNode newProp = new PropertyNode(propertyNode.getField(), propertyNode.getModifiers() | 0x10, propertyNode.getGetterBlock(), null);
            newProp.setGetterName(propertyNode.getGetterNameOrDefault());
            cNode.removeField(propertyNode.getField().getName());
            cNode.addProperty(newProp);
        }
        List<FieldNode> fList = cNode.getFields();
        for (FieldNode fNode : fList) {
            RecordTypeASTTransformation.ensureNotPublic(this, cName, fNode);
        }
        if (cNode.getDeclaredField("serialVersionUID") == null) {
            cNode.addField("serialVersionUID", 26, ClassHelper.long_TYPE, GeneralUtils.constX(0L));
        }
        if (this.hasAnnotation(cNode, TupleConstructorASTTransformation.MY_TYPE)) {
            AnnotationNode annotationNode = cNode.getAnnotations(TupleConstructorASTTransformation.MY_TYPE).get(0);
            if (this.unsupportedTupleAttribute(annotationNode, "excludes")) {
                return;
            }
            if (this.unsupportedTupleAttribute(annotationNode, "includes")) {
                return;
            }
            if (this.unsupportedTupleAttribute(annotationNode, "includeProperties")) {
                return;
            }
            if (this.unsupportedTupleAttribute(annotationNode, "includeSuperFields")) {
                return;
            }
            if (this.unsupportedTupleAttribute(annotationNode, "callSuper")) {
                return;
            }
            if (this.unsupportedTupleAttribute(annotationNode, "force")) {
                return;
            }
        }
    }

    private boolean unsupportedTupleAttribute(AnnotationNode anno, String memberName) {
        if (this.getMemberValue(anno, memberName) != null) {
            String tname = TupleConstructorASTTransformation.MY_TYPE_NAME;
            this.addError("Error during " + MY_TYPE_NAME + " processing: Annotation attribute '" + memberName + "' not supported for " + tname + " when used with " + MY_TYPE_NAME, anno);
            return true;
        }
        return false;
    }

    private static void makeClassFinal(AbstractASTTransformation xform, ClassNode cNode) {
        int modifiers = cNode.getModifiers();
        if ((modifiers & 0x10) == 0) {
            if ((modifiers & 0x1400) == 5120) {
                xform.addError("Error during " + MY_TYPE_NAME + " processing: annotation found on inappropriate class " + cNode.getName(), cNode);
                return;
            }
            cNode.setModifiers(modifiers | 0x10);
        }
    }

    private static void ensureNotPublic(AbstractASTTransformation xform, String cNode, FieldNode fNode) {
        String fName = fNode.getName();
        if (!(!fNode.isPublic() || fName.contains("$") || fNode.isStatic() && fNode.isFinal())) {
            xform.addError("Public field '" + fName + "' not allowed for " + MY_TYPE_NAME + " class '" + cNode + "'.", fNode);
        }
    }

    private static void adjustPropertyForImmutability(PropertyNode pNode, List<PropertyNode> newNodes, PropertyHandler handler) {
        FieldNode fNode = pNode.getField();
        fNode.setModifiers(pNode.getModifiers() & 0xFFFFFFFE | 0x10 | 2);
        Statement getter = handler.createPropGetter(pNode);
        if (getter != null) {
            pNode.setGetterBlock(getter);
            pNode.setGetterName(pNode.getName());
        }
        newNodes.add(pNode);
    }

    @Override
    public void setCompilationUnit(CompilationUnit unit) {
        this.compilationUnit = unit;
    }
}

