/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile;

import docking.ComponentProvider;
import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.app.plugin.core.decompile.PrimaryDecompilerProvider;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.services.GoToService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.model.DomainFile;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.database.SpecExtension;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.task.SwingUpdateManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Analysis", shortDescription="Decompiler", description="Plugin for producing high-level decompilation", servicesRequired={GoToService.class, NavigationHistoryService.class, ClipboardService.class, DataTypeManagerService.class}, eventsConsumed={ProgramActivatedPluginEvent.class, ProgramOpenedPluginEvent.class, ProgramLocationPluginEvent.class, ProgramSelectionPluginEvent.class, ProgramClosedPluginEvent.class})
public class DecompilePlugin
extends Plugin {
    private PrimaryDecompilerProvider connectedProvider;
    private List<DecompilerProvider> disconnectedProviders;
    private Program currentProgram;
    private ProgramLocation currentLocation;
    private ProgramSelection currentSelection;
    SwingUpdateManager delayedLocationUpdateMgr = new SwingUpdateManager(200, 200, () -> {
        if (this.currentLocation != null) {
            this.connectedProvider.setLocation(this.currentLocation, null);
        }
    });

    public DecompilePlugin(PluginTool tool) {
        super(tool);
        this.disconnectedProviders = new ArrayList<DecompilerProvider>();
        this.connectedProvider = new PrimaryDecompilerProvider(this);
    }

    protected void init() {
        ClipboardService clipboardService = (ClipboardService)this.tool.getService(ClipboardService.class);
        if (clipboardService != null) {
            this.connectedProvider.setClipboardService(clipboardService);
            for (DecompilerProvider provider : this.disconnectedProviders) {
                provider.setClipboardService(clipboardService);
            }
        }
    }

    public void writeDataState(SaveState saveState) {
        if (this.connectedProvider != null) {
            this.connectedProvider.writeDataState(saveState);
        }
        saveState.putInt("Num Disconnected", this.disconnectedProviders.size());
        int i = 0;
        for (DecompilerProvider provider : this.disconnectedProviders) {
            SaveState providerSaveState = new SaveState();
            DomainFile df = provider.getProgram().getDomainFile();
            if (df.getParent() == null) continue;
            String programPathname = df.getPathname();
            providerSaveState.putString("Program Path", programPathname);
            provider.writeDataState(providerSaveState);
            String elementName = "Provider" + i;
            saveState.putXmlElement(elementName, providerSaveState.saveToXml());
            ++i;
        }
    }

    public void readDataState(SaveState saveState) {
        ProgramManager programManagerService = (ProgramManager)this.tool.getService(ProgramManager.class);
        if (this.connectedProvider != null) {
            this.connectedProvider.readDataState(saveState);
        }
        int numDisconnected = saveState.getInt("Num Disconnected", 0);
        for (int i = 0; i < numDisconnected; ++i) {
            Program program;
            Element xmlElement = saveState.getXmlElement("Provider" + i);
            SaveState providerSaveState = new SaveState(xmlElement);
            String programPath = providerSaveState.getString("Program Path", "");
            DomainFile file = this.tool.getProject().getProjectData().getFile(programPath);
            if (file == null || (program = programManagerService.openProgram(file)) == null) continue;
            DecompilerProvider provider = this.createNewDisconnectedProvider();
            provider.doSetProgram(program);
            provider.readDataState(providerSaveState);
        }
    }

    DecompilerProvider createNewDisconnectedProvider() {
        DecompilerProvider decompilerProvider = new DecompilerProvider(this, false);
        decompilerProvider.setClipboardService((ClipboardService)this.tool.getService(ClipboardService.class));
        this.disconnectedProviders.add(decompilerProvider);
        this.tool.showComponentProvider((ComponentProvider)decompilerProvider, true);
        return decompilerProvider;
    }

    public void dispose() {
        this.currentProgram = null;
        if (this.connectedProvider != null) {
            this.removeProvider(this.connectedProvider);
        }
        for (DecompilerProvider provider : this.disconnectedProviders) {
            this.removeProvider(provider);
        }
        this.disconnectedProviders.clear();
    }

    void exportLocation(Program program, ProgramLocation location) {
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            service.goTo(location, program);
        }
    }

    void updateSelection(DecompilerProvider provider, Program selProgram, ProgramSelection selection) {
        if (provider == this.connectedProvider) {
            this.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(this.name, selection, selProgram));
        }
    }

    void closeProvider(DecompilerProvider provider) {
        if (provider == this.connectedProvider) {
            this.tool.showComponentProvider((ComponentProvider)provider, false);
        } else {
            this.disconnectedProviders.remove(provider);
            this.removeProvider(provider);
        }
    }

    void locationChanged(DecompilerProvider provider, ProgramLocation location) {
        if (provider == this.connectedProvider) {
            this.firePluginEvent((PluginEvent)new ProgramLocationPluginEvent(this.name, location, location.getProgram()));
        }
    }

    public void selectionChanged(DecompilerProvider provider, ProgramSelection selection) {
        if (provider == this.connectedProvider) {
            this.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(this.name, selection, this.currentProgram));
        }
    }

    private void removeProvider(DecompilerProvider provider) {
        this.tool.removeComponentProvider((ComponentProvider)provider);
        provider.dispose();
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramClosedPluginEvent) {
            Program program = ((ProgramClosedPluginEvent)event).getProgram();
            this.programClosed(program);
            return;
        }
        if (this.connectedProvider == null) {
            return;
        }
        if (event instanceof ProgramActivatedPluginEvent) {
            this.currentProgram = ((ProgramActivatedPluginEvent)event).getActiveProgram();
            this.connectedProvider.doSetProgram(this.currentProgram);
            if (this.currentProgram != null) {
                SpecExtension.registerOptions((Program)this.currentProgram);
            }
        } else if (event instanceof ProgramLocationPluginEvent) {
            Listing listing;
            CodeUnit codeUnit;
            ProgramLocation location = ((ProgramLocationPluginEvent)event).getLocation();
            Address address = location.getAddress();
            if (address.isExternalAddress()) {
                return;
            }
            if (this.currentProgram != null && (codeUnit = (listing = this.currentProgram.getListing()).getCodeUnitContaining(address)) instanceof Data) {
                return;
            }
            this.currentLocation = location;
            this.delayedLocationUpdateMgr.updateLater();
        } else if (event instanceof ProgramSelectionPluginEvent) {
            this.currentSelection = ((ProgramSelectionPluginEvent)event).getSelection();
            this.connectedProvider.setSelection(this.currentSelection);
        }
    }

    private void programClosed(Program closedProgram) {
        Iterator<DecompilerProvider> iterator = this.disconnectedProviders.iterator();
        while (iterator.hasNext()) {
            DecompilerProvider provider = iterator.next();
            if (provider.getProgram() != closedProgram) continue;
            iterator.remove();
            this.removeProvider(provider);
        }
        if (this.connectedProvider != null) {
            this.connectedProvider.programClosed(closedProgram);
        }
    }

    public ProgramLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        if (interfaceClass == DecompilerHoverService.class) {
            DecompilerHoverService hoverService = (DecompilerHoverService)service;
            this.connectedProvider.getDecompilerPanel().addHoverService(hoverService);
            for (DecompilerProvider provider : this.disconnectedProviders) {
                provider.getDecompilerPanel().addHoverService(hoverService);
            }
        }
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
        if (interfaceClass == DecompilerHoverService.class) {
            DecompilerHoverService hoverService = (DecompilerHoverService)service;
            this.connectedProvider.getDecompilerPanel().removeHoverService(hoverService);
            for (DecompilerProvider provider : this.disconnectedProviders) {
                provider.getDecompilerPanel().removeHoverService(hoverService);
            }
        }
    }
}

