/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.TokenHighlights;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.util.HelpLocation;

public abstract class AbstractSetSecondaryHighlightAction
extends AbstractDecompilerAction {
    AbstractSetSecondaryHighlightAction(String name) {
        super(name);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionSecondaryHighlight"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        if (!context.hasRealFunction()) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        TokenHighlights highlightedTokens = context.getDecompilerPanel().getSecondaryHighlightedTokens();
        return !highlightedTokens.contains(tokenAtCursor);
    }
}

