/*
 * Decompiled with CFR 0.152.
 */
package generic.depends;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import generic.depends.DependentService;
import generic.depends.DependentServiceConstructor;
import generic.depends.err.ServiceConstructionException;
import generic.depends.err.UnsatisfiedFieldsException;
import generic.depends.err.UnsatisfiedParameterException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependentServiceResolver<T> {
    private static final Map<Class<?>, DependentServiceResolver<?>> CACHED = new HashMap();
    private final Set<Class<?>> classesIncluded = new HashSet();
    private final Multimap<Class<?>, Field> fieldsByClass = HashMultimap.create();
    private final Multimap<Class<?>, Class<?>> depsByDependents = HashMultimap.create();
    private final Map<Class<?>, Method> constructors = new HashMap();
    private final List<DependentServiceConstructor<?>> ordered = new ArrayList();

    public static <T> DependentServiceResolver<T> get(Class<T> cls) throws UnsatisfiedParameterException, UnsatisfiedFieldsException {
        DependentServiceResolver<Object> resolver = CACHED.get(cls);
        if (resolver == null) {
            resolver = new DependentServiceResolver<T>(cls);
            CACHED.put(cls, resolver);
        }
        return resolver;
    }

    public static <T> void inject(T t) throws ServiceConstructionException, UnsatisfiedParameterException, UnsatisfiedFieldsException {
        DependentServiceResolver.get(t.getClass()).injectServices(t);
    }

    private DependentServiceResolver(Class<T> cls) throws UnsatisfiedParameterException, UnsatisfiedFieldsException {
        this.addClass(cls);
        this.compile();
    }

    private void addClass(Class<?> cls) {
        DependentService annot;
        if (this.classesIncluded.contains(cls)) {
            return;
        }
        Class<?> superCls = cls.getSuperclass();
        if (superCls == null) {
            return;
        }
        this.addClass(superCls);
        for (Class<?> clazz : cls.getInterfaces()) {
            this.addClass(clazz);
        }
        for (GenericDeclaration genericDeclaration : cls.getDeclaredMethods()) {
            annot = ((Method)genericDeclaration).getAnnotation(DependentService.class);
            if (annot == null) continue;
            int mods = ((Method)genericDeclaration).getModifiers();
            if (Modifier.isStatic(mods)) {
                throw new IllegalArgumentException("Constructor must be a non-static method");
            }
            Class<?> override = annot.override();
            Class<?> rCls = ((Method)genericDeclaration).getReturnType();
            if (override != DependentService.Sentinel.class) {
                if (!override.isAssignableFrom(rCls)) {
                    throw new IllegalArgumentException("Overridden constructor must return same or subclass of original");
                }
                this.depsByDependents.put(override, rCls);
                this.constructors.put(override, (Method)genericDeclaration);
            }
            this.constructors.put(rCls, (Method)genericDeclaration);
            ((Method)genericDeclaration).setAccessible(true);
            for (Class<?> pType : ((Method)genericDeclaration).getParameterTypes()) {
                this.depsByDependents.put(rCls, pType);
            }
        }
        for (AnnotatedElement annotatedElement : cls.getDeclaredFields()) {
            annot = ((Field)annotatedElement).getAnnotation(DependentService.class);
            if (annot == null) continue;
            Class<?> fCls = ((Field)annotatedElement).getType();
            this.fieldsByClass.put(fCls, (Object)annotatedElement);
            ((Field)annotatedElement).setAccessible(true);
        }
    }

    private void compile() throws UnsatisfiedParameterException, UnsatisfiedFieldsException {
        HashSet missing = new HashSet(this.fieldsByClass.keySet());
        missing.removeAll(this.constructors.keySet());
        if (!missing.isEmpty()) {
            throw new UnsatisfiedFieldsException(missing);
        }
        HashSet unordered = new HashSet(this.constructors.keySet());
        while (!unordered.isEmpty()) {
            HashSet forRound = new HashSet(unordered);
            forRound.removeAll(this.depsByDependents.keySet());
            if (forRound.isEmpty()) {
                throw new UnsatisfiedParameterException(unordered);
            }
            for (Class clazz : forRound) {
                Method m = this.constructors.get(clazz);
                unordered.remove(clazz);
                this.ordered.add(new DependentServiceConstructor(clazz, m));
                this.depsByDependents.values().removeAll(Collections.singleton(clazz));
            }
        }
        assert (this.ordered.size() == this.constructors.size());
    }

    public void injectServices(T obj) throws ServiceConstructionException {
        HashMap instancesByClass = new HashMap();
        HashMap constructed = new HashMap();
        for (DependentServiceConstructor<?> cons : this.ordered) {
            Object service = constructed.get(cons.method);
            if (service == null) {
                service = cons.construct(obj, instancesByClass);
                constructed.put(cons.method, service);
            }
            instancesByClass.put(cons.cls, service);
        }
        for (Map.Entry entry : this.fieldsByClass.entries()) {
            try {
                ((Field)entry.getValue()).set(obj, instancesByClass.get(entry.getKey()));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

