/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public interface AutoConfigState {
    public static <T> ClassHandler<T> wireHandler(Class<T> cls, MethodHandles.Lookup lookup) {
        try {
            return new ClassHandler<T>(cls, lookup);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static class ClassHandler<T> {
        private final Set<ConfigStateField<?>> fields = new LinkedHashSet();

        ClassHandler(Class<T> cls, MethodHandles.Lookup lookup) throws IllegalAccessException {
            this.gatherAnnotatedFields(cls, lookup);
        }

        private void gatherAnnotatedFields(Class<?> cls, MethodHandles.Lookup lookup) throws IllegalAccessException {
            for (Field f : cls.getDeclaredFields()) {
                AutoConfigStateField annot = f.getAnnotation(AutoConfigStateField.class);
                if (annot == null) continue;
                this.fields.add(new ConfigStateField(annot, f, f.getType(), lookup));
            }
        }

        public void writeConfigState(T from, SaveState into) {
            for (ConfigStateField<?> f : this.fields) {
                f.save(from, into);
            }
        }

        public void readConfigState(T into, SaveState from) {
            for (ConfigStateField<?> f : this.fields) {
                f.load(into, from);
            }
        }
    }

    public static class ConfigStateField<T> {
        private static final Map<Class<?>, ConfigFieldCodec<?>> CODECS_BY_TYPE = new HashMap();
        private static final Map<Class<?>, ConfigFieldCodec<?>> CODECS_BY_SPEC = new HashMap();
        private final MethodHandle getter;
        private final MethodHandle setter;
        private final ConfigFieldCodec<T> codec;
        private final String name;

        private static <T> void addCodec(Class<T> cls, ConfigFieldCodec<T> codec) {
            CODECS_BY_TYPE.put(cls, codec);
        }

        public static <T> ConfigFieldCodec<T> getCodecByType(Class<T> cls) {
            if (Enum.class.isAssignableFrom(cls)) {
                return EnumConfigFieldCodec.INSTANCE;
            }
            return CODECS_BY_TYPE.get(cls);
        }

        private static <T extends ConfigFieldCodec<?>> T getCodecBySpec(Class<T> cls) {
            Map<Class<?>, ConfigFieldCodec<?>> map = CODECS_BY_SPEC;
            synchronized (map) {
                ConfigFieldCodec codec = CODECS_BY_SPEC.get(cls);
                if (codec != null) {
                    return (T)codec;
                }
                try {
                    Constructor<T> constructor = cls.getConstructor(new Class[0]);
                    codec = (ConfigFieldCodec)constructor.newInstance(new Object[0]);
                    CODECS_BY_SPEC.put(cls, codec);
                    return (T)codec;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new AssertionError("Illegal codec specification. Constructor() cannot be invoked: " + cls, e);
                }
            }
        }

        public static <T> void putState(SaveState state, Class<T> type, String name, T value) {
            ConfigFieldCodec<T> codec = ConfigStateField.getCodecByType(type);
            if (codec == null) {
                throw new IllegalArgumentException("No codec for type " + type);
            }
            codec.write(state, name, value);
        }

        public static <T> T getState(SaveState state, Class<T> type, String name) {
            ConfigFieldCodec<Object> codec = ConfigStateField.getCodecByType(type);
            if (codec == null) {
                throw new IllegalArgumentException("No codec for type " + type);
            }
            return codec.read(state, name, null);
        }

        private ConfigStateField(AutoConfigStateField annot, Field f, Class<T> type, MethodHandles.Lookup lookup) throws IllegalAccessException {
            this.getter = lookup.unreflectGetter(f);
            this.setter = Modifier.isFinal(f.getModifiers()) ? null : lookup.unreflectSetter(f);
            this.name = f.getName();
            Class<? extends ConfigFieldCodec> codecCls = annot.codec();
            this.codec = codecCls == AutoConfigStateField.DefaultConfigFieldCodec.class ? ConfigStateField.getCodecByType(type) : ConfigStateField.getCodecBySpec(codecCls);
            if (this.codec == null) {
                throw new AssertionError((Object)(AutoConfigStateField.class.getSimpleName() + ": Specify a codec for " + f + "."));
            }
        }

        private void save(Object from, SaveState into) {
            Object val;
            try {
                val = this.getter.invoke(from);
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
            assert (val != null);
            this.codec.write(into, this.name, val);
        }

        private void load(Object into, SaveState from) {
            if (!from.hasValue(this.name)) {
                return;
            }
            try {
                Object current = this.getter.invoke(into);
                Object val = this.codec.read(from, this.name, current);
                if (val == null || val == current) {
                    return;
                }
                if (this.setter == null) {
                    throw new IllegalAccessException("Codec cannot modify final field: " + this.name);
                }
                this.setter.invoke(into, val);
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        }

        static {
            ConfigStateField.addCodec(Boolean.TYPE, BooleanConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(Boolean.class, BooleanConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(Byte.TYPE, ByteConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(Byte.class, ByteConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(Short.TYPE, ShortConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(Short.class, ShortConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(Integer.TYPE, IntConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(Integer.class, IntConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(Long.TYPE, LongConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(Long.class, LongConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(Float.TYPE, FloatConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(Float.class, FloatConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(Double.TYPE, DoubleConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(Double.class, DoubleConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(String.class, StringConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(boolean[].class, BooleanArrayConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(byte[].class, ByteArrayConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(short[].class, ShortArrayConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(int[].class, IntArrayConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(long[].class, LongArrayConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(float[].class, FloatArrayConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(double[].class, DoubleArrayConfigFieldCodec.INSTANCE);
            ConfigStateField.addCodec(String[].class, StringArrayConfigFieldCodec.INSTANCE);
        }
    }

    public static class EnumConfigFieldCodec
    implements ConfigFieldCodec<Enum<?>> {
        public static final EnumConfigFieldCodec INSTANCE = new EnumConfigFieldCodec();

        @Override
        public Enum<?> read(SaveState state, String name, Enum<?> current) {
            return state.getEnum(name, null);
        }

        @Override
        public void write(SaveState state, String name, Enum<?> value) {
            state.putEnum(name, value);
        }
    }

    public static class StringArrayConfigFieldCodec
    implements ConfigFieldCodec<String[]> {
        public static final StringArrayConfigFieldCodec INSTANCE = new StringArrayConfigFieldCodec();

        @Override
        public String[] read(SaveState state, String name, String[] current) {
            return state.getStrings(name, null);
        }

        @Override
        public void write(SaveState state, String name, String[] value) {
            state.putStrings(name, value);
        }
    }

    public static class DoubleArrayConfigFieldCodec
    implements ConfigFieldCodec<double[]> {
        public static final DoubleArrayConfigFieldCodec INSTANCE = new DoubleArrayConfigFieldCodec();

        @Override
        public double[] read(SaveState state, String name, double[] current) {
            return state.getDoubles(name, null);
        }

        @Override
        public void write(SaveState state, String name, double[] value) {
            state.putDoubles(name, value);
        }
    }

    public static class FloatArrayConfigFieldCodec
    implements ConfigFieldCodec<float[]> {
        public static final FloatArrayConfigFieldCodec INSTANCE = new FloatArrayConfigFieldCodec();

        @Override
        public float[] read(SaveState state, String name, float[] current) {
            return state.getFloats(name, null);
        }

        @Override
        public void write(SaveState state, String name, float[] value) {
            state.putFloats(name, value);
        }
    }

    public static class LongArrayConfigFieldCodec
    implements ConfigFieldCodec<long[]> {
        public static final LongArrayConfigFieldCodec INSTANCE = new LongArrayConfigFieldCodec();

        @Override
        public long[] read(SaveState state, String name, long[] current) {
            return state.getLongs(name, null);
        }

        @Override
        public void write(SaveState state, String name, long[] value) {
            state.putLongs(name, value);
        }
    }

    public static class IntArrayConfigFieldCodec
    implements ConfigFieldCodec<int[]> {
        public static final IntArrayConfigFieldCodec INSTANCE = new IntArrayConfigFieldCodec();

        @Override
        public int[] read(SaveState state, String name, int[] current) {
            return state.getInts(name, null);
        }

        @Override
        public void write(SaveState state, String name, int[] value) {
            state.putInts(name, value);
        }
    }

    public static class ShortArrayConfigFieldCodec
    implements ConfigFieldCodec<short[]> {
        public static final ShortArrayConfigFieldCodec INSTANCE = new ShortArrayConfigFieldCodec();

        @Override
        public short[] read(SaveState state, String name, short[] current) {
            return state.getShorts(name, null);
        }

        @Override
        public void write(SaveState state, String name, short[] value) {
            state.putShorts(name, value);
        }
    }

    public static class ByteArrayConfigFieldCodec
    implements ConfigFieldCodec<byte[]> {
        public static final ByteArrayConfigFieldCodec INSTANCE = new ByteArrayConfigFieldCodec();

        @Override
        public byte[] read(SaveState state, String name, byte[] current) {
            return state.getBytes(name, null);
        }

        @Override
        public void write(SaveState state, String name, byte[] value) {
            state.putBytes(name, value);
        }
    }

    public static class BooleanArrayConfigFieldCodec
    implements ConfigFieldCodec<boolean[]> {
        public static final BooleanArrayConfigFieldCodec INSTANCE = new BooleanArrayConfigFieldCodec();

        @Override
        public boolean[] read(SaveState state, String name, boolean[] current) {
            return state.getBooleans(name, null);
        }

        @Override
        public void write(SaveState state, String name, boolean[] value) {
            state.putBooleans(name, value);
        }
    }

    public static class StringConfigFieldCodec
    implements ConfigFieldCodec<String> {
        public static final StringConfigFieldCodec INSTANCE = new StringConfigFieldCodec();

        @Override
        public String read(SaveState state, String name, String current) {
            return state.getString(name, null);
        }

        @Override
        public void write(SaveState state, String name, String value) {
            state.putString(name, value);
        }
    }

    public static class DoubleConfigFieldCodec
    implements ConfigFieldCodec<Double> {
        public static final DoubleConfigFieldCodec INSTANCE = new DoubleConfigFieldCodec();

        @Override
        public Double read(SaveState state, String name, Double current) {
            return state.getDouble(name, 0.0);
        }

        @Override
        public void write(SaveState state, String name, Double value) {
            state.putDouble(name, value.doubleValue());
        }
    }

    public static class FloatConfigFieldCodec
    implements ConfigFieldCodec<Float> {
        public static final FloatConfigFieldCodec INSTANCE = new FloatConfigFieldCodec();

        @Override
        public Float read(SaveState state, String name, Float current) {
            return Float.valueOf(state.getFloat(name, 0.0f));
        }

        @Override
        public void write(SaveState state, String name, Float value) {
            state.putFloat(name, value.floatValue());
        }
    }

    public static class LongConfigFieldCodec
    implements ConfigFieldCodec<Long> {
        public static final LongConfigFieldCodec INSTANCE = new LongConfigFieldCodec();

        @Override
        public Long read(SaveState state, String name, Long current) {
            return state.getLong(name, 0L);
        }

        @Override
        public void write(SaveState state, String name, Long value) {
            state.putLong(name, value.longValue());
        }
    }

    public static class IntConfigFieldCodec
    implements ConfigFieldCodec<Integer> {
        public static final IntConfigFieldCodec INSTANCE = new IntConfigFieldCodec();

        @Override
        public Integer read(SaveState state, String name, Integer current) {
            return state.getInt(name, 0);
        }

        @Override
        public void write(SaveState state, String name, Integer value) {
            state.putInt(name, value.intValue());
        }
    }

    public static class ShortConfigFieldCodec
    implements ConfigFieldCodec<Short> {
        public static final ShortConfigFieldCodec INSTANCE = new ShortConfigFieldCodec();

        @Override
        public Short read(SaveState state, String name, Short current) {
            return state.getShort(name, (short)0);
        }

        @Override
        public void write(SaveState state, String name, Short value) {
            state.putShort(name, value.shortValue());
        }
    }

    public static class ByteConfigFieldCodec
    implements ConfigFieldCodec<Byte> {
        public static final ByteConfigFieldCodec INSTANCE = new ByteConfigFieldCodec();

        @Override
        public Byte read(SaveState state, String name, Byte current) {
            return state.getByte(name, (byte)0);
        }

        @Override
        public void write(SaveState state, String name, Byte value) {
            state.putByte(name, value.byteValue());
        }
    }

    public static class BooleanConfigFieldCodec
    implements ConfigFieldCodec<Boolean> {
        public static final BooleanConfigFieldCodec INSTANCE = new BooleanConfigFieldCodec();

        @Override
        public Boolean read(SaveState state, String name, Boolean current) {
            return state.getBoolean(name, false);
        }

        @Override
        public void write(SaveState state, String name, Boolean value) {
            state.putBoolean(name, value.booleanValue());
        }
    }

    public static interface ConfigFieldCodec<T> {
        public T read(SaveState var1, String var2, T var3);

        public void write(SaveState var1, String var2, T var3);
    }
}

