/*
 * Decompiled with CFR 0.152.
 */
package ghidra.generic.util.datastruct;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.UnsignedLong;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.HashMap;
import java.util.Map;

public class SemisparseByteArray {
    public static final int BLOCK_SIZE = 4096;
    private final Map<Long, byte[]> blocks = new HashMap<Long, byte[]>();
    private final RangeSet<UnsignedLong> defined = TreeRangeSet.create();

    public synchronized void clear() {
        this.defined.clear();
        this.blocks.clear();
    }

    public synchronized void getData(long loc, byte[] data) {
        this.getData(loc, data, 0, data.length);
    }

    public synchronized void getData(long loc, byte[] data, int offset, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length: " + length);
        }
        long blockNum = Long.divideUnsigned(loc, 4096L);
        int blockOffset = (int)Long.remainderUnsigned(loc, 4096L);
        byte[] block = this.blocks.get(blockNum);
        int amt = Math.min(length, 4096 - blockOffset);
        if (block != null) {
            System.arraycopy(block, blockOffset, data, offset, amt);
        }
        for (int cur = amt; cur < length; cur += amt) {
            if (++blockNum == 0L) {
                throw new BufferUnderflowException();
            }
            block = this.blocks.get(blockNum);
            amt = Math.min(length - cur, 4096);
            if (block == null) continue;
            System.arraycopy(block, 0, data, cur + offset, amt);
        }
    }

    public synchronized RangeSet<UnsignedLong> getInitialized(long a, long b) {
        UnsignedLong ua = UnsignedLong.fromLongBits((long)a);
        UnsignedLong ub = UnsignedLong.fromLongBits((long)b);
        return ImmutableRangeSet.copyOf((RangeSet)this.defined.subRangeSet(Range.closed((Comparable)ua, (Comparable)ub)));
    }

    public synchronized boolean isInitialized(long a, long b) {
        UnsignedLong ua = UnsignedLong.fromLongBits((long)a);
        UnsignedLong ub = UnsignedLong.fromLongBits((long)b);
        return this.defined.encloses(Range.closed((Comparable)ua, (Comparable)ub));
    }

    public synchronized boolean isInitialized(long a) {
        return this.defined.contains((Comparable)UnsignedLong.fromLongBits((long)a));
    }

    public synchronized RangeSet<UnsignedLong> getUninitialized(long a, long b) {
        UnsignedLong ua = UnsignedLong.fromLongBits((long)a);
        UnsignedLong ub = UnsignedLong.fromLongBits((long)b);
        return ImmutableRangeSet.copyOf((RangeSet)this.defined.complement().subRangeSet(Range.closed((Comparable)ua, (Comparable)ub)));
    }

    public synchronized void putData(long loc, byte[] data) {
        this.putData(loc, data, 0, data.length);
    }

    public synchronized void putData(long loc, byte[] data, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (length < 0) {
            throw new IllegalArgumentException("length: " + length);
        }
        if (Long.compareUnsigned(loc + (long)length - 1L, loc) < 0) {
            throw new IndexOutOfBoundsException("given offset and length would exceed ULONG_MAX");
        }
        UnsignedLong uLoc = UnsignedLong.fromLongBits((long)loc);
        UnsignedLong uEnd = UnsignedLong.fromLongBits((long)(loc + (long)length));
        if (uEnd.longValue() == 0L) {
            this.defined.add(Range.closed((Comparable)uLoc, (Comparable)UnsignedLong.MAX_VALUE));
        } else {
            this.defined.add(Range.closedOpen((Comparable)uLoc, (Comparable)uEnd));
        }
        long blockNum = Long.divideUnsigned(loc, 4096L);
        int blockOffset = (int)Long.remainderUnsigned(loc, 4096L);
        byte[] block = this.blocks.computeIfAbsent(blockNum, n -> new byte[4096]);
        int amt = Math.min(length, 4096 - blockOffset);
        System.arraycopy(data, offset, block, blockOffset, amt);
        for (int cur = amt; cur < length; cur += amt) {
            if (++blockNum == 0L) {
                throw new BufferOverflowException();
            }
            block = this.blocks.computeIfAbsent(blockNum, n -> new byte[4096]);
            amt = Math.min(length - cur, 4096);
            System.arraycopy(data, cur + offset, block, 0, amt);
        }
    }

    public synchronized int contiguousAvailableAfter(long loc) {
        UnsignedLong uLoc = UnsignedLong.fromLongBits((long)loc);
        Range rng = this.defined.rangeContaining((Comparable)uLoc);
        if (rng == null) {
            return 0;
        }
        UnsignedLong diff = ((UnsignedLong)rng.upperEndpoint()).minus(uLoc);
        if (diff.longValue() == -1L) {
            return Integer.MAX_VALUE;
        }
        if (rng.upperBoundType() == BoundType.CLOSED) {
            diff = diff.plus(UnsignedLong.ONE);
        }
        if (diff.compareTo(UnsignedLong.valueOf((long)Integer.MAX_VALUE)) >= 0) {
            return Integer.MAX_VALUE;
        }
        return diff.intValue();
    }
}

