/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.BinaryField;
import db.BooleanField;
import db.ByteField;
import db.DBHandle;
import db.DBRecord;
import db.IntField;
import db.LongField;
import db.Schema;
import db.ShortField;
import db.StringField;
import db.Table;
import ghidra.util.Msg;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBAnnotatedObjectFactory;
import ghidra.util.database.DBCachedDomainObjectAdapter;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.SchemaBuilder;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.database.err.NoDefaultCodecException;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DBCachedObjectStoreFactory {
    private static final Map<Class<? extends DBAnnotatedObject>, TableInfo<?>> INFO_MAP = new HashMap();
    private final DBHandle handle;
    private final DBCachedDomainObjectAdapter adapter;

    private static Class<?> getDefaultCodecClass(Class<?> type) {
        if (type == Boolean.TYPE || type == Boolean.class) {
            return BooleanDBFieldCodec.class;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return ByteDBFieldCodec.class;
        }
        if (type == Short.TYPE || type == Short.class) {
            return ShortDBFieldCodec.class;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return IntDBFieldCodec.class;
        }
        if (type == Long.TYPE || type == Long.class) {
            return LongDBFieldCodec.class;
        }
        if (type == String.class) {
            return StringDBFieldCodec.class;
        }
        if (type == byte[].class) {
            return ByteArrayDBFieldCodec.class;
        }
        if (type == long[].class) {
            return LongArrayDBFieldCodec.class;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return EnumDBByteFieldCodec.class;
        }
        throw new NoDefaultCodecException(type + " does not have a default codec. Please specify a codec.");
    }

    private static <OT extends DBAnnotatedObject> DBFieldCodec<?, OT, ?> makeCodec(Class<OT> objectType, Field field, int column) throws IllegalArgumentException {
        Class<?> type = field.getType();
        DBAnnotatedField annotation = field.getAnnotation(DBAnnotatedField.class);
        assert (annotation != null);
        Class codecCls = annotation.codec();
        if (codecCls == DBAnnotatedField.DefaultCodec.class) {
            codecCls = DBCachedObjectStoreFactory.getDefaultCodecClass(type);
        }
        try {
            Constructor<? extends DBFieldCodec> codecCons = codecCls.getConstructor(Class.class, Field.class, Integer.TYPE);
            return codecCons.newInstance(objectType, field, column);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends DBAnnotatedObject> TableInfo<T> getInfo(Class<T> cls) {
        Map<Class<? extends DBAnnotatedObject>, TableInfo<?>> map = INFO_MAP;
        synchronized (map) {
            return INFO_MAP.computeIfAbsent(cls, DBCachedObjectStoreFactory::buildInfo);
        }
    }

    static <OT extends DBAnnotatedObject> List<DBFieldCodec<?, OT, ?>> getCodecs(Class<OT> objectType) {
        return DBCachedObjectStoreFactory.getInfo(objectType).codecs;
    }

    private static <OT extends DBAnnotatedObject> TableInfo<OT> buildInfo(Class<OT> objectType) {
        DBAnnotatedObjectInfo info = objectType.getAnnotation(DBAnnotatedObjectInfo.class);
        if (info == null) {
            throw new IllegalArgumentException(DBAnnotatedObject.class.getSimpleName() + " " + objectType.getName() + " must have @" + DBAnnotatedObjectInfo.class.getSimpleName() + " annotation");
        }
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        ArrayList<Field> indexFields = new ArrayList<Field>();
        DBCachedObjectStoreFactory.collectFields(objectType, fields, indexFields);
        TableInfo<OT> tableInfo = new TableInfo<OT>(objectType, info.version(), fields, indexFields);
        tableInfo.writeColumnNumbers(objectType);
        return tableInfo;
    }

    private static void collectFields(Class<?> cls, Map<String, Field> fields, List<Field> indexFields) {
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            DBCachedObjectStoreFactory.collectFields(superclass, fields, indexFields);
        }
        for (Field f : cls.getDeclaredFields()) {
            DBAnnotatedField annotation = f.getAnnotation(DBAnnotatedField.class);
            if (annotation == null) continue;
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) {
                throw new IllegalArgumentException(DBAnnotatedField.class.getSimpleName() + " must be non-static and non-final");
            }
            f.setAccessible(true);
            Field old = fields.put(annotation.column(), f);
            if (old != null) {
                indexFields.remove(old);
            }
            if (!annotation.indexed()) continue;
            indexFields.add(f);
        }
    }

    public DBCachedObjectStoreFactory(DBCachedDomainObjectAdapter adapter) {
        this.handle = adapter.getDBHandle();
        this.adapter = adapter;
    }

    public Table getOrCreateTable(String name, Class<? extends DBAnnotatedObject> cls, boolean upgradable) throws IOException, VersionException {
        int latestVersion;
        int tableVersion;
        Table table = this.handle.getTable(name);
        TableInfo<? extends DBAnnotatedObject> info = DBCachedObjectStoreFactory.getInfo(cls);
        if (table == null) {
            table = this.handle.createTable(name, info.schema, info.indexColumns);
        }
        if ((tableVersion = table.getSchema().getVersion()) != (latestVersion = info.schema.getVersion())) {
            throw new VersionException(upgradable && tableVersion < latestVersion);
        }
        return table;
    }

    public <T extends DBAnnotatedObject> DBCachedObjectStore<T> getOrCreateCachedStore(String tableName, Class<T> cls, DBAnnotatedObjectFactory<T> factory, boolean upgradable) throws VersionException, IOException {
        Table table = this.getOrCreateTable(tableName, cls, upgradable);
        return new DBCachedObjectStore<T>(this.adapter, cls, factory, table);
    }

    private static class TableInfo<OT extends DBAnnotatedObject> {
        public final Schema schema;
        public final int[] indexColumns;
        public final ArrayList<DBFieldCodec<?, OT, ?>> codecs;

        TableInfo(Class<OT> objectType, int schemaVersion, Map<String, Field> fieldsByColumnName, Collection<Field> indexFields) {
            this.codecs = new ArrayList(fieldsByColumnName.size());
            ArrayList<Integer> indexCols = new ArrayList<Integer>(indexFields.size());
            SchemaBuilder builder = new SchemaBuilder();
            builder.version(schemaVersion);
            builder.keyField("Key", LongField.class);
            for (Map.Entry<String, Field> ent : fieldsByColumnName.entrySet()) {
                int next = builder.fieldCount();
                Field field = ent.getValue();
                DBFieldCodec<?, OT, ?> codec = DBCachedObjectStoreFactory.makeCodec(objectType, field, next);
                if (indexFields.contains(field)) {
                    indexCols.add(next);
                }
                this.codecs.add(codec);
                builder.field(ent.getKey(), codec.getFieldType());
            }
            this.schema = builder.build();
            this.indexColumns = new int[indexCols.size()];
            for (int i = 0; i < this.indexColumns.length; ++i) {
                this.indexColumns[i] = (Integer)indexCols.get(i);
            }
        }

        void writeColumnNumbers(Class<? extends DBAnnotatedObject> objectType, Map<String, Integer> numbersByName) {
            Class<? extends DBAnnotatedObject> superType = objectType.getSuperclass();
            if (DBAnnotatedObject.class.isAssignableFrom(superType)) {
                this.writeColumnNumbers(superType.asSubclass(DBAnnotatedObject.class), numbersByName);
            }
            for (Field f : objectType.getDeclaredFields()) {
                DBAnnotatedColumn annotation = f.getAnnotation(DBAnnotatedColumn.class);
                if (annotation == null) continue;
                int mod = f.getModifiers();
                if (!Modifier.isStatic(mod)) {
                    throw new IllegalArgumentException("@" + DBAnnotatedColumn.class.getSimpleName() + " fields must be static. Got " + f);
                }
                if (f.getType() != DBObjectColumn.class) {
                    throw new IllegalArgumentException("@" + DBAnnotatedColumn.class.getSimpleName() + " fields must be " + DBObjectColumn.class.getSimpleName() + " type. Got " + f);
                }
                String name = annotation.value();
                Integer columnNumber = numbersByName.get(name);
                if (columnNumber == null) {
                    throw new IllegalArgumentException("Cannot find column '" + name + "' for @" + DBAnnotatedColumn.class.getSimpleName() + " on " + f);
                }
                f.setAccessible(true);
                try {
                    DBObjectColumn already = (DBObjectColumn)f.get(null);
                    if (already == null) {
                        f.set(null, DBObjectColumn.get(columnNumber));
                        continue;
                    }
                    if (already.columnNumber == columnNumber) continue;
                    throw new AssertionError();
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }

        void writeColumnNumbers(Class<? extends DBAnnotatedObject> objectType) {
            HashMap<String, Integer> numbersByName = new HashMap<String, Integer>();
            String[] names = this.schema.getFieldNames();
            for (int i = 0; i < names.length; ++i) {
                numbersByName.put(names[i], i);
            }
            this.writeColumnNumbers(objectType, numbersByName);
        }
    }

    public static class EnumDBByteFieldCodec<OT extends DBAnnotatedObject, E extends Enum<E>>
    extends AbstractDBFieldCodec<E, OT, ByteField> {
        private final E[] consts;

        public EnumDBByteFieldCodec(Class<OT> objectType, Field field, int column) {
            super(field.getType(), objectType, ByteField.class, field, column);
            this.consts = (Enum[])this.valueType.getEnumConstants();
            if (this.consts.length > 255) {
                throw new IllegalArgumentException("Too many constants in " + this.valueType + " to encode as a byte");
            }
        }

        @Override
        protected void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            Enum value = (Enum)this.getValue(obj);
            if (value == null) {
                record.setByteValue(this.column, (byte)-1);
            } else {
                record.setByteValue(this.column, (byte)value.ordinal());
            }
        }

        @Override
        public void store(E value, ByteField f) {
            if (value == null) {
                f.setByteValue((byte)-1);
            } else {
                f.setByteValue((byte)((Enum)value).ordinal());
            }
        }

        @Override
        protected void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            byte b = record.getByteValue(this.column);
            if (b == -1) {
                this.setValue(obj, null);
            } else {
                this.setValue(obj, this.consts[b & 0xFF]);
            }
        }
    }

    public static class LongArrayDBFieldCodec<OT extends DBAnnotatedObject>
    extends AbstractDBFieldCodec<long[], OT, BinaryField> {
        public LongArrayDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(long[].class, objectType, BinaryField.class, field, column);
        }

        protected byte[] encode(long[] val) {
            if (val == null) {
                return null;
            }
            ByteBuffer bytes = ByteBuffer.allocate(val.length * 8);
            bytes.asLongBuffer().put(val);
            return bytes.array();
        }

        protected long[] decode(byte[] enc) {
            if (enc == null) {
                return null;
            }
            if (enc.length % 8 != 0) {
                Msg.warn((Object)this, (Object)"Database record for long[] has remaning bytes");
            }
            int len = enc.length / 8;
            ByteBuffer bytes = ByteBuffer.wrap(enc);
            long[] val = new long[len];
            bytes.asLongBuffer().get(val);
            return val;
        }

        @Override
        protected void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setBinaryData(this.column, this.encode((long[])this.getValue(obj)));
        }

        @Override
        public void store(long[] value, BinaryField f) {
            f.setBinaryData(this.encode(value));
        }

        @Override
        protected void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(obj, this.decode(record.getBinaryData(this.column)));
        }
    }

    public static class ByteArrayDBFieldCodec<OT extends DBAnnotatedObject>
    extends AbstractDBFieldCodec<byte[], OT, BinaryField> {
        public ByteArrayDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(byte[].class, objectType, BinaryField.class, field, column);
        }

        @Override
        public void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setBinaryData(this.column, (byte[])this.getValue(obj));
        }

        @Override
        public void store(byte[] value, BinaryField f) {
            f.setBinaryData(value);
        }

        @Override
        public void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(obj, record.getBinaryData(this.column));
        }
    }

    public static class StringDBFieldCodec<OT extends DBAnnotatedObject>
    extends AbstractDBFieldCodec<String, OT, StringField> {
        public StringDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(String.class, objectType, StringField.class, field, column);
        }

        @Override
        public void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setString(this.column, (String)this.getValue(obj));
        }

        @Override
        public void store(String value, StringField f) {
            f.setString(value);
        }

        @Override
        public void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.setValue(obj, record.getString(this.column));
        }
    }

    public static class LongDBFieldCodec<OT extends DBAnnotatedObject>
    extends AbstractDBFieldCodec<Long, OT, LongField> {
        public LongDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(Long.TYPE, objectType, LongField.class, field, column);
        }

        @Override
        public void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setLongValue(this.column, this.field.getLong(obj));
        }

        @Override
        public void store(Long value, LongField f) {
            f.setLongValue(value.longValue());
        }

        @Override
        public void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.field.setLong(obj, record.getLongValue(this.column));
        }
    }

    public static class IntDBFieldCodec<OT extends DBAnnotatedObject>
    extends AbstractDBFieldCodec<Integer, OT, IntField> {
        public IntDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(Integer.TYPE, objectType, IntField.class, field, column);
        }

        @Override
        public void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setIntValue(this.column, this.field.getInt(obj));
        }

        @Override
        public void store(Integer value, IntField f) {
            f.setIntValue(value.intValue());
        }

        @Override
        public void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.field.setInt(obj, record.getIntValue(this.column));
        }
    }

    public static class ShortDBFieldCodec<OT extends DBAnnotatedObject>
    extends AbstractDBFieldCodec<Short, OT, ShortField> {
        public ShortDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(Short.TYPE, objectType, ShortField.class, field, column);
        }

        @Override
        public void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setShortValue(this.column, this.field.getShort(obj));
        }

        @Override
        public void store(Short value, ShortField f) {
            f.setShortValue(value.shortValue());
        }

        @Override
        public void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.field.setShort(obj, record.getShortValue(this.column));
        }
    }

    public static class ByteDBFieldCodec<OT extends DBAnnotatedObject>
    extends AbstractDBFieldCodec<Byte, OT, ByteField> {
        public ByteDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(Byte.TYPE, objectType, ByteField.class, field, column);
        }

        @Override
        public void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setByteValue(this.column, this.field.getByte(obj));
        }

        @Override
        public void store(Byte value, ByteField f) {
            f.setByteValue(value.byteValue());
        }

        @Override
        public void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.field.setByte(obj, record.getByteValue(this.column));
        }
    }

    public static class BooleanDBFieldCodec<OT extends DBAnnotatedObject>
    extends AbstractDBFieldCodec<Boolean, OT, BooleanField> {
        public BooleanDBFieldCodec(Class<OT> objectType, Field field, int column) {
            super(Boolean.TYPE, objectType, BooleanField.class, field, column);
        }

        @Override
        public void doStore(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setBooleanValue(this.column, this.field.getBoolean(obj));
        }

        @Override
        public void store(Boolean value, BooleanField f) {
            f.setBooleanValue(value.booleanValue());
        }

        @Override
        public void doLoad(OT obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            this.field.setBoolean(obj, record.getBooleanValue(this.column));
        }
    }

    public static abstract class AbstractDBFieldCodec<VT, OT extends DBAnnotatedObject, FT extends db.Field>
    implements DBFieldCodec<VT, OT, FT> {
        protected final Class<VT> valueType;
        protected final Class<OT> objectType;
        protected final Class<FT> fieldType;
        protected final Field field;
        protected final int column;

        public AbstractDBFieldCodec(Class<VT> valueType, Class<OT> objectType, Class<FT> fieldType, Field field, int column) {
            if (!field.getDeclaringClass().isAssignableFrom(objectType)) {
                throw new IllegalArgumentException("Given field does not apply to given object type");
            }
            if (field.getType() != valueType) {
                throw new IllegalArgumentException("Given field does not have the given type: " + valueType + " != " + field);
            }
            this.valueType = valueType;
            this.objectType = objectType;
            this.fieldType = fieldType;
            this.field = field;
            this.column = column;
        }

        @Override
        public void store(OT obj, DBRecord record) {
            try {
                this.doStore(obj, record);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void load(OT obj, DBRecord record) {
            try {
                this.doLoad(obj, record);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public Class<VT> getValueType() {
            return this.valueType;
        }

        @Override
        public Class<OT> getObjectType() {
            return this.objectType;
        }

        @Override
        public Class<FT> getFieldType() {
            return this.fieldType;
        }

        @Override
        public VT getValue(OT obj) {
            try {
                return this.valueType.cast(this.field.get(obj));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
        }

        protected void setValue(OT obj, VT value) throws IllegalArgumentException, IllegalAccessException {
            this.field.set(obj, value);
        }

        protected abstract void doStore(OT var1, DBRecord var2) throws IllegalArgumentException, IllegalAccessException;

        protected abstract void doLoad(OT var1, DBRecord var2) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface DBFieldCodec<VT, OT extends DBAnnotatedObject, FT extends db.Field> {
        public void store(OT var1, DBRecord var2);

        public void store(VT var1, FT var2);

        public void load(OT var1, DBRecord var2);

        public Class<VT> getValueType();

        public Class<OT> getObjectType();

        public Class<FT> getFieldType();

        default public FT encodeField(VT value) {
            try {
                db.Field field = (db.Field)this.getFieldType().getConstructor(new Class[0]).newInstance(new Object[0]);
                this.store(value, field);
                return (FT)field;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }

        public VT getValue(OT var1);
    }
}

